/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina.xs;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.communicationservices.MinaXSCommunicationService;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaServer;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaRequestHandler;
import de.aristaflow.adept2.base.communication.mina.xs.MinaXSCodecFactory;
import java.net.InetAddress;
import java.net.URI;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public class MinaXSServer
extends AbstractMinaServer<byte[], byte[]> {
    public MinaXSServer(String instanceName, InetAddress serverHostIP, int port, boolean useSSL, String sslCertFileName, String sslKeystorePass, MinaXSCommunicationService communicationService) {
        super(serverHostIP, port, -1L, useSSL, sslCertFileName, sslKeystorePass, String.format("MinaXSServer (%s)", instanceName), communicationService);
    }

    @Override
    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaXSCodecFactory();
    }

    @Override
    protected byte[] processInputAndReturn(URI remoteObjectIdentifier, byte[] input) throws CommunicationStackException {
        throw new CommunicationStackException("The MinaXSServer should not be used as a client. The method processInputAndReturn(...) is not implemented!");
    }

    @Override
    protected void shutdownStackLayer() {
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws CommunicationStackException {
        if (!(message instanceof MinaMessage)) {
            String msg = String.format("Unexpected message type on server side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
        MinaMessage mm = (MinaMessage)message;
        String msg = String.format("The MinaXSServer received a message with the ID '%s'.", mm.getID());
        this.logger.finest(msg);
        this.serverPool.execute(new MinaRequestHandler(mm.getID(), (byte[])mm.getMessage(), session, this.communicationService.getSkeletonCommunicationStack()));
    }
}

