/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.serialisation;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultSessionFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AFConverter
extends AbstractReflectionConverter {
    private final Logger logger = LoggerTools.getLogger((Object)this);
    private static final String SECURITY_TOKEN = "securityToken";
    private static final String PUBLIC_KEY = "publicKey";

    public AFConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(DefaultSessionFactory.class) || type.equals(UUID.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (source instanceof DefaultSessionFactory) {
            String msg = String.format("Marshal object %s of type %s.", source, source.getClass());
            this.logger.info(msg);
            DefaultSessionFactory sf = (DefaultSessionFactory)source;
            try {
                Field tokenField = DefaultSessionFactory.class.getDeclaredField(SECURITY_TOKEN);
                tokenField.setAccessible(true);
                writer.startNode(SECURITY_TOKEN);
                super.marshal(tokenField.get(sf), writer, context);
                writer.endNode();
                Field keyField = DefaultSessionFactory.class.getDeclaredField(PUBLIC_KEY);
                keyField.setAccessible(true);
                writer.startNode(PUBLIC_KEY);
                super.marshal(keyField.get(sf), writer, context);
                writer.endNode();
            }
            catch (SecurityException se) {
                msg = String.format("A SecurityException occurred while trying to access the private fields of %s [%s] with reflection.", source, source.getClass());
                this.logger.log(Level.SEVERE, msg, se);
                throw new Error(msg, se);
            }
            catch (NoSuchFieldException nsfe) {
                msg = String.format("A NoSuchFieldException occurred while trying to access the private fields of %s [%s] with reflection.", source, source.getClass());
                this.logger.log(Level.SEVERE, msg, nsfe);
                throw new Error(msg, nsfe);
            }
            catch (IllegalArgumentException iae) {
                msg = String.format("An IllegalArgumentException occurred while trying to access the private fields of %s [%s] with reflection.", source, source.getClass());
                this.logger.log(Level.SEVERE, msg, iae);
                throw new Error(msg, iae);
            }
            catch (IllegalAccessException iae) {
                msg = String.format("An IllegalAccessException occurred while trying to access the private fields of %s [%s] with reflection.", source, source.getClass());
                this.logger.log(Level.SEVERE, msg, iae);
                throw new Error(msg, iae);
            }
        } else if (source instanceof UUID) {
            String msg = String.format("Marshal object %s of type %s.", source, source.getClass());
            this.logger.info(msg);
            UUID uuid = (UUID)source;
            writer.addAttribute("serialization", "custom");
            writer.startNode(source.getClass().getName());
            writer.startNode("default");
            writer.startNode("leastSigBits");
            writer.setValue(Long.toString(uuid.getLeastSignificantBits()));
            writer.endNode();
            writer.startNode("mostSigBits");
            writer.setValue(Long.toString(uuid.getMostSignificantBits()));
            writer.endNode();
            writer.endNode();
            writer.endNode();
        } else {
            String msg = String.format("Delegating marshalling of object %s with type %s to super class.", source, source.getClass());
            this.logger.fine(msg);
            super.marshal(source, writer, context);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class clazz = context.getRequiredType();
        String msg = String.format("Unmarshal %s", clazz);
        this.logger.info(msg);
        if (DefaultSessionFactory.class.equals((Object)clazz)) {
            reader.moveDown();
            SignedSecurityToken token = (SignedSecurityToken)context.convertAnother(null, SignedSecurityToken.class);
            reader.moveUp();
            return new DefaultSessionFactory(token, null);
        }
        if (UUID.class.equals((Object)clazz)) {
            reader.moveDown();
            reader.moveDown();
            reader.moveDown();
            long least = Long.parseLong(reader.getValue());
            reader.moveUp();
            reader.moveDown();
            long most = Long.parseLong(reader.getValue());
            reader.moveUp();
            reader.moveUp();
            reader.moveUp();
            return new UUID(most, least);
        }
        msg = String.format("Unable to unmarshal %s", clazz);
        this.logger.warning(msg);
        return null;
    }
}

