/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.serialisation;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;

public class JVM {
    private ReflectionProvider reflectionProvider;
    private transient Map loaderCache = new HashMap();
    private final boolean supportsAWT = this.loadClass("java.awt.Color") != null;
    private final boolean supportsSwing = this.loadClass("javax.swing.LookAndFeel") != null;
    private final boolean supportsSQL = this.loadClass("java.sql.Date") != null;
    private static final String vendor = System.getProperty("java.vm.vendor");
    private static final float majorJavaVersion = JVM.getMajorJavaVersion();
    private static final boolean reverseFieldOrder = JVM.isHarmony() || JVM.isIBM() && !JVM.is15();
    static final float DEFAULT_JAVA_VERSION = 1.3f;

    private static final float getMajorJavaVersion() {
        try {
            return JVM.isAndroid() ? 1.5f : Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {
            return 1.3f;
        }
    }

    public static boolean is14() {
        return majorJavaVersion >= 1.4f;
    }

    public static boolean is15() {
        return majorJavaVersion >= 1.5f;
    }

    public static boolean is16() {
        return majorJavaVersion >= 1.6f;
    }

    public static boolean is17() {
        return majorJavaVersion >= 1.7f;
    }

    private static boolean isSun() {
        return vendor.indexOf("Sun") != -1;
    }

    private static boolean isOracle() {
        return vendor.indexOf("Oracle") != -1;
    }

    private static boolean isApple() {
        return vendor.indexOf("Apple") != -1;
    }

    private static boolean isHPUX() {
        return vendor.indexOf("Hewlett-Packard Company") != -1;
    }

    private static boolean isIBM() {
        return vendor.indexOf("IBM") != -1;
    }

    private static boolean isBlackdown() {
        return vendor.indexOf("Blackdown") != -1;
    }

    private static boolean isDiablo() {
        return vendor.indexOf("FreeBSD Foundation") != -1;
    }

    private static boolean isHarmony() {
        return vendor.indexOf("Apache Software Foundation") != -1;
    }

    private static boolean isAndroid() {
        return vendor.indexOf("Android") != -1;
    }

    private static boolean isBEAWithUnsafeSupport() {
        if (vendor.indexOf("BEA") != -1) {
            String vmVersion = System.getProperty("java.vm.version");
            if (vmVersion.startsWith("R")) {
                return true;
            }
            String vmInfo = System.getProperty("java.vm.info");
            if (vmInfo != null) {
                return vmInfo.startsWith("R25.1") || vmInfo.startsWith("R25.2");
            }
        }
        return false;
    }

    private static boolean isHitachi() {
        return vendor.indexOf("Hitachi") != -1;
    }

    private static boolean isSAP() {
        return vendor.indexOf("SAP AG") != -1;
    }

    public Class loadClass(String name) {
        try {
            Class cached;
            WeakReference reference = (WeakReference)this.loaderCache.get(name);
            if (reference != null && (cached = (Class)reference.get()) != null) {
                return cached;
            }
            Class<?> clazz = Class.forName(name, false, this.getClass().getClassLoader());
            this.loaderCache.put(name, new WeakReference(clazz));
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                Class cls;
                String className = null;
                if (this.canUseHarmonyReflectionProvider()) {
                    className = "com.thoughtworks.xstream.converters.reflection.HarmonyReflectionProvider";
                }
                if (className != null && (cls = this.loadClass(className)) != null) {
                    this.reflectionProvider = (ReflectionProvider)cls.newInstance();
                }
                if (this.reflectionProvider == null) {
                    this.reflectionProvider = this.canUseSun14ReflectionProvider() ? new Sun14ReflectionProvider() : new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException instantiationException) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException illegalAccessException) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (AccessControlException accessControlException) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    private boolean canUseSun14ReflectionProvider() {
        return (JVM.isSun() || JVM.isOracle() || JVM.isApple() || JVM.isHPUX() || JVM.isIBM() || JVM.isBlackdown() || JVM.isBEAWithUnsafeSupport() || JVM.isHitachi() || JVM.isSAP() || JVM.isDiablo()) && JVM.is14() && this.loadClass("sun.misc.Unsafe") != null;
    }

    private boolean canUseHarmonyReflectionProvider() {
        return JVM.isHarmony();
    }

    public static boolean reverseFieldDefinition() {
        return reverseFieldOrder;
    }

    public boolean supportsAWT() {
        return this.supportsAWT;
    }

    public boolean supportsSwing() {
        return this.supportsSwing;
    }

    public boolean supportsSQL() {
        return this.supportsSQL;
    }

    private Object readResolve() {
        this.loaderCache = new HashMap();
        return this;
    }

    public static void main(String[] args) {
        boolean reverse = false;
        Field[] fields = AttributedString.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals("text")) {
                reverse = i > 3;
                break;
            }
            ++i;
        }
        if (reverse) {
            fields = JVM.class.getDeclaredFields();
            i = 0;
            while (i < fields.length) {
                if (fields[i].getName().equals("reflectionProvider")) {
                    reverse = i > 2;
                    break;
                }
                ++i;
            }
        }
        JVM jvm = new JVM();
        System.out.println("XStream JVM diagnostics");
        System.out.println("java.specification.version: " + System.getProperty("java.specification.version"));
        System.out.println("java.vm.vendor: " + vendor);
        System.out.println("Version: " + majorJavaVersion);
        System.out.println("XStream support for enhanced Mode: " + (jvm.canUseSun14ReflectionProvider() || jvm.canUseHarmonyReflectionProvider()));
        System.out.println("Supports AWT: " + jvm.supportsAWT());
        System.out.println("Supports Swing: " + jvm.supportsSwing());
        System.out.println("Supports SQL: " + jvm.supportsSQL());
        System.out.println("Reverse field order detected (may have failed): " + reverse);
        ReflectionProvider bestReflectionProvider = jvm.bestReflectionProvider();
        System.out.println(bestReflectionProvider);
    }
}

