/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.serialisation;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.CommunicationStackLayer;
import de.aristaflow.adept2.base.communication.serialisation.XStreamTools;
import java.net.URI;

public class XStreamDeserialiserSerialiser<T, V>
extends CommunicationStackLayer<byte[], byte[], T, V> {
    public XStreamDeserialiserSerialiser(CommunicationStack<T, V> delegate) {
        super(delegate);
    }

    @Override
    protected T processInput(URI remoteObjectIdentifier, byte[] input) throws CommunicationStackException {
        int retries = 3;
        while (true) {
            try {
                return (T)XStreamTools.deserialise(input);
            }
            catch (CommunicationStackException e) {
                if (retries <= 1) {
                    throw e;
                }
                String infoMessage = String.format("Deserialisation of request from '%s' failed, going to retry deserialisation!", remoteObjectIdentifier);
                this.logger.info(infoMessage);
                --retries;
                continue;
            }
            break;
        }
    }

    @Override
    protected byte[] processOutput(URI remoteObjectIdentifier, V output) throws CommunicationStackException {
        int retries = 3;
        while (true) {
            try {
                return XStreamTools.serialise(remoteObjectIdentifier, output);
            }
            catch (CommunicationStackException e) {
                if (retries <= 1) {
                    throw e;
                }
                String infoMessage = String.format("Serialisation of response for '%s' failed, going to retry serialisation!", remoteObjectIdentifier);
                this.logger.info(infoMessage);
                --retries;
                continue;
            }
            break;
        }
    }

    @Override
    protected void shutdownStackLayer() {
    }
}

