/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.serialisation;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.CommunicationStackLayer;
import de.aristaflow.adept2.base.communication.serialisation.XStreamTools;
import java.net.URI;

public class XStreamSerialiserDeserialiser<I, O>
extends CommunicationStackLayer<I, O, byte[], byte[]> {
    public XStreamSerialiserDeserialiser(CommunicationStack<byte[], byte[]> delegate) {
        super(delegate);
    }

    @Override
    protected byte[] processInput(URI remoteObjectIdentifier, I input) throws CommunicationStackException {
        int retries = 3;
        while (true) {
            try {
                return XStreamTools.serialise(remoteObjectIdentifier, input);
            }
            catch (CommunicationStackException e) {
                if (retries <= 1) {
                    throw e;
                }
                String infoMessage = String.format("Serialisation of request for '%s' failed, going to retry serialisation!", remoteObjectIdentifier);
                this.logger.info(infoMessage);
                --retries;
                continue;
            }
            break;
        }
    }

    @Override
    protected O processOutput(URI remoteObjectIdentifier, byte[] output) throws CommunicationStackException {
        int retries = 3;
        while (true) {
            try {
                return XStreamTools.deserialise(output);
            }
            catch (CommunicationStackException e) {
                if (retries <= 1) {
                    throw e;
                }
                String infoMessage = String.format("Deserialisation of response from '%s' failed, going to retry deserialisation!", remoteObjectIdentifier);
                this.logger.info(infoMessage);
                --retries;
                continue;
            }
            break;
        }
    }

    @Override
    protected void shutdownStackLayer() {
    }
}

