/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.serialisation;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.serialisation.AFConverter;
import de.aristaflow.adept2.base.communication.serialisation.JVM;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XStreamTools {
    protected static final Logger logger = LoggerTools.getLogger(XStreamTools.class);
    private static final XStream xStream = new XStream(new JVM().bestReflectionProvider());
    private static final String ENCODING = "UTF-8";

    static {
        xStream.registerConverter((Converter)new AFConverter(xStream.getMapper(), xStream.getReflectionProvider()));
    }

    public static <I> byte[] serialise(URI remoteObjectIdentifier, I input) throws CommunicationStackException {
        byte[] serialisedInput;
        logger.info(String.format("Going to serialise Message '%s' that should be send to '%s'", input, remoteObjectIdentifier));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)new OutputStreamWriter((OutputStream)baos, ENCODING), new char[0], "\n", new XmlFriendlyReplacer());
            xStream.marshal(input, (HierarchicalStreamWriter)writer);
            writer.flush();
            baos.flush();
            baos.close();
            serialisedInput = baos.toByteArray();
        }
        catch (RuntimeException e) {
            String errorMessage = String.format("Cannot serialise Message '%s' that should be send to '%s', because an error occurred during serialisation!", input, remoteObjectIdentifier);
            logger.log(Level.SEVERE, errorMessage, e);
            throw new CommunicationStackException(errorMessage, e);
        }
        catch (UnsupportedEncodingException e) {
            String errorMessage = String.format("Cannot serialise Message '%s' that should be send to '%s', because an encoding error occurred during serialisation!", input, remoteObjectIdentifier);
            logger.log(Level.SEVERE, errorMessage, e);
            throw new CommunicationStackException(errorMessage, e);
        }
        catch (IOException e) {
            String errorMessage = String.format("Cannot serialise Message '%s' that should be send to '%s', because an IO error occurred during serialisation!", input, remoteObjectIdentifier);
            logger.log(Level.SEVERE, errorMessage, e);
            throw new CommunicationStackException(errorMessage, e);
        }
        logger.info(String.format("Message '%s' that should be sent to '%s' was successfully serialised!", input, remoteObjectIdentifier));
        return serialisedInput;
    }

    public static <O> O deserialise(byte[] input) throws CommunicationStackException {
        Object result;
        logger.info("Started to deserialise input.");
        ByteArrayInputStream is = new ByteArrayInputStream(input);
        try {
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)is, ENCODING);
                result = xStream.fromXML((Reader)isr);
            }
            catch (UnsupportedEncodingException e) {
                String errorMessage = "Failed to deserialise input, an exception occurred!";
                logger.log(Level.SEVERE, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
            catch (RuntimeException e) {
                String errorMessage = "Failed to deserialise input, an exception occurred!";
                logger.log(Level.SEVERE, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                String errorMessage = "Failed to close input stream that delivered the message to serialise due to an exception!";
                logger.log(Level.SEVERE, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
        }
        logger.info("Deserialised input successfully!");
        return (O)result;
    }
}

