/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.tcp_ip;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.CommunicationStackTerminator;
import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCP_IP_Client
extends CommunicationStackTerminator<byte[], byte[]> {
    private long timeout;
    private static final int SHORT_TIMEOUT = 10000;
    protected ExecutorService executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("TCP_IP_Client-Pool"));

    public TCP_IP_Client(long timeout) {
        this.timeout = timeout;
    }

    @Override
    protected byte[] processInputAndReturn(URI remoteObjectIdentifier, byte[] input) throws CommunicationStackException {
        Socket clientSocket;
        byte[] output = null;
        long currentTimeout = this.timeout;
        String endpointHost = remoteObjectIdentifier.getHost();
        int endpointPort = remoteObjectIdentifier.getPort();
        if (endpointPort < 0) {
            String errorMessage = String.format("Error: RemoteObjectIdentifier '%s' does not specify the required target communication port! Going to cancel communication!", remoteObjectIdentifier);
            this.logger.severe(errorMessage);
            throw new CommunicationStackException(errorMessage);
        }
        try {
            clientSocket = this.openSocket(endpointHost, endpointPort);
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not open a socket for sending the request to '%s', an exception was raised!", remoteObjectIdentifier);
            this.logger.log(Level.INFO, errorMessage, e);
            throw new CommunicationStackException(errorMessage, e);
        }
        try {
            ResponseHandler responseHandler = new ResponseHandler(clientSocket);
            Future<byte[]> serverResponse = this.executorService.submit(responseHandler);
            try {
                OutputStream os = clientSocket.getOutputStream();
                os.write(input);
                os.flush();
                clientSocket.shutdownOutput();
            }
            catch (IOException e) {
                String errorMessage = String.format("Cannot send request to '%s', an IOException occurred!", remoteObjectIdentifier);
                this.logger.log(Level.WARNING, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
            try {
                boolean valid = false;
                do {
                    try {
                        output = serverResponse.get(currentTimeout, TimeUnit.MILLISECONDS);
                        valid = true;
                    }
                    catch (InterruptedException ie) {
                        String errorMessage = String.format("Getting interrupted while waiting for response from '%s', reducing timeout to 10 seconds and continuing waiting.", remoteObjectIdentifier);
                        this.logger.log(Level.INFO, errorMessage, ie);
                        currentTimeout = 10000L;
                    }
                } while (!valid);
            }
            catch (ExecutionException e) {
                String errorMessage = String.format("Cannot get the response from '%s', an Exception occurred:\n%s", remoteObjectIdentifier, e.getMessage());
                this.logger.log(Level.WARNING, errorMessage, e.getCause());
                throw new CommunicationStackException(errorMessage, e.getCause());
            }
            catch (TimeoutException e) {
                serverResponse.cancel(true);
                String errorMessage = String.format("Cannot get the response from '%s', the timeout of '%s' [ms] elapsed!", remoteObjectIdentifier, this.timeout);
                this.logger.log(Level.WARNING, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (currentTimeout == 10000L) {
                    Thread.currentThread().interrupt();
                }
                if (!clientSocket.isClosed()) {
                    clientSocket.close();
                }
                this.logger.info(String.format("Socket to '%s' is closed, now.", remoteObjectIdentifier));
            }
            catch (IOException e) {
                String errorMessage = String.format("Could not close socket '%s' to '%s'!", clientSocket, remoteObjectIdentifier);
                this.logger.log(Level.INFO, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
            throw throwable;
        }
        try {
            if (currentTimeout == 10000L) {
                Thread.currentThread().interrupt();
            }
            if (!clientSocket.isClosed()) {
                clientSocket.close();
            }
            this.logger.info(String.format("Socket to '%s' is closed, now.", remoteObjectIdentifier));
        }
        catch (IOException e) {
            String errorMessage = String.format("Could not close socket '%s' to '%s'!", clientSocket, remoteObjectIdentifier);
            this.logger.log(Level.INFO, errorMessage, e);
            throw new CommunicationStackException(errorMessage, e);
        }
        return output;
    }

    protected Socket openSocket(String endpointHost, int endpointPort) throws Exception {
        Exception error;
        this.logger.info("Trying to open a socket to " + endpointHost + ":" + endpointPort + "!");
        boolean retry = false;
        int retries = 2;
        Socket socket = null;
        do {
            error = null;
            if (retry) {
                try {
                    retry = false;
                    --retries;
                    Thread.sleep(15000L);
                    this.logger.info("Retry to connect socket to " + endpointHost + ":" + endpointPort);
                }
                catch (InterruptedException ie) {
                    error = ie;
                    this.logger.log(Level.WARNING, "Thread.sleep failed before retrying to connect socket to " + endpointHost + ":" + endpointPort + "!", ie);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                socket = new Socket(endpointHost, endpointPort);
            }
            catch (ConnectException e) {
                error = e;
                this.logger.log(Level.INFO, "Couldn't connect socket to " + endpointHost + ":" + endpointPort + ": The connection " + "was refused: ", e);
                retry = true;
            }
            catch (UnknownHostException e) {
                error = e;
                this.logger.log(Level.INFO, "Couldn't connect socket to " + endpointHost + ":" + endpointPort + ": Host unknown!", e);
            }
            catch (IOException e) {
                error = e;
                this.logger.log(Level.INFO, "Couldn't connect socket to " + endpointHost + ":" + endpointPort + ": ", e);
            }
        } while (retry && retries > 0);
        if (error != null) {
            this.logger.log(Level.INFO, "Failed to establish a socket connection to " + endpointHost + ":" + endpointPort + ": ", error);
            throw error;
        }
        if (socket == null) {
            String errorMessage = String.format("Failed to establish a socket connection to '%s:%s'!", endpointHost, endpointPort);
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ServiceConnectionException(errorMessage);
        }
        this.logger.info("Established a socket connection to " + endpointHost + ":" + endpointPort);
        return socket;
    }

    @Override
    public void shutdownStackLayer() {
        this.executorService.shutdown();
    }

    private static class ResponseHandler
    implements Callable<byte[]> {
        protected final Logger logger = LoggerTools.getLogger(this);
        private final Socket clientSocket;
        private static final int OK_HEADER = 0;
        private static final int ERROR_HEADER = 1;

        public ResponseHandler(Socket clientSocket) {
            this.clientSocket = clientSocket;
        }

        @Override
        public byte[] call() throws Exception {
            byte[] output;
            InputStream is;
            try {
                is = this.clientSocket.getInputStream();
            }
            catch (IOException e1) {
                String errorMessage = String.format("Cannot open the input stream assigned to socket '%s' in order to receive the server request, an IOException was thrown!", this.clientSocket);
                this.logger.log(Level.WARNING, errorMessage, e1);
                throw e1;
            }
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                int headerByte = bis.read();
                switch (headerByte) {
                    case 0: {
                        output = this.readResponse(bis);
                        break;
                    }
                    case 1: {
                        CommunicationStackException error = this.readException(bis);
                        String errorMessage = String.format("Server '%s' reported an exception:\n%s", this.clientSocket, error.getMessage());
                        this.logger.log(Level.WARNING, errorMessage, error);
                        throw new CommunicationStackException(errorMessage, error);
                    }
                    default: {
                        String errorMessage = String.format("Unknown header byte '%s' received from socket '%s'!", headerByte, this.clientSocket);
                        this.logger.log(Level.SEVERE, errorMessage);
                        throw new CommunicationStackException(errorMessage);
                    }
                }
            }
            catch (IOException e) {
                String errorMessage = String.format("Cannot read response from socket '%s', an IOException was thrown!", this.clientSocket);
                this.logger.log(Level.WARNING, errorMessage, e);
                throw e;
            }
            catch (ClassNotFoundException e) {
                String errorMessage = String.format("Cannot receive exception from socket '%s', a ClassNotFoundException was thrown!", this.clientSocket);
                this.logger.log(Level.SEVERE, errorMessage);
                throw e;
            }
            catch (CommunicationStackException e) {
                throw e;
            }
            return output;
        }

        private CommunicationStackException readException(BufferedInputStream bis) throws IOException, ClassNotFoundException {
            ObjectInputStream ois = new ObjectInputStream(bis);
            CommunicationStackException exception = (CommunicationStackException)ois.readObject();
            return exception;
        }

        private byte[] readResponse(BufferedInputStream bis) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bis.available());
            int contentByte = bis.read();
            while (contentByte != -1) {
                baos.write(contentByte);
                contentByte = bis.read();
            }
            return baos.toByteArray();
        }
    }
}

