/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.tcp_ip;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCP_IP_Request_Handler
implements Runnable {
    private static final int OK_HEADER = 0;
    private static final int ERROR_HEADER = 1;
    private final Socket socket;
    protected final Logger logger = LoggerTools.getLogger(this);
    private final CountDownLatch latch;
    private final CommunicationStack<byte[], byte[]> communicationStack;

    public TCP_IP_Request_Handler(Socket socket, CountDownLatch latch, CommunicationStack<byte[], byte[]> communicationStack) {
        this.socket = socket;
        this.latch = latch;
        this.communicationStack = communicationStack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName("TCP_IP_Request_Handler_Thread " + this.socket);
        try {
            try {
                String infoMessage = String.format("Connected to '%s:%s', trying to handle request...", this.socket.getInetAddress(), this.socket.getPort());
                this.logger.info(infoMessage);
                byte[] request = this.readRequest();
                this.latch.countDown();
                byte[] response = this.communicationStack.process(null, request);
                this.sendResponse(response);
                infoMessage = String.format("Request from '%s:%s' handled successfully, going to close connection.", this.socket.getInetAddress(), this.socket.getPort());
                this.logger.info(infoMessage);
            }
            catch (CommunicationStackException e) {
                String errorMessage = String.format("Failed to handle request initiated by '%s:%s', a CommunicationStackException was raised.", this.socket.getInetAddress(), this.socket.getPort());
                this.logger.log(Level.INFO, errorMessage, e);
                try {
                    this.sendException(e);
                }
                catch (IOException iOException) {
                    errorMessage = String.format("Cannot send occurred exception to '%s:%s', due to an IOException.", this.socket.getInetAddress(), this.socket.getPort());
                    this.logger.log(Level.SEVERE, errorMessage, e);
                }
                if (this.socket.isClosed()) return;
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    String errorMessage2 = String.format("Closing socket to '%s:%s' failed, an IOException was thrown. ", this.socket.getInetAddress(), this.socket.getPort());
                    this.logger.log(Level.SEVERE, errorMessage2, e2);
                    return;
                }
                String infoMessage = String.format("Connection to '%s:%s' closed.", this.socket.getInetAddress(), this.socket.getPort());
                this.logger.info(infoMessage);
                return;
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to handle request initiated by '%s:%s', an Exception occurred.", this.socket.getInetAddress(), this.socket.getPort());
                this.logger.log(Level.SEVERE, errorMessage, e);
                if (this.socket.isClosed()) return;
                try {
                    this.socket.close();
                }
                catch (IOException e3) {
                    String errorMessage3 = String.format("Closing socket to '%s:%s' failed, an IOException was thrown. ", this.socket.getInetAddress(), this.socket.getPort());
                    this.logger.log(Level.SEVERE, errorMessage3, e3);
                    return;
                }
                String infoMessage = String.format("Connection to '%s:%s' closed.", this.socket.getInetAddress(), this.socket.getPort());
                this.logger.info(infoMessage);
                return;
            }
        }
        finally {
            if (this.socket.isClosed()) return;
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            String errorMessage = String.format("Closing socket to '%s:%s' failed, an IOException was thrown. ", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.log(Level.SEVERE, errorMessage, e);
            return;
        }
        String infoMessage = String.format("Connection to '%s:%s' closed.", this.socket.getInetAddress(), this.socket.getPort());
        this.logger.info(infoMessage);
        return;
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private byte[] readRequest() throws Exception {
        try {
            String infoMessage = String.format("Trying to receive request from '%s:%s'...", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.info(infoMessage);
            InputStream is = this.socket.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int temp = bis.read();
            while (temp != -1) {
                baos.write(temp);
                temp = bis.read();
            }
            byte[] request = baos.toByteArray();
            infoMessage = String.format("Received request from '%s:%s'.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.info(infoMessage);
            return request;
        }
        catch (IOException e) {
            String errorMessage = String.format("Cannot receive the request from '%s:%s', an Exception was raised.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.log(Level.SEVERE, errorMessage, e);
            throw e;
        }
    }

    private void sendResponse(byte[] response) throws IOException {
        if (response == null) {
            String errorMessage = String.format("Cannot send the reply to '%s:%s', reply is set to null, but must not be set to null.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            String infoMessage = String.format("Trying to send reply to '%s:%s'...", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.info(infoMessage);
            OutputStream os = this.socket.getOutputStream();
            os.write(0);
            os.write(response);
            os.flush();
            this.socket.shutdownOutput();
            infoMessage = String.format("Sent reply to '%s:%s' successfully.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.info(infoMessage);
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to send reply to '%s:%s', an IOException was raised.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.log(Level.SEVERE, errorMessage, e);
            throw e;
        }
    }

    private void sendException(CommunicationStackException exception) throws IOException {
        try {
            String infoMessage = String.format("Trying to send exception to '%s:%s'...", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.fine(infoMessage);
            OutputStream os = this.socket.getOutputStream();
            os.write(1);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(exception);
            oos.flush();
            this.socket.shutdownOutput();
            infoMessage = String.format("Sent exception to '%s:%s' successfully.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.info(infoMessage);
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to send reply to '%s:%s', an IOException was raised.", this.socket.getInetAddress(), this.socket.getPort());
            this.logger.log(Level.WARNING, errorMessage, e);
            throw e;
        }
    }
}

