/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.tcp_ip;

import de.aristaflow.adept2.base.communication.ADEPT2CommunicationStackFactory;
import de.aristaflow.adept2.base.communication.tcp_ip.TCP_IP_Request_Handler;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCP_IP_Server
extends AbstractSubService
implements Runnable {
    protected String name;
    protected ServerSocket serverSocket = null;
    private boolean shutdown = false;
    private Thread skeletonThread = null;
    private final long timeout;
    protected InetAddress serverHostIP;
    protected int port;
    private final ADEPT2CommunicationStackFactory<byte[], byte[], ?, ?> communicationStackFactory;

    public TCP_IP_Server(AbstractADEPT2Service service, InetAddress serverHostIP, int port, long timeout, ADEPT2CommunicationStackFactory<byte[], byte[], ?, ?> communicationStackFactory) {
        super(service);
        this.timeout = timeout;
        this.communicationStackFactory = communicationStackFactory;
        this.serverHostIP = serverHostIP;
        this.port = port;
        this.name = "TCP_IP_Server";
    }

    protected void openSocket(InetAddress serverHostIP, int port) throws ConfigurationException {
        try {
            this.serverSocket = new ServerSocket(port, 0, serverHostIP);
        }
        catch (IOException e) {
            throw new ConfigurationException("The server socket (skeleton) could not be started, because port '" + port + "' is already in use. (" + e.toString() + ") " + "Change the port in the configuration" + " (ADEPT2.properties) and try again!", e);
        }
        this.port = this.serverSocket.getLocalPort();
        this.logger.info(String.valueOf(this.name) + " initialised (Hostname: " + serverHostIP.getHostName() + ", IP: " + serverHostIP.getHostAddress() + ", Port: " + this.port + ")");
        this.logger.info("Server socket opened successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        pool = Executors.newCachedThreadPool(new Adept2ThreadFactory(String.valueOf(this.name) + "-Pool"));
        var3_2 = this;
        synchronized (var3_2) {
            isShutdownRequested = this.shutdown;
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl38
        }
        do {
            try {
                socket = this.serverSocket.accept();
                signal = new CountDownLatch(1);
                communicationStack = this.communicationStackFactory.getSkeletonCommunicationStack();
                connectionHandler = new TCP_IP_Request_Handler(socket, signal, communicationStack);
                watchdog = new WatchDog(socket, signal, this.timeout);
                pool.execute(watchdog);
                pool.execute(connectionHandler);
                var8_9 = this;
                synchronized (var8_9) {
                    isShutdownRequested = this.shutdown;
                }
            }
            catch (IOException e) {
                var4_5 = this;
                synchronized (var4_5) {
                    isShutdownRequested = this.shutdown;
                }
                if (isShutdownRequested && e instanceof SocketException) {
                    this.logger.info("Shutdown requested!");
                    continue;
                }
                this.logger.log(Level.WARNING, "Connecting failed. ", e);
            }
lbl38:
            // 4 sources

        } while (!isShutdownRequested);
        this.logger.info("Shutting down.");
        pool.shutdown();
        var3_2 = this;
        synchronized (var3_2) {
            this.skeletonThread = null;
        }
    }

    @Override
    public void init() throws ConfigurationException {
        this.openSocket(this.serverHostIP, this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        TCP_IP_Server tCP_IP_Server = this;
        synchronized (tCP_IP_Server) {
            if (this.skeletonThread == null) {
                this.skeletonThread = new Thread((Runnable)this, String.valueOf(this.name) + "_" + this.serverSocket + "-Thread");
                this.skeletonThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        TCP_IP_Server tCP_IP_Server = this;
        synchronized (tCP_IP_Server) {
            this.shutdown = true;
            if (this.skeletonThread != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "Shutdown failed. An IOException was thrown: ", e);
                }
            }
        }
        this.logger.info("Shutdown succeeded!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emergencyShutdown() {
        TCP_IP_Server tCP_IP_Server = this;
        synchronized (tCP_IP_Server) {
            this.shutdown = true;
            if (this.skeletonThread != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "Shutdown failed. An IOException was thrown: ", e);
                }
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public static class WatchDog
    implements Runnable {
        private final Socket socketToMonitor;
        private final CountDownLatch signal;
        private final long timeout;
        protected final Logger logger = LoggerTools.getLogger(this);

        public WatchDog(Socket socketToMonitor, CountDownLatch signal, long timeout) {
            this.socketToMonitor = socketToMonitor;
            this.signal = signal;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            block9: {
                String oldThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName("WatchdogThread " + this.socketToMonitor);
                try {
                    try {
                        boolean isDeadlineExceeded;
                        String infoMessage = String.format("Started monitoring of connection to '%s:%s', set timeout to %s ms.", this.socketToMonitor.getInetAddress(), this.socketToMonitor.getPort(), this.timeout);
                        this.logger.info(infoMessage);
                        boolean bl = isDeadlineExceeded = !this.signal.await(this.timeout, TimeUnit.MILLISECONDS);
                        if (isDeadlineExceeded) {
                            String errorMessage = String.format("Timeout of %s ms elapsed for connection to '%s:%s'. Going to kill socket.", this.timeout, this.socketToMonitor.getInetAddress(), this.socketToMonitor.getPort());
                            this.logger.severe(errorMessage);
                            if (!this.socketToMonitor.isClosed()) {
                                this.socketToMonitor.close();
                                infoMessage = String.format("Killed socket to '%s:%s', because timeout for communication has elapsed.", this.socketToMonitor.getInetAddress(), this.socketToMonitor.getPort());
                                this.logger.info(infoMessage);
                            } else {
                                infoMessage = String.format("Didn't have to kill socket to '%s:%s', it was already closed.", this.socketToMonitor.getInetAddress(), this.socketToMonitor.getPort());
                                this.logger.info(infoMessage);
                            }
                            break block9;
                        }
                        infoMessage = String.format("Finished monitoring of connection to '%s:%s', because work is done.", this.socketToMonitor.getInetAddress(), this.socketToMonitor.getPort());
                        this.logger.info(infoMessage);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IOException e) {
                        String errorMessage = String.format("Could not close socket to '%s:%s' after exceeding communication deadline, an IOException was thrown.", this.socketToMonitor.getInetAddress(), this.socketToMonitor.getPort());
                        this.logger.log(Level.SEVERE, errorMessage, e);
                    }
                }
                finally {
                    Thread.currentThread().setName(oldThreadName);
                }
            }
        }
    }
}

