/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

public final class ConfigurationConstants {
    public static final String MULTI_VALUE_SEPARATOR = ",";
    public static final String CLASS_PATH_SEPARATOR = ";";
    public static final String CONFIG_FILE_EXTENSION = ".properties";
    public static final String CONFIG_FILE_BOOT = "ADEPT2.properties";
    public static final String CONFIG_PREFIX_RESOLVED_VARIABLES = "arflow";
    public static final String PROPERTY_INSTANCE_NAME = "This.InstanceName";
    public static final String PROPERTY_URI = "This.URI";
    public static final String PROPERTY_CONFIGURATION_FILE = "ConfigFile";
    public static final String PROPERTY_REGISTRY_IMPLEMENTATION = "Implementation";
    public static final String PROPERTY_REGISTRY_INSTANTIATION_MODE = "InstantiationMode";
    public static final String PROPERTY_REGISTRY_PLUGIN_TYPES = "PluginTypes";
    public static final String PROPERTY_REGISTRY_SERVICE_URI = "ServiceURI";
    public static final String COMPONENT_TYPE_CONSOLE_LOGGER = "ConsoleLogger";
    public static final String COMPONENT_TYPE_FILE_LOGGER = "FileLogger";
    public static final String PREFIX_PROPERTY_REGISTRY_TYPES = "Components";
    public static final String PREFIX_PROPERTY_REGISTRY_INSTANCES = "Instances";
    public static final String PREFIX_PROPERTY_LOGGING = "Logging";
    public static final String SERVICE_EXPORT_VIA = "ExportVia";
    public static final String SERVICE_PUBLISH_SERVICE = "PublishService";
    public static final String SERVICE_CALLBACK_COMMUNICATION_SERVICE = "CallbackCommunicationService";
    public static final String SERVICE_AUTOSTART_SERVICES = "AutoStartServices";
    public static final String SERVICE_MULTI_THREAD_SERVICE_START = "MultiThreadedServiceStart";

    private ConfigurationConstants() {
    }

    public static enum CommunicationProtocol {
        COMM_LOCAL("local"),
        COMM_MINA_SSL("minas"),
        COMM_MINA_SSL_XSTREAM("minas-xs"),
        COMM_MINA_CLIENT_ONLY_SSL("minacs"),
        COMM_MINA_CLIENT_ONLY_SSL_XSTREAM("minacs-xs"),
        COMM_MINA("mina"),
        COMM_MINA_XSTREAM("mina-xs"),
        COMM_MINA_CLIENT_ONLY("minac"),
        COMM_MINA_CLIENT_ONLY_XSTREAM("minac-xs"),
        COMM_PLAIN_SOCKETS("tcpip+rmi");

        private final String scheme;

        private CommunicationProtocol(String scheme) {
            this.scheme = scheme;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public static CommunicationProtocol fromString(String scheme) {
            CommunicationProtocol[] communicationProtocolArray = CommunicationProtocol.values();
            int n = communicationProtocolArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommunicationProtocol protocol = communicationProtocolArray[n2];
                if (protocol.getScheme().equalsIgnoreCase(scheme)) {
                    return protocol;
                }
                ++n2;
            }
            String msg = String.format("Scheme '%s' does not specifiy a supported protocol.", scheme);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final class SystemPropertyNames {
        public static final String LIB_DIR = "${arflow:arflow.libdir}";
        public static final String EXTENSIONS_DIR = "extensions";
    }
}

