/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationValidator;
import de.aristaflow.adept2.base.configuration.IllegalConfigurationDescriptionException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.configuration.PropertyNotSetException;
import de.aristaflow.adept2.model.common.RestrictionType;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;

public final class ConfigurationDescriptionTools {
    private static final Logger logger = LoggerTools.getLogger(ConfigurationDescriptionTools.class);
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(\\(|\\[)?\\s*(.+?)\\s*to\\s*(.+?)\\s*(\\)|\\])?\\s*$", 2);
    private static final Pattern LENGTH_PATTERN = Pattern.compile("^(\\d+|x)\\s*(?:to\\s*(\\d+|x))?$", 2);

    public static void validateConfigurationDescription(Class<?> implementingClass) throws IllegalConfigurationDescriptionException {
        if (implementingClass == null) {
            throw new NullArgumentException("The parameter 'implementingClass' must not be null!");
        }
        Stack describedClasses = new Stack();
        Class<?> cls = implementingClass;
        do {
            ConfigurationDescription desc;
            if ((desc = cls.getAnnotation(ConfigurationDescription.class)) == null) continue;
            describedClasses.push(cls);
        } while ((cls = cls.getSuperclass()) != null);
        if (describedClasses.isEmpty()) {
            String msg = "The component implementation '%s' and its ancestor classes don't have any ConfigurationDescriptions. Skipping configuration validation.";
            msg = String.format(msg, implementingClass.getName());
            logger.log(Level.INFO, msg);
            return;
        }
        HashMap<String, Class> propertyNames = new HashMap<String, Class>();
        while (!describedClasses.isEmpty()) {
            Class describedClass = (Class)describedClasses.pop();
            ConfigurationDescription desc = describedClass.getAnnotation(ConfigurationDescription.class);
            Property[] propertyArray = desc.properties();
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                String msg;
                Property property = propertyArray[n2];
                if (property.name().length() <= 0) {
                    msg = "The configuration description of '%s' contains a property with an empty string as name!";
                    msg = String.format(msg, describedClass.getName());
                    throw new IllegalConfigurationDescriptionException(msg);
                }
                if (propertyNames.containsKey(property.name())) {
                    if (propertyNames.get(property.name()) == describedClass) {
                        msg = "The configuration description of '%s' contains at least two properties with the same name: '%s'!";
                        msg = String.format(msg, describedClass.getName(), property.name());
                        throw new IllegalConfigurationDescriptionException(msg);
                    }
                    msg = "The configuration description of '%s' contains a property name that was already defined in its ancestor class '%s'! Properties cannot be redefined!";
                    msg = String.format(msg, describedClass.getName(), ((Class)propertyNames.get(property.name())).getName());
                    throw new IllegalConfigurationDescriptionException(msg);
                }
                propertyNames.put(property.name(), describedClass);
                ConfigurationDescriptionTools.validateRestrictions(property, describedClass);
                if (!property.isRequired()) {
                    String defaultValue = property.defaultValue();
                    int result = ConfigurationDescriptionTools.validatePropertyValue(property, defaultValue);
                    if (result == -1) {
                        String msg2 = "The configuration description of '%s' has an illegal default value for its property '%s': '%s' (value of type %s expected)!";
                        msg2 = String.format(msg2, new Object[]{describedClass.getName(), property.name(), defaultValue, property.type()});
                        throw new IllegalConfigurationDescriptionException(msg2);
                    }
                    if (result >= 0) {
                        String msg3 = "The configuration description of '%s' has an illegal default value for its property '%s': '%s' (didn't match the restriction '%s')!";
                        msg3 = String.format(msg3, describedClass.getName(), property.name(), defaultValue, property.restrictions()[result]);
                        throw new IllegalConfigurationDescriptionException(msg3);
                    }
                }
                ++n2;
            }
            ConfigurationDescriptionTools.getValidatorInstance(describedClass, null);
        }
    }

    private static void validateRestrictions(Property property, Class<?> describedClass) {
        String[] stringArray = property.restrictions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String msg;
            RestrictionType resType;
            String restriction = stringArray[n2];
            int index = restriction.indexOf(58);
            if (index == -1) {
                String msg2 = "The restriction '%s' of the property '%s' in the configuration description of '%s' must be of the form: '<restrictionType>: <restrictionData>' or '<restrictionType>/<restrictionOptions>: <restrictionData>'!";
                msg2 = String.format(msg2, restriction, property.name(), describedClass.getName());
                throw new IllegalConfigurationDescriptionException(msg2);
            }
            String resTypeToken = restriction.substring(0, index).trim();
            String resOptions = null;
            String resData = restriction.substring(index + 1).trim();
            index = resTypeToken.indexOf(47);
            if (index > -1) {
                resOptions = resTypeToken.substring(index + 1).trim();
                resTypeToken = resTypeToken.substring(0, index).trim();
                if (resOptions.length() <= 0) {
                    resOptions = null;
                }
            }
            if ((resType = RestrictionType.getTypeFor(resTypeToken)) == null) {
                msg = "The restriction type '%s' in the restriction '%s' of the property '%s' in the configuration description of '%s' is not supported!";
                msg = String.format(msg, resTypeToken, restriction, property.name(), describedClass.getName());
                throw new IllegalConfigurationDescriptionException(msg);
            }
            switch (resType) {
                case ONEOF: {
                    if (resOptions == null || resOptions.equalsIgnoreCase("i")) break;
                    msg = "The options of the restriction '%s' of the property '%s' in the configuration description of '%s' must either be 'i' or empty / omitted!";
                    msg = String.format(msg, restriction, property.name(), describedClass.getName());
                    throw new IllegalConfigurationDescriptionException(msg);
                }
                case LENGTH: {
                    int maxLength;
                    int minLength;
                    String msg3;
                    if (resOptions != null) {
                        msg = "The restriction '%s' of the property '%s' in the configuration description of '%s' does not support any options!";
                        msg = String.format(msg, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg);
                    }
                    Matcher matcher = LENGTH_PATTERN.matcher(resData);
                    if (!matcher.matches()) {
                        msg3 = "The length restriction '%s' of the property '%s' in the configuration description of '%s' must be of the form: 'length: <fixedLength>' or 'length: <minLength or x> to <maxLength or x>'!";
                        msg3 = String.format(msg3, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg3);
                    }
                    String minLengthToken = matcher.group(1);
                    String maxLengthToken = matcher.group(2) != null ? matcher.group(2) : minLengthToken;
                    try {
                        minLength = minLengthToken.equalsIgnoreCase("x") ? 0 : Integer.parseInt(minLengthToken);
                        maxLength = maxLengthToken.equalsIgnoreCase("x") ? Integer.MAX_VALUE : Integer.parseInt(maxLengthToken);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String msg4 = "The limits in the length restriction '%s' of the property '%s' in the configuration description of '%s' must either be x or a whole number between %s and %s!";
                        msg4 = String.format(msg4, restriction, property.name(), describedClass.getName(), Integer.MIN_VALUE, Integer.MAX_VALUE);
                        throw new IllegalConfigurationDescriptionException(msg4);
                    }
                    if (maxLength >= minLength) break;
                    String msg5 = "The maximum length %d in the length restriction '%s' of the property '%s' in the configuration description of '%s' must be greater than or equal to the minimum length %d!";
                    msg5 = String.format(msg5, maxLength, restriction, property.name(), describedClass.getName(), minLength);
                    throw new IllegalConfigurationDescriptionException(msg5);
                }
                case PATTERN: {
                    if (resOptions != null && !resOptions.equalsIgnoreCase("i")) {
                        msg = "The options of the restriction '%s' of the property '%s' in the configuration description of '%s' must either be 'i' or empty / omitted!";
                        msg = String.format(msg, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg);
                    }
                    try {
                        Pattern.compile(resData);
                        break;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        msg = "'%s' in the restriction '%s' of the property '%s' in the configuration description of '%s' is no valid pattern!";
                        msg = String.format(msg, resData, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg);
                    }
                }
                case RANGE: {
                    String msg3;
                    if (resOptions != null) {
                        msg = "The restriction '%s' of the property '%s' in the configuration description of '%s' does not support any options!";
                        msg = String.format(msg, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg);
                    }
                    if (!property.type().isNumberType()) {
                        msg = "The range restriction '%s' of the property '%s' in the configuration description of '%s' can only be used on number types!";
                        msg = String.format(msg, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg);
                    }
                    Matcher matcher = RANGE_PATTERN.matcher(resData);
                    if (!matcher.matches()) {
                        msg3 = "The range restriction '%s' of the property '%s' in the configuration description of '%s' must be of the form: 'range: <( or [><number or x>, <number or x><) or ]>'!";
                        msg3 = String.format(msg3, restriction, property.name(), describedClass.getName());
                        throw new IllegalConfigurationDescriptionException(msg3);
                    }
                    String minValueToken = matcher.group(2);
                    String maxValueToken = matcher.group(3);
                    if (property.type() == Property.Type.INT || property.type() == Property.Type.LONG) {
                        try {
                            long minValue = minValueToken.equalsIgnoreCase("x") ? Long.MIN_VALUE : Long.parseLong(minValueToken);
                            long maxValue = maxValueToken.equalsIgnoreCase("x") ? Long.MAX_VALUE : Long.parseLong(maxValueToken);
                            if (maxValue >= minValue) break;
                            String msg6 = "The maximum value %d in the range restriction '%s' of the property '%s' in the configuration description of '%s' must be greater than or equal to the minimum value %d!";
                            msg6 = String.format(msg6, maxValue, restriction, property.name(), describedClass.getName(), minValue);
                            throw new IllegalConfigurationDescriptionException(msg6);
                        }
                        catch (NumberFormatException numberFormatException) {
                            String msg7 = "For the property type %s the boundaries in the range restriction '%s' of the property '%s' in the configuration description of '%s' must either be x or a whole number between %s and %s!";
                            msg7 = String.format(msg7, new Object[]{property.type(), restriction, property.name(), describedClass.getName(), Long.MIN_VALUE, Long.MAX_VALUE});
                            throw new IllegalConfigurationDescriptionException(msg7);
                        }
                    }
                    try {
                        double minValue = minValueToken.equalsIgnoreCase("x") ? Double.MIN_VALUE : Double.parseDouble(minValueToken);
                        double maxValue = maxValueToken.equalsIgnoreCase("x") ? Double.MAX_VALUE : Double.parseDouble(maxValueToken);
                        if (!(maxValue < minValue)) break;
                        String msg8 = "The maximum value %s in the range restriction '%s' of the property '%s' in the configuration description of '%s' must be greater than or equal to the minimum value %s!";
                        msg8 = String.format(msg8, maxValue, restriction, property.name(), describedClass.getName(), minValue);
                        throw new IllegalConfigurationDescriptionException(msg8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String msg9 = "For the property type %s the boundaries in the range restriction '%s' of the property '%s' in the configuration description of '%s' must either be x or a floating point number between %s and %s!";
                        msg9 = String.format(msg9, new Object[]{property.type(), restriction, property.name(), describedClass.getName(), Double.MIN_VALUE, Double.MAX_VALUE});
                        throw new IllegalConfigurationDescriptionException(msg9);
                    }
                }
                default: {
                    throw new IllegalStateException("Support for " + resTypeToken + " not yet implemented.");
                }
            }
            ++n2;
        }
    }

    private static int validatePropertyValue(Property property, String propertyValue) {
        Object parsedValue;
        switch (property.type()) {
            case BOOLEAN: {
                parsedValue = ConfigurationDescriptionTools.parseBooleanPropertyValue(propertyValue);
                break;
            }
            case INT: {
                parsedValue = ConfigurationDescriptionTools.parseIntPropertyValue(propertyValue);
                break;
            }
            case LONG: {
                parsedValue = ConfigurationDescriptionTools.parseLongPropertyValue(propertyValue);
                break;
            }
            case FLOAT: {
                parsedValue = ConfigurationDescriptionTools.parseFloatPropertyValue(propertyValue);
                break;
            }
            case DOUBLE: {
                parsedValue = ConfigurationDescriptionTools.parseDoublePropertyValue(propertyValue);
                break;
            }
            case STRING: {
                parsedValue = propertyValue;
                break;
            }
            case URI: {
                parsedValue = ConfigurationDescriptionTools.parseURIPropertyValue(propertyValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported property type encountered: " + (Object)((Object)property.type()));
            }
        }
        if (parsedValue == null) {
            return -1;
        }
        int i = 0;
        while (i < property.restrictions().length) {
            String restriction = property.restrictions()[i];
            int index = restriction.indexOf(58);
            String resTypeToken = restriction.substring(0, index).trim();
            String resOptions = null;
            String resData = restriction.substring(index + 1).trim();
            index = resTypeToken.indexOf(47);
            if (index > -1) {
                resOptions = resTypeToken.substring(index + 1).trim();
                resTypeToken = resTypeToken.substring(0, index).trim();
                if (resOptions.length() <= 0) {
                    resOptions = null;
                }
            }
            RestrictionType resType = RestrictionType.getTypeFor(resTypeToken);
            switch (resType) {
                case ONEOF: {
                    boolean ignoreCase = resOptions != null;
                    String[] items = resData.split("\\s*,\\s*");
                    boolean found = false;
                    String[] stringArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (ignoreCase) {
                            if (propertyValue.equalsIgnoreCase(item)) {
                                found = true;
                                break;
                            }
                        } else if (propertyValue.equals(item)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (found) break;
                    return i;
                }
                case LENGTH: {
                    Matcher matcher = LENGTH_PATTERN.matcher(resData);
                    matcher.find();
                    String minLengthToken = matcher.group(1);
                    String maxLengthToken = matcher.group(2) != null ? matcher.group(2) : minLengthToken;
                    int minLength = minLengthToken.equalsIgnoreCase("x") ? 0 : Integer.parseInt(minLengthToken);
                    int maxLength = maxLengthToken.equalsIgnoreCase("x") ? Integer.MAX_VALUE : Integer.parseInt(maxLengthToken);
                    if (propertyValue.length() >= minLength && propertyValue.length() <= maxLength) break;
                    return i;
                }
                case PATTERN: {
                    boolean ignoreCase = resOptions != null;
                    int patternFlags = ignoreCase ? 2 : 0;
                    Pattern pattern = Pattern.compile(resData, patternFlags);
                    if (pattern.matcher(propertyValue).matches()) break;
                    return i;
                }
                case RANGE: {
                    boolean maxInclusive;
                    Matcher matcher = RANGE_PATTERN.matcher(resData);
                    matcher.find();
                    String minValueToken = matcher.group(2);
                    String maxValueToken = matcher.group(3);
                    boolean minInclusive = matcher.group(1) == null || matcher.group(1).equals("[");
                    boolean bl = maxInclusive = matcher.group(4) == null || matcher.group(4).equals("]");
                    if (property.type() == Property.Type.INT || property.type() == Property.Type.LONG) {
                        long value = ((Number)parsedValue).longValue();
                        if (!minValueToken.equalsIgnoreCase("x")) {
                            long minValue = Long.parseLong(minValueToken);
                            if (minInclusive && value < minValue || !minInclusive && value <= minValue) {
                                return i;
                            }
                        }
                        if (maxValueToken.equalsIgnoreCase("x")) break;
                        long maxValue = Long.parseLong(maxValueToken);
                        if ((!maxInclusive || value <= maxValue) && (maxInclusive || value < maxValue)) break;
                        return i;
                    }
                    double value = ((Number)parsedValue).doubleValue();
                    if (!minValueToken.equalsIgnoreCase("x")) {
                        double minValue = Double.parseDouble(minValueToken);
                        if (minInclusive && value < minValue || !minInclusive && value <= minValue) {
                            return i;
                        }
                    }
                    if (maxValueToken.equalsIgnoreCase("x")) break;
                    double maxValue = Double.parseDouble(maxValueToken);
                    if (!(maxInclusive && value > maxValue) && (maxInclusive || !(value >= maxValue))) break;
                    return i;
                }
                default: {
                    throw new IllegalStateException("Support for " + resTypeToken + " not yet implemented.");
                }
            }
            ++i;
        }
        return -2;
    }

    public static Configuration validateConfiguration(Configuration instConf, Class<?> implementingClass, String instanceName) throws ConfigurationException {
        return ConfigurationDescriptionTools.validateConfiguration(instConf, implementingClass, false, instanceName);
    }

    /*
     * Unable to fully structure code
     */
    public static Configuration validateConfiguration(Configuration instConf, Class<?> implementingClass, boolean includeIfaces, String instanceName) throws ConfigurationException {
        if (instConf == null) {
            throw new NullArgumentException("The parameter 'instanceConfiguration' must not be null!");
        }
        if (implementingClass == null) {
            throw new NullArgumentException("The parameter 'implementingClass' must not be null!");
        }
        for (Class<?> cls : ConfigurationDescriptionTools.getParentClasses(implementingClass, includeIfaces)) {
            desc = cls.getAnnotation(ConfigurationDescription.class);
            if (desc == null) continue;
            var10_13 = desc.properties();
            var9_11 = var10_13.length;
            var8_8 = 0;
            while (var8_8 < var9_11) {
                property = var10_13[var8_8];
                propertyObject = instConf.getProperty(property.name());
                v0 = propertyValue = propertyObject == null ? null : propertyObject.toString();
                if (propertyValue == null) {
                    if (property.isRequired()) {
                        msg = "The configuration of the component instance '%s' (with the implementing class '%s') is missing a value for its property '%s'!";
                        msg = String.format(msg, new Object[]{instanceName, implementingClass.getName(), property.name()});
                        throw new PropertyNotSetException(msg);
                    }
                    defaultValue = property.defaultValue();
                    if (defaultValue.length() == 0 && property.defaultNull()) {
                        defaultValue = null;
                    }
                    if ((writtenConf = instConf) instanceof CompositeConfiguration) {
                        writtenConf = ((CompositeConfiguration)instConf).getConfiguration(0);
                    }
                    writtenConf.setProperty(property.name(), (Object)defaultValue);
                } else {
                    if (property.type() == Property.Type.STRING && property.isRequired() && propertyValue.length() <= 0) {
                        msg = "The configuration of the component instance '%s' (with the implementing class '%s') has an illegal value for its property '%s': '%s' (required property value of type %s must not be the empty string)!";
                        msg = String.format(msg, new Object[]{instanceName, implementingClass.getName(), property.name(), propertyValue, property.type()});
                        throw new ConfigurationException(msg);
                    }
                    currentConf = instConf;
                    block7: while (currentConf instanceof CompositeConfiguration || currentConf instanceof SubsetConfiguration) {
                        if (currentConf instanceof CompositeConfiguration) {
                            try {
                                currentConf = ((CompositeConfiguration)currentConf).getSource(property.name());
                                continue;
                            }
                            catch (IllegalArgumentException v1) {
                                comp = (CompositeConfiguration)currentConf;
                                i = 0;
                                ** while (i < comp.getNumberOfConfigurations())
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (comp.getConfiguration(i).containsKey(property.name())) {
                                    currentConf = comp.getConfiguration(i);
                                    continue block7;
                                }
                                ++i;
                                continue;
lbl46:
                                // 1 sources

                                continue block7;
                            }
                        }
                        currentConf = ((SubsetConfiguration)currentConf).getParent();
                    }
                    msg = new StringBuilder();
                    if (currentConf instanceof FileConfiguration) {
                        fileName = ((FileConfiguration)currentConf).getFileName();
                        msg.append(String.format("The configuration (configuration file: '%s') ", new Object[]{fileName}));
                    } else {
                        msg.append("The configuration ");
                    }
                    msg.append("of the component instance '%s' (with the implementing class '%s') has an illegal value for its property '%s': '%s' ");
                    result = ConfigurationDescriptionTools.validatePropertyValue(property, propertyValue);
                    if (result == -1) {
                        msg.append("(value of type %s expected)!");
                        m = String.format(msg.toString(), new Object[]{instanceName, implementingClass.getName(), property.name(), propertyValue, property.type()});
                        throw new ConfigurationException(m);
                    }
                    if (result >= 0) {
                        msg.append("(didn't match the restriction '%s')!");
                        m = String.format(msg.toString(), new Object[]{instanceName, implementingClass.getName(), property.name(), propertyValue, property.restrictions()[result]});
                        throw new ConfigurationException(m);
                    }
                }
                ++var8_8;
            }
            validator = ConfigurationDescriptionTools.getValidatorInstance(cls, instanceName);
            try {
                validator.validate(instConf);
            }
            catch (ConfigurationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                msg = "An exception occured while validating the configuration of the component instance '%s' (with the implementing class '%s'). This may indicate an error in the configuration.";
                msg = String.format(msg, new Object[]{instanceName, implementingClass.getName()});
                throw new ConfigurationException(msg, ex);
            }
        }
        return instConf;
    }

    private static ConfigurationValidator getValidatorInstance(Class<?> implementingClass, String instanceName) throws IllegalConfigurationDescriptionException {
        ConfigurationDescription desc = implementingClass.getAnnotation(ConfigurationDescription.class);
        try {
            ConfigurationValidator validator = desc.validator().newInstance();
            validator.init(instanceName, implementingClass);
            return validator;
        }
        catch (Exception ex) {
            String msg = "The validator defined in the configuration description of '%s' is not instantiatable!";
            msg = String.format(msg, implementingClass.getName());
            throw new IllegalConfigurationDescriptionException(msg, ex);
        }
    }

    static Boolean parseBooleanPropertyValue(String propertyValue) {
        return ConfigurationTools.parseBoolean(propertyValue);
    }

    static Integer parseIntPropertyValue(String propertyValue) {
        Long retL = ConfigurationTools.parseInteger(propertyValue);
        Integer ret = null;
        if (retL != null && (ret = Integer.valueOf(retL.intValue())).longValue() != retL.longValue()) {
            ret = null;
        }
        return ret;
    }

    static Long parseLongPropertyValue(String propertyValue) {
        return ConfigurationTools.parseInteger(propertyValue);
    }

    static Float parseFloatPropertyValue(String propertyValue) {
        Double retD = ConfigurationTools.parseFloat(propertyValue);
        Float ret = null;
        if (retD != null && (ret = Float.valueOf(retD.floatValue())).doubleValue() != retD.doubleValue()) {
            ret = null;
        }
        return ret;
    }

    static Double parseDoublePropertyValue(String propertyValue) {
        return ConfigurationTools.parseFloat(propertyValue);
    }

    static URI parseURIPropertyValue(String propertyValue) {
        return ConfigurationTools.parseURI(propertyValue);
    }

    static List<Class<?>> getParentClasses(Class<?> cls, boolean includeIfaces) {
        ArrayList ret = new ArrayList();
        ret.add(cls);
        int index = 0;
        do {
            Class current;
            Class sup;
            if ((sup = (current = (Class)ret.get(index)).getSuperclass()) != null) {
                ret.add(sup);
            }
            if (!includeIfaces) continue;
            Class<?>[] classArray = current.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                ret.add(iface);
                ++n2;
            }
        } while (++index < ret.size());
        return ret;
    }

    private ConfigurationDescriptionTools() {
    }
}

