/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;

public abstract class ConfigurationManager<T> {
    private static ConfigurationManager<?> bootConfigurationManager;
    private static Map<String, String> substitutedVariables;
    private final Configuration configuration;
    protected final Map<String, Configuration> instanceConfigurations;
    protected final Logger logger = LoggerTools.getLogger(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationManager(T initialisationData) throws ConfigurationException {
        this.instanceConfigurations = new HashMap<String, Configuration>();
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (bootConfigurationManager == null) {
                SystemProperties.initialise(this.getSystemProperties());
                substitutedVariables = this.getSubstitutedVariables();
                ConfigurationInterpolator.registerGlobalLookup((String)"arflow", (StrLookup)StrLookup.mapLookup(substitutedVariables));
                bootConfigurationManager = this;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.configuration = this.initRootConfiguration(initialisationData);
            return;
        }
    }

    protected ConfigurationManager(Configuration rootConfiguration, Object overloadDummy) {
        this.instanceConfigurations = new HashMap<String, Configuration>();
        this.configuration = rootConfiguration;
    }

    protected abstract Configuration initRootConfiguration(T var1) throws ConfigurationException;

    protected abstract Map<String, String> getSystemProperties() throws ConfigurationException;

    protected abstract Map<String, String> getSubstitutedVariables() throws ConfigurationException;

    protected final ConfigurationManager<?> getBootConfigurationManager() {
        return bootConfigurationManager;
    }

    public final Configuration getRootConfiguration() {
        return this.configuration;
    }

    public abstract ConfigurationManager<?> createChild(Configuration var1) throws ConfigurationException;

    public static ConfigurationManager<?> create(Configuration configuration) throws ConfigurationException {
        return bootConfigurationManager.createChild(configuration);
    }

    public Configuration getConfiguration(String instanceName, String componentType) throws ConfigurationException {
        Configuration ret;
        if (this.instanceConfigurations.containsKey(instanceName)) {
            ret = this.instanceConfigurations.get(instanceName);
        } else {
            if (instanceName.equals(componentType)) {
                ret = this.getConfiguration(componentType);
            } else {
                CompositeConfiguration compRet;
                ret = this.getConfiguration(instanceName);
                if (ret instanceof CompositeConfiguration) {
                    compRet = (CompositeConfiguration)ret;
                } else {
                    compRet = new CompositeConfiguration();
                    compRet.addConfiguration(ret);
                }
                ret = this.getConfiguration(componentType, componentType);
                if (ret instanceof CompositeConfiguration) {
                    CompositeConfiguration compAC = (CompositeConfiguration)ret;
                    int i = 0;
                    while (i < compAC.getNumberOfConfigurations()) {
                        compRet.addConfiguration(compAC.getConfiguration(i));
                        ++i;
                    }
                } else {
                    compRet.addConfiguration(ret);
                }
                ret = compRet;
            }
            this.instanceConfigurations.put(instanceName, ret);
        }
        return ret;
    }

    protected abstract Configuration getConfiguration(String var1) throws ConfigurationException;

    public static void replaceVariables(List<String> classPath) {
        int i = 0;
        while (i < classPath.size()) {
            String entry = classPath.get(i);
            for (Map.Entry<String, String> substitution : substitutedVariables.entrySet()) {
                String variableName = Pattern.quote(String.format("${%s:%s}", "arflow", substitution.getKey()));
                entry = entry.replaceAll(variableName, substitution.getValue());
            }
            entry = entry.replaceAll("%ADEPT2_DATA_DIR%", SystemProperties.getDataDir());
            entry = entry.replaceAll("%ADEPT2_LIB_DIR%", SystemProperties.getLibDir());
            classPath.set(i, entry);
            ++i;
        }
    }
}

