/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.PropertyNotSetException;
import org.apache.commons.configuration.Configuration;

public abstract class ConfigurationValidator {
    private String instanceName;
    private Class<?> implementingClass;

    void init(String instanceName, Class<?> implementingClass) {
        this.instanceName = instanceName;
        this.implementingClass = implementingClass;
    }

    protected abstract void validate(Configuration var1) throws ConfigurationException;

    protected final void rebuke(String description) throws ConfigurationException {
        String msg = "The configuration of the component instance '%s' (with the implementing class '%s') contains an error: %s";
        msg = String.format(msg, this.instanceName, this.implementingClass.getName(), description);
        throw new ConfigurationException(msg);
    }

    protected final void rebukeIllegalValue(Configuration configuration, String propertyName, String shortDescription) throws ConfigurationException {
        String msg = "The configuration of the component instance '%s' (with the implementing class '%s') has an illegal value for its property '%s': '%s' (%s)!";
        msg = String.format(msg, this.instanceName, this.implementingClass.getName(), propertyName, configuration.getProperty(propertyName), shortDescription);
        throw new ConfigurationException(msg);
    }

    protected final void rebukeMissingValue(String propertyName) throws PropertyNotSetException {
        String msg = "The configuration of the component instance '%s' (with the implementing class '%s') is missing a value for its property '%s'!";
        msg = String.format(msg, this.instanceName, this.implementingClass.getName(), propertyName);
        throw new PropertyNotSetException(msg);
    }
}

