/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.NodeCombiner;

public abstract class FileBasedConfigurationManager<T>
extends ConfigurationManager<T> {
    protected List<File> configDirectories;

    protected FileBasedConfigurationManager(T initialisationData) throws ConfigurationException {
        super(initialisationData);
        DefaultExpressionEngine expressionEngine = new DefaultExpressionEngine();
        expressionEngine.setAttributeEnd(null);
        expressionEngine.setIndexStart("");
        expressionEngine.setIndexEnd("");
        HierarchicalConfiguration.setDefaultExpressionEngine((ExpressionEngine)expressionEngine);
    }

    protected FileBasedConfigurationManager(Configuration rootConfiguration, String[] configDirectories) throws ConfigurationException {
        super(rootConfiguration, null);
        this.setConfigurationDirectories(configDirectories);
    }

    @Override
    protected abstract Configuration initRootConfiguration(T var1) throws ConfigurationException;

    protected abstract boolean getLoadBundleConfig() throws ConfigurationException;

    protected abstract boolean getEagerConfigurationLoading() throws ConfigurationException;

    protected void setConfigurationDirectories(String[] confDirs) throws ConfigurationException {
        this.configDirectories = new ArrayList<File>(confDirs.length);
        this.logger.fine("Adding configuration directories.");
        int i = 0;
        while (i < confDirs.length) {
            String confDirString = confDirs[i];
            File confDir = FileBasedConfigurationManager.getDir(confDirString, true);
            this.logger.fine(String.format("Adding configuration directory '%1$s'.", confDir));
            this.configDirectories.add(confDir);
            ++i;
        }
        if (this.configDirectories.size() == 0) {
            this.logger.info("No configuration directory found! Using default configurations.");
        } else {
            String message = "Configurations will be loaded from following directories, in order (previous ones take precedence): " + this.configDirectories.toString();
            this.logger.fine(message);
        }
    }

    public static File getDir(String path, boolean hasToExist) throws ConfigurationException {
        File ret;
        block5: {
            if (!ConfigurationTools.stringValid(path)) {
                String msg = String.format("'%s' is not a valid directory.", path);
                throw new ConfigurationException(msg);
            }
            ret = new File(path);
            try {
                if (hasToExist && !ret.exists()) {
                    String msg = String.format("Directory '%s' does not exist.", path);
                    throw new ConfigurationException(msg);
                }
                if (ret.exists() && !ret.isDirectory()) {
                    String msg = String.format("File '%s' exists, but it is not a directory.", path);
                    throw new ConfigurationException(msg);
                }
            }
            catch (SecurityException securityException) {
                if (!hasToExist) break block5;
                String msg = String.format("Cannot access '%s'.", path);
                throw new ConfigurationException(msg);
            }
        }
        return ret;
    }

    @Override
    protected Configuration getConfiguration(String instanceName) throws ConfigurationException {
        CompositeConfiguration ret;
        String configurationFile = this.getRootConfiguration().getString(String.valueOf(instanceName) + "." + "ConfigFile");
        if (configurationFile != null) {
            ret = this.loadConfigurationFromFile(configurationFile);
            this.logger.finer(String.format("Loaded configuration for instance '%1$s'.", instanceName));
        } else {
            this.logger.info(String.format("No configuration found for instance '%1$s', using root configuration.", instanceName));
            ret = this.getRootConfiguration().subset(instanceName);
            this.logger.finer(String.format("Extracted properties from configuration, removed prefix '%1$s'.", instanceName));
        }
        return ret;
    }

    protected AbstractConfiguration loadReferencedConfigurations(AbstractConfiguration rootConfiguration) throws ConfigurationException {
        CombinedConfiguration ret = new CombinedConfiguration((NodeCombiner)new ConfigurationTools.InverseOverrideCombiner());
        ret.addConfiguration(rootConfiguration);
        HashSet<String> confFileKeys = new HashSet<String>();
        LinkedList<Object> toLoad = new LinkedList<Object>();
        toLoad.add(rootConfiguration);
        while (toLoad.size() > 0) {
            Configuration current = (Configuration)toLoad.remove(0);
            String suffix = String.format(".%s", "ConfigFile");
            Iterator keys = current.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.endsWith(suffix)) continue;
                String prefix = key.substring(0, key.length() - suffix.length());
                String configurationFile = current.getString(key);
                if (configurationFile == null) continue;
                CompositeConfiguration instConf = this.loadConfigurationFromFile(configurationFile);
                ret.addConfiguration((AbstractConfiguration)instConf, null, prefix);
                toLoad.add(instConf);
                confFileKeys.add(key);
                String msg = "Eagerly loaded configuration for '%s' from external file '%s'.";
                this.logger.finer(String.format(msg, prefix, configurationFile));
            }
            Iterator confFileKey = confFileKeys.iterator();
            while (confFileKey.hasNext()) {
                ret.clearProperty((String)confFileKey.next());
            }
        }
        return ret;
    }

    protected CompositeConfiguration loadConfigurationFromFile(String fileName) throws ConfigurationException {
        URL packageURL;
        PropertiesConfiguration configuration;
        CompositeConfiguration ret = new CompositeConfiguration();
        for (File configDirectory : this.configDirectories) {
            File path = new File(configDirectory, fileName);
            this.logger.info("Loading file '" + path + "'.");
            try {
                configuration = new PropertiesConfiguration();
                configuration.load(path);
                ret.addConfiguration((Configuration)configuration);
            }
            catch (org.apache.commons.configuration.ConfigurationException ce) {
                if (ce.getCause() instanceof FileNotFoundException) {
                    this.logger.info(String.format("File not found: '%1$s'. Searching other directories.", path));
                    continue;
                }
                this.logger.log(Level.WARNING, String.format("Problems loading configuration '%s'. Please check the path, the encoding and escape sequences.", path), ce);
            }
            catch (IllegalArgumentException iae) {
                this.logger.log(Level.WARNING, String.format("IllegalArgumentException while loading configuration '%1$s'. Please check the encoding and escape sequences.", path), iae);
            }
        }
        if (this.getLoadBundleConfig() && (packageURL = this.getClass().getResource("/conf/" + fileName)) != null) {
            this.logger.info("Loading (package) URL '" + packageURL + "'.");
            try {
                InputStream is = packageURL.openStream();
                try {
                    configuration = new PropertiesConfiguration();
                    configuration.load(is);
                    ret.addConfiguration((Configuration)configuration);
                }
                finally {
                    is.close();
                }
            }
            catch (org.apache.commons.configuration.ConfigurationException ce) {
                this.logger.log(Level.WARNING, String.format("Problems loading the configuration file '%1$s' from package / JAR.", fileName), ce);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, String.format("IOException while loading configuration file '%1$s' from package / JAR.", fileName), e);
            }
        }
        if (ret.getNumberOfConfigurations() <= 0) {
            String msg = "The specified configuration file '%s' could not be found at any of the searched locations!";
            msg = String.format(msg, fileName);
            this.logger.log(Level.SEVERE, msg);
            throw new ConfigurationException(msg);
        }
        return ret;
    }
}

