/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

import de.aristaflow.adept2.util.LoggerTools;
import java.util.Map;
import java.util.logging.Logger;

public final class SystemProperties {
    private static final Logger logger = LoggerTools.getLogger(SystemProperties.class);
    private static String osName;
    private static boolean debugConfig;
    private static String libDir;
    private static String dataDir;
    private static boolean useSignedObject;

    public static String getOsName() {
        return osName;
    }

    public static boolean getDebugConfig() {
        return debugConfig;
    }

    public static String getLibDir() {
        return libDir;
    }

    public static String getDataDir() {
        return dataDir;
    }

    public static boolean useSignedObject() {
        return useSignedObject;
    }

    static void initialise(Map<String, String> properties) {
        osName = properties.get("os.name");
        libDir = properties.get("arflow.libdir");
        dataDir = properties.get("arflow.datadir");
        String debugConfigProperty = properties.get("arflow.debug.configuration");
        debugConfig = debugConfigProperty == null || debugConfigProperty.equals("") ? false : Boolean.parseBoolean(debugConfigProperty);
        String signedObjectProperty = properties.get("arflow.useSignedObject");
        useSignedObject = signedObjectProperty == null || signedObjectProperty.equals("") ? false : Boolean.parseBoolean(signedObjectProperty);
        logger.info("System properties set:");
        logger.info(String.format("OS: '%s'", osName));
        logger.info(String.format("libDir: '%s'", libDir));
        logger.info(String.format("dataDir: '%s'", dataDir));
        logger.info(String.format("debugConfig: '%s'", debugConfig));
        logger.info(String.format("useSignedObject: '%s'", useSignedObject));
    }
}

