/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.configuration;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.FileBasedConfigurationManager;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public abstract class SystemPropertyConfigurationManager<T>
extends FileBasedConfigurationManager<T> {
    protected static Map<String, String> substitutedVariables = null;
    protected static Map<String, String> systemProperties = null;
    protected static boolean debugConfig;
    protected static File logDir;
    protected static File logDirDefault;
    protected static String[] confDirs;
    protected static File userDir;
    protected static boolean loadBundleConfig;
    protected static boolean loadConfigEagerly;

    protected static boolean getDebugConfig() {
        return debugConfig;
    }

    protected static File getLogDir() {
        return logDir;
    }

    protected static File getLogDirDefault() {
        return logDirDefault;
    }

    protected static String[] getConfDirs() {
        return confDirs;
    }

    protected static File getUserDir() {
        return userDir;
    }

    protected SystemPropertyConfigurationManager(T initialisationData) throws ConfigurationException {
        super(initialisationData);
    }

    protected SystemPropertyConfigurationManager(Configuration rootConfiguration, String[] configDirectories) throws ConfigurationException {
        super(rootConfiguration, configDirectories);
    }

    @Override
    protected final Configuration initRootConfiguration(T initialisationData) throws ConfigurationException {
        this.setConfigurationDirectories(ArrayTools.reverse(confDirs));
        return this.initFileBasedRootConfiguration(initialisationData);
    }

    protected abstract Configuration initFileBasedRootConfiguration(T var1) throws ConfigurationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> getSystemProperties() throws ConfigurationException {
        Class<SystemPropertyConfigurationManager> clazz = SystemPropertyConfigurationManager.class;
        synchronized (SystemPropertyConfigurationManager.class) {
            if (systemProperties == null) {
                this.initialiseProperties();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return systemProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Map<String, String> getSubstitutedVariables() throws ConfigurationException {
        Class<SystemPropertyConfigurationManager> clazz = SystemPropertyConfigurationManager.class;
        synchronized (SystemPropertyConfigurationManager.class) {
            if (substitutedVariables == null) {
                this.initialiseProperties();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return substitutedVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean getLoadBundleConfig() throws ConfigurationException {
        Class<SystemPropertyConfigurationManager> clazz = SystemPropertyConfigurationManager.class;
        synchronized (SystemPropertyConfigurationManager.class) {
            if (systemProperties == null) {
                this.initialiseProperties();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loadBundleConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean getEagerConfigurationLoading() throws ConfigurationException {
        Class<SystemPropertyConfigurationManager> clazz = SystemPropertyConfigurationManager.class;
        synchronized (SystemPropertyConfigurationManager.class) {
            if (systemProperties == null) {
                this.initialiseProperties();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loadConfigEagerly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseProperties() throws ConfigurationException {
        Class<SystemPropertyConfigurationManager> clazz = SystemPropertyConfigurationManager.class;
        synchronized (SystemPropertyConfigurationManager.class) {
            if (systemProperties == null) {
                systemProperties = new HashMap<String, String>(4);
                substitutedVariables = new HashMap<String, String>(2);
                String propertyName = "os.name";
                systemProperties.put(propertyName, System.getProperty(propertyName));
                propertyName = "user.dir";
                String propertyValue = System.getProperty(propertyName);
                userDir = SystemPropertyConfigurationManager.getDir(propertyValue, true);
                propertyName = "arflow.confdir";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = System.getProperty("adept2.confdir");
                }
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = "./conf";
                }
                confDirs = ConfigurationTools.parseCSVString(propertyValue, File.pathSeparator);
                propertyName = "user.home";
                propertyValue = System.getProperty(propertyName);
                try {
                    File confDir = SystemPropertyConfigurationManager.getDir(String.valueOf(propertyValue) + File.separatorChar + ".aristaflow", true);
                    this.logger.info(String.format("Adding user configuration directory ('%1$s').", confDir.getAbsolutePath()));
                    String[] newConfDirs = new String[confDirs.length + 1];
                    System.arraycopy(confDirs, 0, newConfDirs, 0, confDirs.length);
                    newConfDirs[SystemPropertyConfigurationManager.confDirs.length] = confDir.getAbsolutePath();
                    confDirs = newConfDirs;
                }
                catch (ConfigurationException configurationException) {
                    String msg = String.format("User configuration directory ('%s') does not exist or is not defined, ignoring.", propertyValue);
                    this.logger.fine(msg);
                }
                propertyName = "arflow.logdir";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = System.getProperty("adept2.logdir");
                }
                if (propertyValue == null) {
                    logDir = null;
                } else {
                    if (File.separatorChar == '\\') {
                        propertyValue = propertyValue.replaceAll("\\\\", "/");
                    }
                    logDir = SystemPropertyConfigurationManager.getDir(propertyValue, false);
                }
                logDirDefault = new File(userDir, "logs");
                propertyName = "arflow.datadir";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = System.getProperty("adept2.datadir");
                }
                if (propertyValue == null || propertyValue.equals("")) {
                    File f = new File("./examples");
                    try {
                        boolean success;
                        if (!f.exists() && !(success = f.mkdirs())) {
                            String msg = String.format("The data-directory '%s' could not be created! Aborting initialisation.", f.getAbsolutePath());
                            throw new ConfigurationException(msg);
                        }
                    }
                    catch (SecurityException securityException) {
                        String msg = String.format("The log-directory '%s' could not be accessed! Aborting initialisation.", f.getAbsolutePath());
                        throw new ConfigurationException(msg);
                    }
                    propertyValue = "./examples";
                } else if (File.separatorChar == '\\') {
                    propertyValue = propertyValue.replaceAll("\\\\", "/");
                }
                systemProperties.put(propertyName, propertyValue);
                substitutedVariables.put(propertyName, propertyValue);
                propertyName = "arflow.libdir";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = System.getProperty("adept2.libdir");
                }
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = "./lib";
                } else if (File.separatorChar == '\\') {
                    propertyValue = propertyValue.replaceAll("\\\\", "/");
                }
                systemProperties.put(propertyName, propertyValue);
                substitutedVariables.put(propertyName, propertyValue);
                propertyName = "arflow.configuration.bundle";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = System.getProperty("adept2.configuration.bundle");
                }
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                loadBundleConfig = Boolean.parseBoolean(propertyValue);
                propertyName = "arflow.debug.configuration";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = System.getProperty("adept2.debug.configuration");
                }
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                debugConfig = Boolean.parseBoolean(propertyValue);
                systemProperties.put(propertyName, propertyValue);
                propertyName = "arflow.configuration.loadEagerly";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                loadConfigEagerly = Boolean.parseBoolean(propertyValue);
                propertyName = "arflow.useSignedObject";
                propertyValue = System.getProperty(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                systemProperties.put(propertyName, propertyValue);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

