/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public final class DBSpecificTools {
    public static void updateColumnNullable(ExtendedConnection con, String tableName, String columnName, boolean nullable) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
        columnName = MetaDataTools.adjustIdentifierCase(metaData, columnName);
        ResultSet columns = metaData.getColumns(con.getCatalog(), con.getSchema(), tableName, columnName);
        while (columns.next()) {
            int oldNullable = columns.getInt("NULLABLE");
            if ((!nullable || oldNullable == 1) && (nullable || oldNullable == 0)) continue;
            String dbmsName = metaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            String alterTable = null;
            if (dbmsName.contains("derby")) {
                alterTable = String.format("ALTER TABLE %s ALTER COLUMN %s %sNULL", tableName, columnName, nullable ? "" : "NOT ");
            } else if (dbmsName.contains("oracle")) {
                alterTable = String.format("ALTER TABLE %s MODIFY %s %sNULL", tableName, columnName, nullable ? "" : "NOT ");
            } else if (dbmsName.contains("db2") || dbmsName.contains("postgres")) {
                alterTable = String.format("ALTER TABLE %s ALTER COLUMN %s %s NOT NULL", tableName, columnName, nullable ? "DROP" : "SET");
            } else if (dbmsName.contains("sqlserver") || dbmsName.contains("sql server")) {
                String type = con.getCorrespondingDBType(columns.getInt("DATA_TYPE"));
                alterTable = String.format("ALTER TABLE %s ALTER COLUMN %s %s %sNULL", tableName, columnName, type, nullable ? "" : "NOT ");
            } else if (dbmsName.contains("hsql")) {
                alterTable = String.format("ALTER TABLE %s ALTER COLUMN %s SET %sNULL", tableName, columnName, nullable ? "" : "NOT ");
            }
            if (alterTable == null) continue;
            PreparedStatement statement = con.prepareStatement(alterTable);
            try {
                statement.execute();
                if (!dbmsName.contains("db2")) continue;
                statement.close();
                String sql = "CALL SYSPROC.ADMIN_CMD('REORG TABLE %s')";
                statement = con.prepareStatement(String.format(sql, tableName));
                statement.execute();
            }
            finally {
                statement.close();
            }
        }
    }

    private DBSpecificTools() {
    }
}

