/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.base.dbaccess.DBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.base.dbaccess.StatementBuilder;
import de.aristaflow.adept2.base.dbaccess.model.ForeignKey;
import de.aristaflow.adept2.base.dbaccess.model.Table;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;

public abstract class DefaultDBAccessProvider
implements DBAccessProvider {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected List<String> recursionTables = new ArrayList<String>();
    private static final String CREATE_SEQUENCE = "CREATE SEQUENCE %s AS BIGINT START WITH %d INCREMENT BY %d";
    private static final String DROP_SEQUENCE = "DROP SEQUENCE %s";

    @Override
    public void adaptProperties(Properties props) {
    }

    @Override
    public String getEXCEPTKeyword() {
        return "EXCEPT";
    }

    @Override
    public String getDropForeignKeyConstraintKeyword() {
        return "FOREIGN KEY";
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode) {
        return this.getCorrespondingDBType(jdbcTypeCode, -1, -1);
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size) {
        return this.getCorrespondingDBType(jdbcTypeCode, size, -1);
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        String ret;
        this.checkTypeSizeAndScale(jdbcTypeCode, size, scale);
        boolean sizeSet = size > -1;
        switch (jdbcTypeCode) {
            case 16: {
                ret = "BOOLEAN";
                break;
            }
            case -7: {
                ret = "BIT";
                break;
            }
            case -6: {
                ret = "TINYINT";
                break;
            }
            case 5: {
                ret = "SMALLINT";
                break;
            }
            case 4: {
                ret = "INTEGER";
                break;
            }
            case -5: {
                ret = "BIGINT";
                break;
            }
            case 7: {
                ret = "REAL";
                break;
            }
            case 8: {
                ret = "DOUBLE PRECISION";
                break;
            }
            case 6: {
                ret = String.format("FLOAT(%d)", size);
                break;
            }
            case 3: {
                ret = String.format("DECIMAL(%d,%d)", size, scale);
                break;
            }
            case 2: {
                ret = String.format("NUMERIC(%d,%d)", size, scale);
                break;
            }
            case 1: {
                ret = String.format("CHAR(%d)", size);
                break;
            }
            case 12: {
                ret = String.format("VARCHAR(%d)", size);
                break;
            }
            case -1: {
                ret = "LONG VARCHAR";
                break;
            }
            case 2005: {
                ret = "CLOB";
                break;
            }
            case -2: {
                ret = String.format("BINARY(%d)", size);
                break;
            }
            case -3: {
                ret = String.format("VARBINARY(%d)", size);
                break;
            }
            case -4: {
                ret = "LONG VARBINARY";
                break;
            }
            case 2004: {
                ret = "BLOB";
                break;
            }
            case 91: {
                ret = "DATE";
                break;
            }
            case 92: {
                if (sizeSet) {
                    ret = String.format("TIME(%d)", size);
                    break;
                }
                ret = "TIME";
                break;
            }
            case 93: {
                if (sizeSet) {
                    ret = String.format("TIMESTAMP(%d)", size);
                    break;
                }
                ret = "TIMESTAMP";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    protected void checkTypeSizeAndScale(int jdbcTypeCode, int size, int scale) {
        boolean sizeSet = size > -1;
        boolean scaleSet = scale > -1;
        switch (jdbcTypeCode) {
            case 16: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for BOOLEAN!");
            }
            case -7: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for BIT!");
            }
            case -6: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for TINYINT!");
            }
            case 5: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for SMALLINT!");
            }
            case 4: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for INTEGER!");
            }
            case -5: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for BIGINT!");
            }
            case 7: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for REAL!");
            }
            case 8: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for DOUBLE!");
            }
            case 6: {
                if (!sizeSet || scaleSet) {
                    throw new IllegalArgumentException("Size must be set whereas scale must not be set for FLOAT!");
                }
                if (size != 0 && size <= 53) break;
                throw new IllegalArgumentException("The size for FLOAT must be in the range [1,53]!");
            }
            case 3: {
                if (!sizeSet || !scaleSet) {
                    throw new IllegalArgumentException("Size and scale must be set for DECIMAL!");
                }
                if (size != 0) break;
                throw new IllegalArgumentException("Size must not be 0 for DECIMAL!");
            }
            case 2: {
                if (!sizeSet || !scaleSet) {
                    throw new IllegalArgumentException("Size and scale must be set for NUMERIC!");
                }
                if (size != 0) break;
                throw new IllegalArgumentException("Size must not be 0 for NUMERIC!");
            }
            case 1: {
                if (!sizeSet || scaleSet) {
                    throw new IllegalArgumentException("Size must be set whereas scale must not be set for CHAR!");
                }
                if (size != 0) break;
                throw new IllegalArgumentException("Size must not be 0 for CHAR!");
            }
            case 12: {
                if (!sizeSet || scaleSet) {
                    throw new IllegalArgumentException("Size must be set whereas scale must not be set for VARCHAR!");
                }
                if (size != 0) break;
                throw new IllegalArgumentException("Size must not be 0 for VARCHAR!");
            }
            case -1: {
                if (!scaleSet) break;
                throw new IllegalArgumentException("Scale must not be set for LONGVARCHAR!");
            }
            case 2005: {
                if (!scaleSet) break;
                throw new IllegalArgumentException("Scale must not be set for CLOB!");
            }
            case -2: {
                if (!sizeSet || scaleSet) {
                    throw new IllegalArgumentException("Size must be set whereas scale must not be set for BINARY!");
                }
                if (size != 0) break;
                throw new IllegalArgumentException("Size must not be 0 for BINARY!");
            }
            case -3: {
                if (!sizeSet || scaleSet) {
                    throw new IllegalArgumentException("Size must be set whereas scale must not be set for VARBINARY!");
                }
                if (size != 0) break;
                throw new IllegalArgumentException("Size must not be 0 for VARBINARY!");
            }
            case -4: {
                if (!scaleSet) break;
                throw new IllegalArgumentException("Scale must not be set for LONGVARBINARY!");
            }
            case 2004: {
                if (!scaleSet) break;
                throw new IllegalArgumentException("Scale must not be set for BLOB!");
            }
            case 91: {
                if (!sizeSet && !scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for DATE!");
            }
            case 92: {
                if (!scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for TIME!");
            }
            case 93: {
                if (!scaleSet) break;
                throw new IllegalArgumentException("Size and scale must not be set for TIMESTAMP!");
            }
        }
    }

    @Override
    public String formatValue(Object value, int typeCode) {
        if (value == null) {
            return "null";
        }
        switch (typeCode) {
            case -7: 
            case 16: {
                if (value instanceof Boolean) {
                    boolean b = (Boolean)value;
                    return b ? "1" : "0";
                }
                return value.toString();
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return value.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return "'" + value.toString().replace("'", "''") + "'";
            }
            case 91: {
                if (!(value instanceof Time)) {
                    value = new Date(((java.util.Date)value).getTime());
                }
                return "{d '" + JDBCTools.toString((Date)value) + "'}";
            }
            case 92: {
                if (!(value instanceof Time)) {
                    value = new Time(((java.util.Date)value).getTime());
                }
                return "{t '" + JDBCTools.toString((Time)value) + "'}";
            }
            case 93: {
                if (!(value instanceof Timestamp)) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
                return "{ts '" + JDBCTools.toString((Timestamp)value) + "'}";
            }
        }
        throw new IllegalStateException("The JDBC type code " + typeCode + " is currently not supported!");
    }

    @Override
    public void dropColumn(ExtendedConnection con, String tableName, String columnName) throws SQLException {
        if (columnName == null) {
            throw new NullArgumentException("The parameter 'columnName' must not be null!");
        }
        if (tableName == null) {
            throw new NullArgumentException("The parameter 'tableName' must not be null!");
        }
        String alterStatement = String.format("ALTER TABLE %1$s DROP COLUMN %2$s", tableName, columnName);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(alterStatement);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected static void dropColumnWorkaround(ExtendedConnection origCon, String origTableName, String ... columnNames) throws SQLException {
        ExtendedConnection con = origCon;
        String tableName = origTableName;
        if (tableName == null) {
            throw new IllegalArgumentException("table name must not be null");
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new IllegalArgumentException("columns array must not be null or 0-sized");
        }
        if (!con.tableExists(tableName)) {
            String msg = "the table '%s' does not exist";
            msg = String.format(msg, tableName);
            throw new SQLException(msg);
        }
        DatabaseMetaData metaData = con.getMetaData();
        tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
        int i = 0;
        while (i < columnNames.length) {
            columnNames[i] = MetaDataTools.adjustIdentifierCase(metaData, columnNames[i]);
            ++i;
        }
        Boolean previousAutoCommitState = null;
        Statement stmt = null;
        try {
            String update;
            String q;
            previousAutoCommitState = JDBCTools.turnOffAutoCommit(con);
            stmt = con.createStatement();
            DatabaseMetaData meta = con.getMetaData();
            String tableNameTemp = String.valueOf(tableName) + "_TEMP";
            Table tableDefBefore = MetaDataTools.readTableDefinition(meta, origCon.getCatalog(), origCon.getSchema(), tableName);
            Table tableDefAfter = tableDefBefore.clone();
            ForeignKey[] exportedKeys = MetaDataTools.readExportedKeys(meta, con.getCatalog(), con.getSchema(), tableName);
            String[] stringArray = StatementBuilder.dropForeignKeys(meta, true, exportedKeys);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                q = stringArray[n2];
                DefaultDBAccessProvider.executeUpdate(stmt, q);
                ++n2;
            }
            if (tableDefBefore.getPrimaryKey() != null) {
                update = StatementBuilder.dropPrimaryKey(meta, tableDefBefore);
                DefaultDBAccessProvider.executeUpdate(stmt, update);
            }
            stringArray = StatementBuilder.dropForeignKeys(meta, tableDefBefore);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                q = stringArray[n2];
                DefaultDBAccessProvider.executeUpdate(stmt, q);
                ++n2;
            }
            tableDefAfter.setName(tableNameTemp);
            stringArray = columnNames;
            n = columnNames.length;
            n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                tableDefAfter.removeColumn(columnName);
                ++n2;
            }
            update = StatementBuilder.createTable(meta, tableDefAfter);
            DefaultDBAccessProvider.executeUpdate(stmt, update);
            update = "INSERT INTO %1$s (%3$s) SELECT %3$s FROM %2$s";
            update = String.format(update, tableNameTemp, tableName, StatementBuilder.toList(meta, true, tableDefAfter.getColumns(new String[0])));
            DefaultDBAccessProvider.executeUpdate(stmt, update);
            update = "DROP TABLE %1$s";
            update = String.format(update, tableName);
            DefaultDBAccessProvider.executeUpdate(stmt, update);
            update = "RENAME TABLE %1$s TO %2$s";
            update = String.format(update, tableNameTemp, tableName);
            DefaultDBAccessProvider.executeUpdate(stmt, update);
            stringArray = StatementBuilder.addForeignKeys(meta, true, exportedKeys);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                q = stringArray[n2];
                DefaultDBAccessProvider.executeUpdate(stmt, q);
                ++n2;
            }
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.restoreAutoCommit(con, previousAutoCommitState);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            JDBCTools.rollbackQuietly((Connection)con, previousAutoCommitState);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt);
        JDBCTools.rollbackQuietly((Connection)con, previousAutoCommitState);
    }

    private static void executeUpdate(Statement stmt, String query) throws SQLException {
        stmt.executeUpdate(query);
    }

    @Override
    public void createSequence(ExtendedConnection connection, String sequenceName, long start, long increment) throws SQLException {
        ArgChecks.checkForNull(sequenceName, "sequenceName");
        String query = String.format(CREATE_SEQUENCE, sequenceName, start, increment);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropSequence(ExtendedConnection connection, String sequenceName) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String query = String.format(DROP_SEQUENCE, sequenceName);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName, String startCondition, ParentToChildConnection[] parentToChildConnections, int maxDepth) throws SQLException {
        String recTableName = "RecTab" + new Random().nextInt(Integer.MAX_VALUE);
        StringBuilder createStatement = new StringBuilder(String.format("CREATE VIEW %1$s AS WITH RecRel(Depth, %2$s) AS (SELECT 1, %2$s FROM %3$s WHERE %4$s UNION ALL SELECT Parent.Depth + 1, %5$s FROM RecRel AS Parent, %3$s AS Child WHERE ", recTableName, this.concatSelectAttributes(null, selectAttributes), tableName, startCondition, this.concatSelectAttributes("Child", selectAttributes)));
        ParentToChildConnection[] parentToChildConnectionArray = parentToChildConnections;
        int n = parentToChildConnections.length;
        int n2 = 0;
        while (n2 < n) {
            ParentToChildConnection pcConnection = parentToChildConnectionArray[n2];
            createStatement.append(String.format("Parent.%1$s %2$s Child.%3$s AND ", pcConnection.getParentAttribute(), pcConnection.getOperator(), pcConnection.getChildAttribute()));
            ++n2;
        }
        createStatement.append(String.format("Parent.Depth < %1$s) SELECT * FROM RecRel", maxDepth));
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
        this.recursionTables.add(recTableName);
        this.logger.finer(String.format("Added '%1$s' to recursionTables.", recTableName));
        return recTableName;
    }

    protected String concatSelectAttributes(String tablePrefix, String[] selectAttributes) {
        boolean prefixExists;
        StringBuilder ret = new StringBuilder(100);
        boolean bl = prefixExists = tablePrefix != null && tablePrefix.length() > 0;
        if (selectAttributes != null) {
            String[] stringArray = selectAttributes;
            int n = selectAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                String selectAttribute = stringArray[n2];
                if (prefixExists) {
                    ret.append(String.format("%1$s.", tablePrefix));
                }
                ret.append(String.format("%1$s, ", selectAttribute));
                ++n2;
            }
            if (selectAttributes.length > 0) {
                ret.delete(ret.length() - 2, ret.length());
            }
        }
        return ret.toString();
    }

    @Override
    public void dropAllRecursionTables(ExtendedConnection connection) throws SQLException {
        String[] recursionTableNames;
        String[] stringArray = recursionTableNames = this.recursionTables.toArray(new String[this.recursionTables.size()]);
        int n = recursionTableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String currentName = stringArray[n2];
            this.dropRecursionTable(connection, currentName);
            ++n2;
        }
    }

    @Override
    public void dropRecursionTable(ExtendedConnection connection, String tableName) throws SQLException {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            if (this.recursionTables.contains(tableName)) {
                stmt.executeUpdate(String.format("DROP VIEW %1$s", tableName));
                this.recursionTables.remove(tableName);
                this.logger.finer(String.format("Removed '%1$s' from recursionTables.", tableName));
            }
            stmt.close();
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }
}

