/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JDBCTools {
    public static final long MIN_TIMESTAMP = -62135769600000L;
    public static final long MAX_TIMESTAMP = 253402300799999L;
    private static Logger logger = LoggerTools.getLogger(JDBCTools.class);

    public static Boolean turnOffAutoCommit(Connection con) throws SQLException {
        boolean previousAutoCommitState = con.getAutoCommit();
        if (previousAutoCommitState) {
            con.setAutoCommit(false);
        }
        return previousAutoCommitState;
    }

    public static ResultSet close(ResultSet rs) throws SQLException {
        rs.close();
        return null;
    }

    public static <S extends Statement> S close(S stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
        return null;
    }

    public static <C extends Connection> C close(C con) throws SQLException {
        if (!con.getAutoCommit()) {
            con.commit();
        }
        con.close();
        return null;
    }

    public static <C extends Connection> C commit(C con) throws SQLException {
        con.commit();
        return null;
    }

    public static <C extends Connection> C restoreAutoCommit(C con, Boolean previousAutoCommitState) throws SQLException {
        if (previousAutoCommitState != null && previousAutoCommitState.booleanValue()) {
            con.commit();
            con.setAutoCommit(true);
        }
        return null;
    }

    public static <C extends Connection> C restoreAutoCommit(C con, Savepoint sp, Boolean previousAutoCommitState) throws SQLException {
        if (previousAutoCommitState != null) {
            if (previousAutoCommitState.booleanValue()) {
                con.commit();
                con.setAutoCommit(true);
            } else {
                con.releaseSavepoint(sp);
            }
        }
        return null;
    }

    public static void closeQuietly(Connection con, Statement stmt, ResultSet rs) {
        JDBCTools.closeQuietly(rs);
        JDBCTools.closeQuietly(stmt);
        JDBCTools.closeQuietly(con);
    }

    public static void closeQuietly(Connection con, Statement stmt) {
        JDBCTools.closeQuietly(stmt);
        JDBCTools.closeQuietly(con);
    }

    public static void closeQuietly(Statement stmt, ResultSet rs) {
        JDBCTools.closeQuietly(rs);
        JDBCTools.closeQuietly(stmt);
    }

    public static void closeQuietly(Connection con) {
        block6: {
            if (con != null) {
                try {
                    if (con.isClosed()) break block6;
                    try {
                        if (!con.getAutoCommit()) {
                            con.rollback();
                        }
                    }
                    catch (SQLException ex) {
                        String msg = "A exception occurred while trying to close a JDBC connection quietly.";
                        logger.log(Level.FINE, msg, ex);
                    }
                    con.close();
                }
                catch (Exception ex) {
                    String msg = "An exception occurred while trying to close a JDBC connection quietly.";
                    logger.log(Level.FINE, msg, ex);
                }
            }
        }
    }

    public static void closeQuietly(Statement ... stmts) {
        Statement[] statementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            Statement stmt = statementArray[n2];
            JDBCTools.closeQuietly(stmt);
            ++n2;
        }
    }

    public static void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex) {
                String msg = String.format("The exception %s will be ignored.", ex);
                logger.finest(msg);
            }
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                String msg = String.format("The exception %s will be ignored.", ex);
                logger.finest(msg);
            }
        }
    }

    public static void rollbackQuietly(Connection con) {
        if (con != null) {
            try {
                if (!con.isClosed() && !con.getAutoCommit()) {
                    con.rollback();
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                String msg = "An attempted rollback in the data source has failed!";
                logger.log(Level.WARNING, msg, ex);
            }
        }
    }

    public static void rollbackQuietly(Connection con, Boolean previousAutoCommitState) {
        if (con != null) {
            String msg;
            try {
                if (!con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException occurred while trying to rollback the previous action.";
                logger.log(Level.FINE, msg, ex);
            }
            if (previousAutoCommitState != null) {
                try {
                    con.setAutoCommit(previousAutoCommitState);
                }
                catch (SQLException e) {
                    msg = String.format("A SQLException occurred while trying to set auto commit to %s.", (boolean)previousAutoCommitState);
                    logger.log(Level.FINE, msg, e);
                }
            }
        }
    }

    public static void rollbackQuietly(Connection con, Savepoint sp) {
        if (con != null && sp != null) {
            try {
                if (!con.getAutoCommit()) {
                    con.rollback(sp);
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                String msg = "An attempted rollback in the data source has failed!";
                logger.log(Level.WARNING, msg, ex);
            }
        }
    }

    public static void rollbackQuietly(Connection con, Savepoint sp, Boolean previousAutoCommitState) {
        if (con != null && sp != null) {
            String msg;
            try {
                if (!con.getAutoCommit()) {
                    con.rollback(sp);
                }
            }
            catch (SQLException ex) {
                msg = "A SQLException occurred while trying to rollback the previous action.";
                logger.log(Level.FINE, msg, ex);
            }
            if (previousAutoCommitState != null) {
                try {
                    con.setAutoCommit(previousAutoCommitState);
                }
                catch (SQLException e) {
                    msg = String.format("A SQLException occurred while trying to set auto commit to %s.", (boolean)previousAutoCommitState);
                    logger.log(Level.FINE, msg, e);
                }
            }
        }
    }

    public static String toString(Date d) {
        if (d.getTime() < -62135769600000L) {
            throw new IllegalArgumentException("the timestamp must not be before 0001-01-01 00:00:00 (UTC)");
        }
        if (d.getTime() > 253402300799999L) {
            throw new IllegalArgumentException("the timestamp must not be after 9999-12-31 23:59:59 (UTC)");
        }
        return JDBCTools.df("yyyy-MM-dd").format(d);
    }

    public static String toString(Time t) {
        return JDBCTools.df("HH:mm:ss").format(t);
    }

    public static String toString(Timestamp ts) {
        if (ts.getTime() < -62135769600000L) {
            throw new IllegalArgumentException("the timestamp must not be before 0001-01-01 00:00:00 (UTC)");
        }
        if (ts.getTime() > 253402300799999L) {
            throw new IllegalArgumentException("the timestamp must not be after 9999-12-31 23:59:59 (UTC)");
        }
        String tsString = JDBCTools.df("yyyy-MM-dd HH:mm:ss").format(ts);
        String nanoString = ts.getNanos() == 0 ? "0" : StringTools.rtrim(StringTools.lpad(Integer.toString(ts.getNanos() / 1000), 6, "0"), "0");
        return String.valueOf(tsString) + "." + nanoString;
    }

    public static Date trim(Date d) {
        Date nd = new Date(d.getTime());
        if (d.getTime() < -62135769600000L) {
            nd.setTime(-62135769600000L);
        } else if (d.getTime() > 253402300799999L) {
            nd.setTime(253402300799999L);
        }
        return nd;
    }

    public static Timestamp trim(Timestamp ts) {
        Timestamp nts = new Timestamp(ts.getTime());
        nts.setNanos(ts.getNanos());
        if (ts.getTime() < -62135769600000L) {
            nts.setTime(-62135769600000L);
            nts.setNanos(0);
        } else if (ts.getTime() > 253402300799999L) {
            nts.setTime(253402300799999L);
            nts.setNanos(999999999);
        }
        return nts;
    }

    private static DateFormat df(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    public static Calendar createUTCCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    private JDBCTools() {
    }
}

