/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.model.Column;
import de.aristaflow.adept2.base.dbaccess.model.ForeignKey;
import de.aristaflow.adept2.base.dbaccess.model.Table;
import de.aristaflow.adept2.util.ArgChecks;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

public final class MetaDataTools {
    public static ForeignKey[] readExportedKeys(DatabaseMetaData metaData, String catalog, String schema, String origPKTable) throws SQLException {
        String pkTable = origPKTable;
        ArgChecks.checkForNull(metaData, "metaData");
        ArgChecks.checkForBlank(pkTable, "pkTable");
        pkTable = MetaDataTools.adjustIdentifierCase(metaData, pkTable);
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        ResultSet rs = null;
        try {
            ForeignKey fk;
            String fkName = null;
            String fkTable = null;
            ArrayList<String> fkColumnNames = new ArrayList<String>();
            ArrayList<String> pkColumnNames = new ArrayList<String>();
            short updateRule = -1;
            short deleteRule = -1;
            rs = metaData.getExportedKeys(catalog, schema, pkTable);
            while (rs.next()) {
                if (pkColumnNames.size() != rs.getShort("KEY_SEQ") - 1) {
                    fk = new ForeignKey(fkName, fkTable, MetaDataTools.toArray(fkColumnNames), pkTable, MetaDataTools.toArray(pkColumnNames));
                    fk.setUpdateRule(updateRule);
                    fk.setDeleteRule(deleteRule);
                    foreignKeys.add(fk);
                    fkColumnNames.clear();
                    pkColumnNames.clear();
                }
                fkName = rs.getString("FK_NAME");
                fkTable = rs.getString("FKTABLE_NAME");
                updateRule = rs.getShort("UPDATE_RULE");
                deleteRule = rs.getShort("DELETE_RULE");
                fkColumnNames.add(rs.getString("FKCOLUMN_NAME"));
                pkColumnNames.add(rs.getString("PKCOLUMN_NAME"));
            }
            if (fkColumnNames.size() > 0) {
                fk = new ForeignKey(fkName, fkTable, MetaDataTools.toArray(fkColumnNames), pkTable, MetaDataTools.toArray(pkColumnNames));
                fk.setUpdateRule(updateRule);
                fk.setDeleteRule(deleteRule);
                foreignKeys.add(fk);
            }
            rs = JDBCTools.close(rs);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return foreignKeys.toArray(new ForeignKey[foreignKeys.size()]);
    }

    public static Table readTableDefinition(DatabaseMetaData metaData, String catalog, String schema, String tableName) throws SQLException {
        ArgChecks.checkForNull(metaData, "metaData");
        ArgChecks.checkForBlank(tableName, "tableName");
        tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
        Table table = new Table(tableName);
        table.setQuoteIdentifiers(true);
        ResultSet rs = null;
        try {
            int n;
            ForeignKey fk;
            rs = metaData.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                Column col = table.addColumn(colName);
                col.setType(rs.getInt("DATA_TYPE"));
                col.setTypeName(rs.getString("TYPE_NAME"));
                col.setSize(rs.getInt("COLUMN_SIZE"));
                col.setScale(rs.getInt("DECIMAL_DIGITS"));
                int NULLABLE = rs.getInt("NULLABLE");
                String IS_NULLABLE = rs.getString("IS_NULLABLE");
                if (NULLABLE == 1) {
                    col.setNotNull(false);
                } else if (IS_NULLABLE.equals("NO")) {
                    col.setNotNull(true);
                } else {
                    col.setNotNull(false);
                }
                col.setDefaultValue(rs.getString("COLUMN_DEF"));
                if (table.getColumnCount() != rs.getInt("ORDINAL_POSITION")) {
                    throw new AssertionError();
                }
            }
            rs = JDBCTools.close(rs);
            String pkName = null;
            ArrayList<String> pkColumnNames = new ArrayList<String>();
            rs = metaData.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                pkName = rs.getString("PK_NAME");
                pkColumnNames.add(rs.getString("COLUMN_NAME"));
                if (pkColumnNames.size() != rs.getShort("KEY_SEQ")) {
                    throw new AssertionError();
                }
            }
            if (pkColumnNames.size() > 0) {
                table.setPrimaryKey(pkName, pkColumnNames.toArray(new String[pkColumnNames.size()]));
            }
            rs = JDBCTools.close(rs);
            String fkName = null;
            String pkTable = null;
            ArrayList<String> fkColumnNames = new ArrayList<String>();
            ArrayList<String> pkColumnNames2 = new ArrayList<String>();
            short updateRule = -1;
            short deleteRule = -1;
            rs = metaData.getImportedKeys(catalog, schema, tableName);
            while (rs.next()) {
                if (pkColumnNames2.size() != rs.getShort("KEY_SEQ") - 1) {
                    fk = table.addForeignKey(fkName, MetaDataTools.toArray(fkColumnNames), pkTable, MetaDataTools.toArray(pkColumnNames2));
                    fk.setUpdateRule(updateRule);
                    fk.setDeleteRule(deleteRule);
                    fkColumnNames.clear();
                    pkColumnNames2.clear();
                }
                fkName = rs.getString("FK_NAME");
                pkTable = rs.getString("PKTABLE_NAME");
                updateRule = rs.getShort("UPDATE_RULE");
                deleteRule = rs.getShort("DELETE_RULE");
                fkColumnNames.add(rs.getString("FKCOLUMN_NAME"));
                pkColumnNames2.add(rs.getString("PKCOLUMN_NAME"));
            }
            if (fkColumnNames.size() > 0) {
                fk = table.addForeignKey(fkName, MetaDataTools.toArray(fkColumnNames), pkTable, MetaDataTools.toArray(pkColumnNames2));
                fk.setUpdateRule(updateRule);
                fk.setDeleteRule(deleteRule);
            }
            rs = JDBCTools.close(rs);
            ArrayList<String> columnNames = new ArrayList<String>();
            rs = metaData.getIndexInfo(catalog, schema, tableName, true, true);
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                short ORDINAL_POSITION = rs.getShort("ORDINAL_POSITION");
                if (ORDINAL_POSITION == 1 && columnNames.size() > 0) {
                    String[] columnNamesArray = MetaDataTools.toArray(columnNames);
                    columnNames.clear();
                    boolean alreadyInConstraint = false;
                    if (table.getPrimaryKey() != null && table.getPrimaryKey().matchesColumnSet(columnNamesArray)) {
                        alreadyInConstraint = true;
                    }
                    if (!alreadyInConstraint) {
                        ForeignKey[] foreignKeyArray = table.getForeignKeys();
                        int n2 = foreignKeyArray.length;
                        n = 0;
                        while (n < n2) {
                            ForeignKey fk2 = foreignKeyArray[n];
                            if (fk2.matchesColumnSet(columnNamesArray)) {
                                alreadyInConstraint = true;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (!alreadyInConstraint) {
                        table.addUniqueConstraint(null, columnNamesArray);
                    }
                }
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
            if (columnNames.size() > 0) {
                String[] columnNamesArray = MetaDataTools.toArray(columnNames);
                boolean alreadyInConstraint = false;
                if (table.getPrimaryKey() != null && table.getPrimaryKey().matchesColumnSet(columnNamesArray)) {
                    alreadyInConstraint = true;
                }
                if (!alreadyInConstraint) {
                    ForeignKey[] foreignKeyArray = table.getForeignKeys();
                    n = foreignKeyArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ForeignKey fk3 = foreignKeyArray[n3];
                        if (fk3.matchesColumnSet(columnNamesArray)) {
                            alreadyInConstraint = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!alreadyInConstraint) {
                    table.addUniqueConstraint(null, columnNamesArray);
                }
            }
            rs = JDBCTools.close(rs);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return table;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static String typeCodeToString(int typeCode) {
        Field[] fieldArray = Types.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers())) {
                try {
                    int fieldTypeCode = field.getInt(null);
                    if (typeCode == fieldTypeCode) {
                        return field.getName();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
        return "(unknown)";
    }

    public static int stringToTypeCode(String typeName) {
        Field[] fieldArray = Types.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers())) {
                try {
                    if (typeName.equals(field.getName())) {
                        int fieldTypeCode = field.getInt(null);
                        return fieldTypeCode;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
        return Integer.MIN_VALUE;
    }

    public static String adjustIdentifierCase(DatabaseMetaData metaData, String identifier) throws SQLException {
        if (metaData.storesUpperCaseIdentifiers()) {
            return identifier.toUpperCase();
        }
        if (metaData.storesLowerCaseIdentifiers()) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    public static String adjustQuotedIdentifierCase(DatabaseMetaData metaData, String identifier) throws SQLException {
        if (metaData.storesUpperCaseQuotedIdentifiers()) {
            return identifier.toUpperCase();
        }
        if (metaData.storesLowerCaseQuotedIdentifiers()) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    private MetaDataTools() {
    }
}

