/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLStatementExecutor {
    List<String> statements = new ArrayList<String>();
    private ExtendedConnection connection;
    private boolean continueOnException;
    private boolean escapeProcessing;

    public SQLStatementExecutor() {
        this(null);
    }

    public SQLStatementExecutor(ExtendedConnection connection) {
        this(connection, true);
    }

    public SQLStatementExecutor(ExtendedConnection connection, boolean continueOnException) {
        this(connection, continueOnException, true);
    }

    public SQLStatementExecutor(ExtendedConnection connection, boolean continueOnException, boolean escapeProcessing) {
        this.connection = connection;
        this.continueOnException = continueOnException;
        this.escapeProcessing = escapeProcessing;
    }

    public ExtendedConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ExtendedConnection connection) {
        this.connection = connection;
    }

    public boolean getContinueOnException() {
        return this.continueOnException;
    }

    public void setContinueOnException(boolean continueOnException) {
        this.continueOnException = continueOnException;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    public void setEscapeProcessing(boolean escapeProcessing) {
        this.escapeProcessing = escapeProcessing;
    }

    public void addStatements(String sqlScriptFile) throws IOException {
        List<String> moreStatements = SQLTools.parseSQLScriptToStatements(new FileInputStream(sqlScriptFile), null);
        this.statements.addAll(moreStatements);
    }

    public void addStatements(File sqlScriptFile) throws IOException {
        List<String> moreStatements = SQLTools.parseSQLScriptToStatements(new FileInputStream(sqlScriptFile), null);
        this.statements.addAll(moreStatements);
    }

    public void addStatements(InputStream sqlScriptInputStream) throws IOException {
        List<String> moreStatements = SQLTools.parseSQLScriptToStatements(sqlScriptInputStream, null);
        this.statements.addAll(moreStatements);
    }

    public void addStatements(String ... statements) {
        String[] stringArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            String statement = stringArray[n2];
            this.statements.add(statement);
            ++n2;
        }
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public void execute() throws SQLException {
        if (this.connection == null) {
            throw new IllegalStateException("An ExtendedConnection must be specified first!");
        }
        if (this.escapeProcessing) {
            SQLTools.processEscapes(this.connection, this.statements, this.continueOnException);
        }
        SQLTools.executeSQLStatements(this.connection, this.statements, this.continueOnException);
    }

    public void execute(SQLTools.ProgressListener listener) throws SQLException {
        if (this.connection == null) {
            throw new IllegalStateException("An ExtendedConnection must be specified first!");
        }
        if (this.escapeProcessing) {
            SQLTools.processEscapes(this.connection, this.statements, this.continueOnException);
        }
        SQLTools.executeSQLStatements(this.connection, this.statements, this.continueOnException, listener);
    }

    public boolean executeQuietly() {
        if (this.connection == null) {
            throw new IllegalStateException("An ExtendedConnection must be specified first!");
        }
        if (this.escapeProcessing) {
            SQLTools.processEscapes(this.connection, this.statements, this.continueOnException);
        }
        boolean successful = SQLTools.executeSQLStatementsQuietly(this.connection, this.statements, this.continueOnException);
        return successful;
    }
}

