/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLTools {
    private static final boolean consoleMessages = false;
    protected static final Logger logger = LoggerTools.getLogger(SQLTools.class);
    private static final Pattern DATATYPE_ESCAPE_SYNTAX_PATTERN = Pattern.compile("\\{type\\s+(\\w*?)(?:\\((\\d+)(?:,(\\d+))?\\))?\\}", 2);
    private static final Pattern CREATE_SEQUENCE_PATTERN = Pattern.compile("\\{createSeq\\s+\\\"(\\w*?)\\\"(?:\\s+start=(\\d+)(?:\\s+inc=(\\d+))?)?\\}", 2);
    private static final Pattern DROP_SEQUENCE_PATTERN = Pattern.compile("\\{dropSeq\\s+\\\"(\\w*?)\\\"\\}", 2);
    private static final Pattern NEXT_ID_PATTERN = Pattern.compile("\\{nextID\\s+\\\"(\\w*?)\\\"\\}", 2);
    private static final Pattern DROP_SCHEMA_VERSION_PATTERN = Pattern.compile("\\{dropSchemaVersion\\s+\\\"(\\w*?)\\\"\\}", 2);

    public static List<String> parseSQLScriptToStatements(String sqlScriptFile, List<String> statements) throws IOException {
        ArgChecks.checkForNull(sqlScriptFile, "sqlScriptFile");
        return SQLTools.parseSQLScriptToStatements(new FileInputStream(sqlScriptFile), statements);
    }

    public static List<String> parseSQLScriptToStatements(InputStream sqlScriptStream, List<String> statements) throws IOException {
        ArgChecks.checkForNull(sqlScriptStream, "sqlScriptStream");
        BufferedReader reader = new BufferedReader(new InputStreamReader(sqlScriptStream, "UTF-8"));
        return SQLTools.parseSQLFromReaderToStatements(reader, statements);
    }

    public static List<String> parseSQLStringToStatements(String sqlString, List<String> statements) throws IOException {
        ArgChecks.checkForNull(sqlString, "sqlString");
        BufferedReader reader = new BufferedReader(new StringReader(sqlString));
        return SQLTools.parseSQLFromReaderToStatements(reader, statements);
    }

    private static List<String> parseSQLFromReaderToStatements(Reader sqlReader, List<String> origStatements) throws IOException {
        String line;
        List<String> statements = origStatements;
        ArgChecks.checkForNull(sqlReader, "sqlReader");
        BufferedReader reader = new BufferedReader(sqlReader);
        if (statements == null) {
            statements = new ArrayList<String>();
        }
        StringBuilder statementBuilder = new StringBuilder();
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).equals("") || line.startsWith("--")) continue;
            if (!firstLine) {
                statementBuilder.append(" ");
            } else {
                firstLine = false;
            }
            if (line.endsWith(";")) {
                line = line.substring(0, line.length() - 1);
                statementBuilder.append(line);
                statements.add(statementBuilder.toString());
                statementBuilder.setLength(0);
                firstLine = true;
                continue;
            }
            statementBuilder.append(line);
        }
        if (statementBuilder.length() > 0) {
            statements.add(statementBuilder.toString());
        }
        reader.close();
        return statements;
    }

    public static void executeSQLStatements(ExtendedConnection connection, List<String> statements, boolean continueOnException) throws SQLException {
        SQLTools.executeSQLStatements(connection, statements, continueOnException, null);
    }

    public static void executeSQLStatements(ExtendedConnection connection, List<String> statements, boolean continueOnException, ProgressListener listener) throws SQLException {
        if (connection == null) {
            throw new NullArgumentException("The parameter 'connection' must not be null!");
        }
        if (statements == null) {
            throw new NullArgumentException("The parameter 'statements' must not be null!");
        }
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            SQLException firstException = null;
            int i = 0;
            for (String statement : statements) {
                try {
                    String msg = "[SQLTools] executing: " + statement;
                    logger.fine(msg);
                    if (listener != null) {
                        listener.executing(statement, i, statements.size());
                    }
                    if ((statement = SQLTools.processRuntimeEscapes(connection, statement)) != null) {
                        stmt.executeUpdate(statement);
                    }
                    if (listener != null) {
                        listener.executed(statement, i, statements.size(), null);
                    }
                }
                catch (SQLException ex) {
                    logger.log(Level.FINE, "[SQLTools] the following exception has been ignored: " + ex.getMessage(), ex);
                    if (listener != null) {
                        listener.executed(statement, i, statements.size(), ex);
                    }
                    if (!continueOnException) {
                        throw ex;
                    }
                    if (firstException == null) {
                        firstException = ex;
                    }
                    firstException.setNextException(ex);
                }
                ++i;
            }
            stmt = JDBCTools.close(stmt);
            if (firstException != null) {
                throw firstException;
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
            if (listener != null) {
                listener.done();
            }
        }
    }

    public static boolean executeSQLStatementsQuietly(ExtendedConnection connection, List<String> statements, boolean continueOnException) {
        try {
            SQLTools.executeSQLStatements(connection, statements, continueOnException);
        }
        catch (SQLException ex) {
            String msg = "A SQLException occurred while trying to execute a sql statement quietly.";
            logger.log(Level.FINE, msg, ex);
            return false;
        }
        return true;
    }

    public static String processEscapes(ExtendedConnection connection, String statement) {
        ArgChecks.checkForNull(connection, "connection");
        ArgChecks.checkForNull(statement, "statement");
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(statement);
        SQLTools.processDataTypeEscapes(connection, statements);
        SQLTools.processDropForeignKeyConstraintEscapes(connection, statements);
        return (String)statements.get(0);
    }

    public static void processEscapes(ExtendedConnection connection, List<String> statements, boolean continueOnException) {
        ArgChecks.checkForNull(connection, "connection");
        ArgChecks.checkForNull(statements, "statements");
        String trueString = connection.formatValue(Boolean.TRUE, 16);
        String falseString = connection.formatValue(Boolean.FALSE, 16);
        int i = 0;
        int s = statements.size();
        while (i < s) {
            String statement = statements.get(i);
            if (statement != null) {
                statement = statement.replace("{true}", trueString);
                statement = statement.replace("{false}", falseString);
                statements.set(i, statement);
            }
            ++i;
        }
        SQLTools.processDataTypeEscapes(connection, statements);
        SQLTools.processDropForeignKeyConstraintEscapes(connection, statements);
    }

    private static void processDataTypeEscapes(ExtendedConnection connection, List<String> statements) {
        if (connection == null) {
            throw new NullArgumentException("The parameter 'connection' must not be null!");
        }
        if (statements == null) {
            throw new NullArgumentException("The parameter 'statements' must not be null!");
        }
        Matcher matcher = DATATYPE_ESCAPE_SYNTAX_PATTERN.matcher("");
        StringBuilder stmtBuilder = new StringBuilder();
        int i = 0;
        int s = statements.size();
        while (i < s) {
            String statement = statements.get(i);
            if (statement == null) {
                logger.log(Level.FINE, "[SQLTools] ignoring a null-value in the list of statements.");
            } else {
                String processedStmt = SQLTools.processDataTypeEscapes(connection, statement, matcher, stmtBuilder);
                if (!processedStmt.equals(statement)) {
                    statements.set(i, processedStmt);
                }
            }
            ++i;
        }
    }

    private static String processDataTypeEscapes(ExtendedConnection connection, String statement, Matcher origDataTypeEscapeSyntaxMatcher, StringBuilder origStmtBuilder) {
        Matcher dataTypeEscapeSyntaxMatcher = origDataTypeEscapeSyntaxMatcher;
        StringBuilder stmtBuilder = origStmtBuilder;
        if (connection == null) {
            throw new IllegalArgumentException("The parameter 'connection' must not be null!");
        }
        if (statement == null) {
            throw new IllegalArgumentException("The parameter 'statement' must not be null!");
        }
        if (dataTypeEscapeSyntaxMatcher == null) {
            dataTypeEscapeSyntaxMatcher = DATATYPE_ESCAPE_SYNTAX_PATTERN.matcher(statement);
        } else {
            dataTypeEscapeSyntaxMatcher.reset(statement);
        }
        int offset = 0;
        boolean dataTypeEscapeEncountered = false;
        while (dataTypeEscapeSyntaxMatcher.find()) {
            int jdbcTypeCode;
            String type = dataTypeEscapeSyntaxMatcher.group(1);
            if (type.equalsIgnoreCase("BOOLEAN")) {
                jdbcTypeCode = 16;
            } else if (type.equalsIgnoreCase("BIT")) {
                jdbcTypeCode = -7;
            } else if (type.equalsIgnoreCase("TINYINT")) {
                jdbcTypeCode = -6;
            } else if (type.equalsIgnoreCase("SMALLINT")) {
                jdbcTypeCode = 5;
            } else if (type.equalsIgnoreCase("INTEGER")) {
                jdbcTypeCode = 4;
            } else if (type.equalsIgnoreCase("BIGINT")) {
                jdbcTypeCode = -5;
            } else if (type.equalsIgnoreCase("REAL")) {
                jdbcTypeCode = 7;
            } else if (type.equalsIgnoreCase("DOUBLE")) {
                jdbcTypeCode = 8;
            } else if (type.equalsIgnoreCase("FLOAT")) {
                jdbcTypeCode = 6;
            } else if (type.equalsIgnoreCase("NUMERIC")) {
                jdbcTypeCode = 2;
            } else if (type.equalsIgnoreCase("DECIMAL")) {
                jdbcTypeCode = 3;
            } else if (type.equalsIgnoreCase("CHAR")) {
                jdbcTypeCode = 1;
            } else if (type.equalsIgnoreCase("VARCHAR")) {
                jdbcTypeCode = 12;
            } else if (type.equalsIgnoreCase("LONGVARCHAR")) {
                jdbcTypeCode = -1;
            } else if (type.equalsIgnoreCase("CLOB")) {
                jdbcTypeCode = 2005;
            } else if (type.equalsIgnoreCase("BINARY")) {
                jdbcTypeCode = -2;
            } else if (type.equalsIgnoreCase("VARBINARY")) {
                jdbcTypeCode = -3;
            } else if (type.equalsIgnoreCase("LONGVARBINARY")) {
                jdbcTypeCode = -4;
            } else if (type.equalsIgnoreCase("BLOB")) {
                jdbcTypeCode = 2004;
            } else if (type.equalsIgnoreCase("DATE")) {
                jdbcTypeCode = 91;
            } else if (type.equalsIgnoreCase("TIME")) {
                jdbcTypeCode = 92;
            } else if (type.equalsIgnoreCase("TIMESTAMP")) {
                jdbcTypeCode = 93;
            } else {
                String msg = "[SQLTools] unknown JDBC type '%s' encountered in statement '%s'! The data type escape is left untouched.";
                msg = String.format(msg, type, statement);
                logger.log(Level.FINE, msg);
                continue;
            }
            int size = dataTypeEscapeSyntaxMatcher.group(2) == null ? -1 : Integer.parseInt(dataTypeEscapeSyntaxMatcher.group(2));
            int scale = dataTypeEscapeSyntaxMatcher.group(3) == null ? -1 : Integer.parseInt(dataTypeEscapeSyntaxMatcher.group(3));
            String dbType = connection.getCorrespondingDBType(jdbcTypeCode, size, scale);
            if (!dataTypeEscapeEncountered) {
                if (stmtBuilder == null) {
                    stmtBuilder = new StringBuilder(statement);
                } else {
                    stmtBuilder.setLength(0);
                    stmtBuilder.append(statement);
                }
            }
            stmtBuilder.replace(offset + dataTypeEscapeSyntaxMatcher.start(), offset + dataTypeEscapeSyntaxMatcher.end(), dbType);
            dataTypeEscapeEncountered = true;
            int oldLength = dataTypeEscapeSyntaxMatcher.end() - dataTypeEscapeSyntaxMatcher.start();
            int newLength = dbType.length();
            offset += newLength - oldLength;
        }
        if (dataTypeEscapeEncountered) {
            return stmtBuilder.toString();
        }
        return statement;
    }

    private static void processDropForeignKeyConstraintEscapes(ExtendedConnection connection, List<String> statements) {
        if (connection == null) {
            throw new NullArgumentException("The parameter 'connection' must not be null!");
        }
        if (statements == null) {
            throw new NullArgumentException("The parameter 'statements' must not be null!");
        }
        int i = 0;
        int s = statements.size();
        while (i < s) {
            String statement = statements.get(i);
            if (statement == null) {
                logger.log(Level.FINE, "[SQLTools] ignoring a null-value in the list of statements.");
            } else {
                String processedStmt = SQLTools.processDropForeignKeyConstraintEscapes(connection, statement);
                statements.set(i, processedStmt);
            }
            ++i;
        }
    }

    private static String processDropForeignKeyConstraintEscapes(ExtendedConnection connection, String statement) {
        if (connection == null) {
            throw new IllegalArgumentException("The parameter 'connection' must not be null!");
        }
        if (statement == null) {
            throw new IllegalArgumentException("The parameter 'statement' must not be null!");
        }
        String keyword = connection.getDropForeignKeyConstraintKeyword();
        return statement.replace("{df}", keyword);
    }

    private static String processRuntimeEscapes(ExtendedConnection connection, String statement) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("The parameter 'connection' must not be null!");
        }
        if (statement == null) {
            throw new IllegalArgumentException("The parameter 'statement' must not be null!");
        }
        Matcher createSequence = CREATE_SEQUENCE_PATTERN.matcher("");
        Matcher dropSequence = DROP_SEQUENCE_PATTERN.matcher("");
        Matcher nextID = NEXT_ID_PATTERN.matcher("");
        Matcher dropSchemaVersion = DROP_SCHEMA_VERSION_PATTERN.matcher("");
        dropSchemaVersion.reset(statement);
        if (dropSchemaVersion.find()) {
            String serviceName = dropSchemaVersion.group(1);
            connection.dropSchemaVersion(serviceName);
            return null;
        }
        nextID.reset(statement);
        if (nextID.find()) {
            StringBuffer stmtBuffer = new StringBuffer();
            String seqName = nextID.group(1);
            long id = connection.nextID(seqName);
            nextID.appendReplacement(stmtBuffer, Long.toString(id));
            nextID.appendTail(stmtBuffer);
            return stmtBuffer.toString();
        }
        createSequence.reset(statement);
        if (createSequence.find()) {
            String seqName = createSequence.group(1);
            long start = createSequence.group(2) == null ? 1L : Long.parseLong(createSequence.group(2));
            long inc = createSequence.group(3) == null ? 1L : Long.parseLong(createSequence.group(3));
            connection.createSequence(seqName, start, inc);
            return null;
        }
        dropSequence.reset(statement);
        if (dropSequence.find()) {
            String seqName = dropSequence.group(1);
            connection.dropSequence(seqName);
            return null;
        }
        return statement;
    }

    public static boolean runSQLScriptQuietly(ExtendedConnection connection, String sqlScriptFile) throws IOException {
        return SQLTools.runSQLScriptQuietly(connection, new FileInputStream(sqlScriptFile));
    }

    public static boolean runSQLScriptQuietly(ExtendedConnection connection, InputStream sqlScriptStream) throws IOException {
        try {
            SQLTools.runSQLScript(connection, sqlScriptStream, true, true);
        }
        catch (SQLException ex) {
            String msg = "A SQLException occurred while trying to run a sql script quietly.";
            logger.log(Level.FINE, msg, ex);
            return false;
        }
        return true;
    }

    public static void runSQLScript(ExtendedConnection connection, String sqlScriptFile) throws SQLException, IOException {
        SQLTools.runSQLScript(connection, new FileInputStream(sqlScriptFile));
    }

    public static void runSQLScript(ExtendedConnection connection, InputStream sqlScriptStream) throws SQLException, IOException {
        SQLTools.runSQLScript(connection, sqlScriptStream, false, true);
    }

    public static void runSQLScript(ExtendedConnection connection, String sqlScriptFile, boolean continueOnException) throws SQLException, IOException {
        SQLTools.runSQLScript(connection, new FileInputStream(sqlScriptFile), continueOnException);
    }

    public static void runSQLScript(ExtendedConnection connection, InputStream sqlScriptStream, boolean continueOnException) throws SQLException, IOException {
        SQLTools.runSQLScript(connection, sqlScriptStream, continueOnException, true);
    }

    public static void runSQLScript(ExtendedConnection connection, String sqlScriptFile, boolean continueOnException, boolean escapeProcessing) throws IOException, SQLException {
        SQLTools.runSQLScript(connection, new FileInputStream(sqlScriptFile), continueOnException, escapeProcessing);
    }

    public static void runSQLScript(ExtendedConnection connection, InputStream sqlScriptStream, boolean continueOnException, boolean escapeProcessing) throws IOException, SQLException {
        if (connection == null) {
            throw new NullArgumentException("The parameter 'connection' must not be null!");
        }
        List<String> statements = SQLTools.parseSQLScriptToStatements(sqlScriptStream, null);
        if (escapeProcessing) {
            SQLTools.processEscapes(connection, statements, continueOnException);
        }
        SQLTools.executeSQLStatements(connection, statements, continueOnException);
    }

    public static interface ProgressListener {
        public void executing(String var1, int var2, int var3);

        public void executed(String var1, int var2, int var3, SQLException var4);

        public void done();
    }
}

