/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess;

import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.model.Column;
import de.aristaflow.adept2.base.dbaccess.model.Constraint;
import de.aristaflow.adept2.base.dbaccess.model.ForeignKey;
import de.aristaflow.adept2.base.dbaccess.model.PrimaryKey;
import de.aristaflow.adept2.base.dbaccess.model.Table;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class StatementBuilder {
    public static String createTable(DatabaseMetaData metaData, Table table) throws SQLException {
        return StatementBuilder.createTable(metaData, table, true);
    }

    public static String createTable(DatabaseMetaData metaData, Table table, boolean includeConstraints) throws SQLException {
        boolean quote = table.getQuoteIdentifiers();
        StringBuilder stmt = new StringBuilder();
        stmt.append("CREATE TABLE ");
        stmt.append(StatementBuilder.formatIdentifier(metaData, table.getName(), quote));
        stmt.append(" (");
        boolean first = true;
        for (Column col : table) {
            if (first) {
                first = false;
            } else {
                stmt.append(", ");
            }
            stmt.append(StatementBuilder.formatIdentifier(metaData, col.getName(), quote));
            stmt.append(" ");
            stmt.append(StatementBuilder.toColumnTypeDef(metaData, col.getType(), col.getTypeName(), col.getSize(), col.getScale()));
            if (col.isNotNull()) {
                stmt.append(" NOT NULL");
            }
            if (col.getDefaultValue() == null) continue;
            stmt.append(" DEFAULT ");
            stmt.append(col.getDefaultValue());
        }
        if (includeConstraints) {
            PrimaryKey pk = table.getPrimaryKey();
            if (pk != null) {
                stmt.append(", ");
                if (pk.getName() != null) {
                    stmt.append("CONSTRAINT ");
                    stmt.append(pk.getName());
                    stmt.append(" ");
                }
                stmt.append("PRIMARY KEY (");
                stmt.append(StatementBuilder.toList(metaData, quote, pk.getColumns()));
                stmt.append(")");
            }
            Constraint[] constraintArray = table.getForeignKeys();
            int n = constraintArray.length;
            int n2 = 0;
            while (n2 < n) {
                ForeignKey fk = constraintArray[n2];
                stmt.append(", ");
                if (fk.getName() != null) {
                    stmt.append("CONSTRAINT ");
                    stmt.append(fk.getName());
                    stmt.append(" ");
                }
                stmt.append("FOREIGN KEY (");
                stmt.append(StatementBuilder.toList(metaData, quote, fk.getColumns()));
                stmt.append(") REFERENCES ");
                stmt.append(StatementBuilder.formatIdentifier(metaData, fk.getPkTable(), quote));
                stmt.append("(");
                stmt.append(StatementBuilder.toList(metaData, quote, fk.getPkColumns()));
                stmt.append(")");
                stmt.append(" ON UPDATE ");
                stmt.append(StatementBuilder.getUpdateOrDeleteRuleKeyword(fk.getUpdateRule()));
                stmt.append(" ON DELETE ");
                stmt.append(StatementBuilder.getUpdateOrDeleteRuleKeyword(fk.getDeleteRule()));
                ++n2;
            }
            constraintArray = table.getUniqueConstraints();
            n = constraintArray.length;
            n2 = 0;
            while (n2 < n) {
                Constraint uc = constraintArray[n2];
                stmt.append(", ");
                if (uc.getName() != null) {
                    stmt.append("CONSTRAINT ");
                    stmt.append(uc.getName());
                    stmt.append(" ");
                }
                stmt.append("UNIQUE (");
                stmt.append(StatementBuilder.toList(metaData, quote, uc.getColumns()));
                stmt.append(")");
                ++n2;
            }
        }
        stmt.append(")");
        return stmt.toString();
    }

    public static String[] addForeignKeys(DatabaseMetaData metaData, Table table) throws SQLException {
        return StatementBuilder.addForeignKeys(metaData, table.getQuoteIdentifiers(), table.getForeignKeys());
    }

    public static String[] addForeignKeys(DatabaseMetaData metaData, boolean quoteIdentifiers, ForeignKey ... fks) throws SQLException {
        ArrayList<String> stmts = new ArrayList<String>();
        StringBuilder stmt = new StringBuilder();
        ForeignKey[] foreignKeyArray = fks;
        int n = fks.length;
        int n2 = 0;
        while (n2 < n) {
            ForeignKey fk = foreignKeyArray[n2];
            stmt.setLength(0);
            stmt.append("ALTER TABLE ");
            stmt.append(StatementBuilder.formatIdentifier(metaData, fk.getTable(), quoteIdentifiers));
            stmt.append(" ADD");
            if (fk.getName() != null) {
                stmt.append(" CONSTRAINT ");
                stmt.append(StatementBuilder.formatIdentifier(metaData, fk.getName(), quoteIdentifiers));
            }
            stmt.append(" FOREIGN KEY (");
            stmt.append(StatementBuilder.toList(metaData, quoteIdentifiers, fk.getColumns()));
            stmt.append(") REFERENCES ");
            stmt.append(StatementBuilder.formatIdentifier(metaData, fk.getPkTable(), quoteIdentifiers));
            stmt.append("(");
            stmt.append(StatementBuilder.toList(metaData, quoteIdentifiers, fk.getPkColumns()));
            stmt.append(")");
            stmt.append(" ON UPDATE ");
            stmt.append(StatementBuilder.getUpdateOrDeleteRuleKeyword(fk.getUpdateRule()));
            stmt.append(" ON DELETE ");
            stmt.append(StatementBuilder.getUpdateOrDeleteRuleKeyword(fk.getDeleteRule()));
            stmts.add(stmt.toString());
            ++n2;
        }
        return StatementBuilder.toStringArray(stmts);
    }

    public static String[] dropForeignKeys(DatabaseMetaData metaData, Table table) throws SQLException {
        return StatementBuilder.dropForeignKeys(metaData, table.getQuoteIdentifiers(), table.getForeignKeys());
    }

    public static String[] dropForeignKeys(DatabaseMetaData metaData, boolean quoteIdentifiers, ForeignKey ... fks) throws SQLException {
        ArrayList<String> stmts = new ArrayList<String>();
        StringBuilder stmt = new StringBuilder();
        ForeignKey[] foreignKeyArray = fks;
        int n = fks.length;
        int n2 = 0;
        while (n2 < n) {
            ForeignKey fk = foreignKeyArray[n2];
            stmt.setLength(0);
            stmt.append("ALTER TABLE ");
            stmt.append(StatementBuilder.formatIdentifier(metaData, fk.getTable(), quoteIdentifiers));
            stmt.append(" DROP CONSTRAINT ");
            stmt.append(StatementBuilder.formatIdentifier(metaData, fk.getName(), quoteIdentifiers));
            stmts.add(stmt.toString());
            ++n2;
        }
        return StatementBuilder.toStringArray(stmts);
    }

    public static String dropPrimaryKey(DatabaseMetaData metaData, Table table) throws SQLException {
        if (table.getPrimaryKey() == null) {
            throw new IllegalArgumentException("table doesn't have a primary key");
        }
        return StatementBuilder.dropPrimaryKey(metaData, table.getQuoteIdentifiers(), table.getPrimaryKey());
    }

    public static String dropPrimaryKey(DatabaseMetaData metaData, boolean quoteIdentifiers, PrimaryKey pk) throws SQLException {
        StringBuilder stmt = new StringBuilder();
        stmt.append("ALTER TABLE ");
        stmt.append(StatementBuilder.formatIdentifier(metaData, pk.getTable(), quoteIdentifiers));
        stmt.append(" DROP CONSTRAINT ");
        stmt.append(StatementBuilder.formatIdentifier(metaData, pk.getName(), quoteIdentifiers));
        return stmt.toString();
    }

    private static String getUpdateOrDeleteRuleKeyword(short updateOrDeleteRule) {
        switch (updateOrDeleteRule) {
            case 3: {
                return "NO ACTION";
            }
            case 1: {
                return "RESTRICT";
            }
            case 0: {
                return "CASCADE";
            }
            case 2: {
                return "SET NULL";
            }
            case 4: {
                return "SET DEFAULT";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String toColumnTypeDef(DatabaseMetaData metaData, int typeCode, String typeName, int size, int scale) throws SQLException {
        ResultSet rs = null;
        try {
            rs = metaData.getTypeInfo();
            while (rs.next()) {
                if (rs.getInt("DATA_TYPE") != typeCode) continue;
                String TYPE_NAME = rs.getString("TYPE_NAME");
                if (typeName != null && !TYPE_NAME.equals(typeName)) continue;
                String CREATE_PARAMS = rs.getString("CREATE_PARAMS");
                rs = JDBCTools.close(rs);
                if (CREATE_PARAMS == null || size < 0) {
                    String string = TYPE_NAME;
                    return string;
                }
                String params = CREATE_PARAMS.contains(",") && scale >= 0 ? "(" + size + ", " + scale + ")" : "(" + size + ")";
                String dataType = TYPE_NAME.contains("()") ? TYPE_NAME.replace("()", params) : String.valueOf(TYPE_NAME) + params;
                String string = dataType;
                return string;
            }
            throw new IllegalArgumentException();
        }
        finally {
            JDBCTools.closeQuietly(rs);
        }
    }

    public static String formatIdentifier(DatabaseMetaData metaData, String identifier, boolean quote) throws SQLException {
        if (quote) {
            String quoteString = metaData.getIdentifierQuoteString();
            return String.valueOf(quoteString) + identifier + quoteString;
        }
        return identifier;
    }

    public static String toList(DatabaseMetaData metaData, boolean quoteIdentifiers, String ... columnNames) throws SQLException {
        if (metaData == null) {
            throw new IllegalArgumentException("The parameter 'metaData' must not be null!");
        }
        StringBuilder list = new StringBuilder();
        boolean first = true;
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String colName = stringArray[n2];
            if (first) {
                first = false;
            } else {
                list.append(", ");
            }
            list.append(StatementBuilder.formatIdentifier(metaData, colName, quoteIdentifiers));
            ++n2;
        }
        return list.toString();
    }

    public static String toList(DatabaseMetaData metaData, boolean quoteIdentifiers, Column ... columns) throws SQLException {
        String[] columnNames = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            columnNames[i] = columns[i].getName();
            ++i;
        }
        return StatementBuilder.toList(metaData, quoteIdentifiers, columnNames);
    }

    private static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    private StatementBuilder() {
    }
}

