/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.DBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.DefaultExtendedConnection;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="DataSourceName", type=Property.Type.STRING, isRequired=false, description="The logical name of a data source for JNDI look-up.")})
public class AppServerJDBCDataSource
extends AbstractADEPT2Service
implements JDBCDataSource {
    static final String CONF_DATASOURCE_NAME = "DataSourceName";
    private String dataSourceName;
    private DataSource dataSource;
    private DBAccessProvider provider;
    private static final Map<String, String> ACCESS_PROVIDERS = new HashMap<String, String>();

    static {
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.DB2AccessProvider", "DB2");
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.SQLServerAccessProvider", "SQL Server");
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.OracleAccessProvider", "Oracle");
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.DerbyAccessProvider", "Derby");
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.PostgreSQLAccessProvider", "PostgreSQL");
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.HsqldbAccessProvider", "HSQL");
        ACCESS_PROVIDERS.put("de.aristaflow.adept2.base.dbaccess.providers.MySQLAccessProvider", "MySQL");
    }

    public AppServerJDBCDataSource(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.dataSourceName = configuration.getString(CONF_DATASOURCE_NAME);
    }

    @Override
    public void init(URI[] serviceURIs) throws AbortServiceException {
        super.init(serviceURIs);
        if (this.dataSourceName.length() > 0) {
            try {
                InitialContext ctx = new InitialContext();
                Object object = ctx.lookup(this.dataSourceName);
                if (!(object instanceof DataSource)) {
                    String msg = "The object referenced by the logical name '%s' is no javax.sql.DataSource: %s";
                    msg = String.format(msg, this.dataSourceName, object == null ? null : object.getClass().getName());
                    throw new ConfigurationException(msg);
                }
                this.setDataSource((DataSource)object);
            }
            catch (NamingException ex) {
                String msg = "Failed to retrieve the DataSource by its logical name '%s'.";
                msg = String.format(msg, this.dataSourceName);
                throw new ConfigurationException(msg, ex);
            }
            catch (SQLException ex) {
                String msg = "Failed to initialise the DataSource.";
                msg = String.format(msg, new Object[0]);
                throw new ConfigurationException(msg, ex);
            }
        }
    }

    private DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) throws SQLException {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            Object conUrl = null;
            String productName = null;
            try {
                productName = con.getMetaData().getDatabaseProductName();
                this.provider = this.chooseProviderBasedOnProductName(productName);
            }
            catch (Exception ex) {
                String msg = "Could not load appropriate access provider for connection URL '%s' or database product name '%s'.";
                msg = String.format(msg, conUrl, productName);
                SQLException sqlEx = new SQLException(msg);
                sqlEx.initCause(ex);
                throw sqlEx;
            }
            if (this.provider == null) {
                String msg = "Could not find appropriate access provider for connection URL '%s' or database product name '%s'.";
                msg = String.format(msg, conUrl, productName);
                throw new SQLException(msg);
            }
            this.dataSource = dataSource;
        }
        finally {
            JDBCTools.closeQuietly(con);
        }
    }

    @Override
    public ExtendedConnection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new IllegalStateException("No data source set.");
        }
        if (this.provider == null) {
            throw new IllegalStateException("No appropriate access provider found for data source.");
        }
        Connection con = this.getDataSource().getConnection();
        return new DefaultExtendedConnection(con, this.provider);
    }

    private DBAccessProvider chooseProviderBasedOnProductName(String productName) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (Map.Entry<String, String> entry : ACCESS_PROVIDERS.entrySet()) {
            if (!productName.contains(entry.getValue())) continue;
            return this.loadAccessProvider(entry.getKey());
        }
        return null;
    }

    protected DBAccessProvider loadAccessProvider(String accessProviderClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DBAccessProvider dbAccessProvider = (DBAccessProvider)Class.forName(accessProviderClass).newInstance();
        return dbAccessProvider;
    }
}

