/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.DBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.DefaultExtendedConnection;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="Driver", isRequired=true), @Property(name="DBAccessProvider", isRequired=true), @Property(name="ConnectionURL", isRequired=true), @Property(name="UserName"), @Property(name="Password"), @Property(name="CheckAvailability", description="Whether the availability of the database should bechecked on service start.", type=Property.Type.BOOLEAN, defaultValue="true")})
public class BasicJDBCDataSource
extends AbstractADEPT2Service
implements JDBCDataSource {
    protected String driver;
    protected String dbAccessProviderClass;
    protected DBAccessProvider dbAccessProvider;
    protected String connectionURL;
    protected String userName;
    protected String password;
    protected boolean checkAvailability;

    public BasicJDBCDataSource(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.driver = configuration.getString("Driver");
        this.dbAccessProviderClass = configuration.getString("DBAccessProvider");
        this.connectionURL = configuration.getString("ConnectionURL");
        this.userName = configuration.getString("UserName");
        try {
            this.password = ConfigurationTools.parsePassword(configuration, "Password");
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.password = configuration.getString("Password");
        }
        this.checkAvailability = configuration.getBoolean("CheckAvailability");
    }

    @Override
    public ExtendedConnection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.connectionURL, this.userName, this.password);
        return new DefaultExtendedConnection(connection, this.dbAccessProvider);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (ClassNotFoundException ex) {
            String msg = String.format("Unable to find specified JDBC-driver '%s'. Please check the path and the configuration.", this.driver);
            this.logger.severe(msg);
            throw new ConfigurationException(msg, ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "Unable to access the constructor of the specified JDBC-driver '%s'. Please check the path and the configuration.";
            msg = String.format(msg, this.driver);
            this.logger.severe(msg);
            throw new ConfigurationException(msg, ex);
        }
        catch (InstantiationException ex) {
            String msg = "Unable to instantiate specified JDBC-driver '%s'. Please check the path and the configuration.";
            msg = String.format(msg, this.driver);
            this.logger.severe(msg);
            throw new ConfigurationException(msg, ex);
        }
        try {
            this.dbAccessProvider = (DBAccessProvider)Class.forName(this.dbAccessProviderClass).newInstance();
        }
        catch (Exception ex) {
            String msg = "The configured DBAccessProvider implementation '%s' could not be loaded!";
            msg = String.format(msg, this.dbAccessProviderClass);
            throw new ConfigurationException(msg, ex);
        }
        String[] urlTokens = this.connectionURL.split(":", 3);
        if (urlTokens.length < 3 || !urlTokens[0].equalsIgnoreCase("jdbc")) {
            String msg = "'%s' is not a JDBC connection URL of the form 'jdbc:<subprotocol>:<subname>'!";
            msg = String.format(msg, this.connectionURL);
            throw new ConfigurationException(msg);
        }
        String subProtocol = urlTokens[1];
        String subName = urlTokens[2];
        if (!this.dbAccessProvider.isSupportedConnectionURL(subProtocol, subName)) {
            String msg = "The connection URL '%s' is not supported by the DBAccessProvider implementation '%s'!";
            msg = String.format(msg, this.connectionURL, this.dbAccessProviderClass);
            throw new ConfigurationException(msg);
        }
    }

    @Override
    public void start() throws AbortServiceException {
        if (this.checkAvailability) {
            ExtendedConnection con = null;
            try {
                try {
                    con = this.getConnection();
                    con = JDBCTools.close(con);
                }
                catch (SQLException ex) {
                    String msg = "No connection could be established to the database: %s";
                    msg = String.format(msg, this.connectionURL);
                    throw new ConfigurationException(msg, ex);
                }
            }
            finally {
                JDBCTools.closeQuietly(con);
            }
        }
        super.start();
    }
}

