/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.PoolingJDBCDataSource;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.objectpool.generic.CallerTrace;
import de.aristaflow.adept2.util.objectpool.generic.ObjectPoolListener;
import de.aristaflow.adept2.util.objectpool.generic.ReclaimAction;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionPoolListener
implements ObjectPoolListener<ExtendedConnection> {
    private Logger logger = LoggerTools.getLogger(PoolingJDBCDataSource.class);

    @Override
    public void objectCreated(ExtendedConnection object, int objectCount) {
        String msg = "A connection has been created by the pool (new total: %d).";
        msg = String.format(msg, objectCount);
        this.logger.finer(msg);
    }

    @Override
    public void objectCheckedOut(ExtendedConnection con, CallerTrace checkOutTrace) {
        Throwable dummy = new Throwable(String.format("stacktrace of where the connection was checked out (timestamp %s)", new Timestamp(checkOutTrace.getTimestamp()).toString()));
        dummy.setStackTrace(checkOutTrace.getStackTrace());
        String msg = "Connection checked out.";
        this.logger.log(Level.FINER, msg, dummy);
    }

    @Override
    public void objectCheckedIn(ExtendedConnection con, CallerTrace checkOutTrace, CallerTrace checkInTrace) {
        Throwable dummy = new Throwable(String.format("stacktrace of where the connection was checked in (timestamp %s)", new Timestamp(checkInTrace.getTimestamp()).toString()));
        dummy.setStackTrace(checkInTrace.getStackTrace());
        String msg = "Connection checked in.";
        this.logger.log(Level.FINER, msg, dummy);
    }

    @Override
    public void objectReclaimed(ExtendedConnection con, ReclaimAction action, CallerTrace checkOutTrace) {
        Throwable dummy = new Throwable(String.format("stacktrace of where the connection was originally checked out (timestamp %s)", new Timestamp(checkOutTrace.getTimestamp()).toString()));
        dummy.setStackTrace(checkOutTrace.getStackTrace());
        String msg = "A Connection to the database has been reclaimed by the pool.";
        this.logger.log(Level.WARNING, msg, dummy);
    }

    @Override
    public void objectDestroyed(ExtendedConnection object, int objectCount, Exception ex) {
        String msg = "A connection has been destroyed and removed from the pool (new total: %d).";
        if (ex != null) {
            msg = String.valueOf(msg) + " An exception was encountered in the process.";
        }
        msg = String.format(msg, objectCount);
        this.logger.log(Level.FINER, msg, ex);
    }
}

