/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.defaultimplementation.CallableStatementGuard;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.DatabaseMetaDataGuard;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.PreparedStatementGuard;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.StatementGuard;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.objectpool.AbstractObjectWrapper;
import de.aristaflow.adept2.util.objectpool.ObjectPool;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

class ConnectionWrapper<T extends Connection>
extends AbstractObjectWrapper<T, SQLException>
implements Connection {
    Set<StatementGuard> statements = new HashSet<StatementGuard>();

    ConnectionWrapper(ObjectPool<T, SQLException> objectPool, T connection) {
        super(objectPool, connection);
    }

    void registerStatement(StatementGuard statement) {
        this.statements.add(statement);
    }

    void deregisterStatement(StatementGuard statement) {
        this.statements.remove(statement);
    }

    synchronized void closeOpenStatements() throws SQLException {
        if (this.statements.size() > 0) {
            SQLException firstException = null;
            for (StatementGuard protectedStatement : this.statements) {
                Statement statement = protectedStatement.getProtectedStatement();
                try {
                    statement.close();
                }
                catch (SQLException ex) {
                    if (firstException == null) {
                        firstException = ex;
                        continue;
                    }
                    firstException.setNextException(ex);
                }
                catch (RuntimeException ex) {
                    LoggerTools.logUnhandledException(ex);
                }
            }
            this.statements.clear();
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean isClosed = this._getObject().isClosed();
        if (isClosed && this._isValid()) {
            try {
                this._checkIn();
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new AssertionError((Object)ex);
            }
        }
        return isClosed;
    }

    @Override
    public void close() throws SQLException {
        SQLException firstException;
        block26: {
            if (!this._isValid()) {
                return;
            }
            firstException = null;
            try {
                try {
                    if (!this._getObject().isClosed()) {
                        this.closeOpenStatements();
                    }
                }
                catch (SQLException ex) {
                    firstException = ex;
                    try {
                        this._checkIn();
                        break block26;
                    }
                    catch (SQLException ex2) {
                        if (firstException == null) {
                            firstException = ex2;
                        } else {
                            firstException.setNextException(ex2);
                        }
                        break block26;
                    }
                    catch (Exception ex3) {
                        if (ex3 instanceof RuntimeException) {
                            throw (RuntimeException)ex3;
                        }
                        throw new AssertionError((Object)ex3);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this._checkIn();
                }
                catch (SQLException ex) {
                    if (firstException == null) {
                        firstException = ex;
                    } else {
                        firstException.setNextException(ex);
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new AssertionError((Object)ex);
                }
                throw throwable;
            }
            try {
                this._checkIn();
            }
            catch (SQLException ex) {
                if (firstException == null) {
                    firstException = ex;
                } else {
                    firstException.setNextException(ex);
                }
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new AssertionError((Object)ex);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    protected T _getObject() {
        try {
            return (T)((Connection)super._getObject());
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("This connection is no longer valid! It was either checked back into the connection pool or reclaimed by it.");
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    protected boolean _isValid() {
        return super._isValid();
    }

    @Override
    protected void _invalidate() {
        if (!this._isValid()) {
            return;
        }
        super._invalidate();
        try {
            this.closeOpenStatements();
        }
        catch (SQLException ex) {
            String msg = "SQLException encountered while closing open statements.";
            LoggerTools.getLogger(this).log(Level.FINE, msg, ex);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new StatementGuard(this, this._getObject().createStatement());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new PreparedStatementGuard(this, this._getObject().prepareStatement(sql));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new CallableStatementGuard(this, this._getObject().prepareCall(sql));
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this._getObject().nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this._getObject().setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._getObject().getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this._getObject().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this._getObject().rollback();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaDataGuard(this, this._getObject().getMetaData());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this._getObject().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._getObject().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this._getObject().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._getObject().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this._getObject().setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._getObject().getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._getObject().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._getObject().clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatementGuard(this, this._getObject().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new PreparedStatementGuard(this, this._getObject().prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new CallableStatementGuard(this, this._getObject().prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this._getObject().getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this._getObject().setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this._getObject().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._getObject().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._getObject().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this._getObject().setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this._getObject().rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._getObject().releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatementGuard(this, this._getObject().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new PreparedStatementGuard(this, this._getObject().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new CallableStatementGuard(this, this._getObject().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new PreparedStatementGuard(this, this._getObject().prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new PreparedStatementGuard(this, this._getObject().prepareStatement(sql, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new PreparedStatementGuard(this, this._getObject().prepareStatement(sql, columnNames));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._getObject().isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._getObject().unwrap(iface);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this._getObject().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this._getObject().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this._getObject().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this._getObject().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this._getObject().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this._getObject().setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._getObject().setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this._getObject().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this._getObject().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this._getObject().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this._getObject().createStruct(typeName, attributes);
    }
}

