/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.DBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class DefaultExtendedConnection
implements ExtendedConnection {
    private Connection connection;
    private DBAccessProvider dbAccessProvider;
    private Statement privateStatement;

    public DefaultExtendedConnection(Connection connection, DBAccessProvider dbAccessProvider) {
        if (connection == null) {
            throw new NullArgumentException("The parameter 'connection' must not be null!");
        }
        if (dbAccessProvider == null) {
            throw new NullArgumentException("The parameter 'dbAccessProvider' must not be null!");
        }
        this.connection = connection;
        this.dbAccessProvider = dbAccessProvider;
    }

    private Connection getConnection() {
        return this.connection;
    }

    private DBAccessProvider getDBAccessProvider() {
        return this.dbAccessProvider;
    }

    private Statement getPrivateStatement() throws SQLException {
        if (this.privateStatement == null) {
            this.privateStatement = this.getConnection().createStatement();
        }
        return this.privateStatement;
    }

    private void closePrivateStatement() throws SQLException {
        if (this.privateStatement != null) {
            this.privateStatement.close();
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return this.dbAccessProvider.getCurrentSchema(this.getConnection());
    }

    @Override
    public String getEXCEPTKeyword() {
        return this.getDBAccessProvider().getEXCEPTKeyword();
    }

    @Override
    public String getDropForeignKeyConstraintKeyword() {
        return this.getDBAccessProvider().getDropForeignKeyConstraintKeyword();
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode) {
        return this.getDBAccessProvider().getCorrespondingDBType(jdbcTypeCode);
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size) {
        return this.getDBAccessProvider().getCorrespondingDBType(jdbcTypeCode, size);
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        return this.getDBAccessProvider().getCorrespondingDBType(jdbcTypeCode, size, scale);
    }

    @Override
    public String formatValue(Object value, int typeCode) {
        return this.getDBAccessProvider().formatValue(value, typeCode);
    }

    @Override
    public boolean tableExists(String tableName) throws SQLException {
        boolean bl;
        ArgChecks.checkForNull(tableName, "tableName");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.getMetaData();
            tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
            rs = metaData.getTables(this.getCatalog(), this.getSchema(), tableName, new String[]{"TABLE"});
            boolean exists = rs.next();
            rs = JDBCTools.close(rs);
            bl = exists;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return bl;
    }

    @Override
    public boolean columnExists(String columnName, String tableName) throws SQLException {
        boolean bl;
        ArgChecks.checkForNull(columnName, "columnName");
        ArgChecks.checkForNull(tableName, "tableName");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
            columnName = MetaDataTools.adjustIdentifierCase(metaData, columnName);
            rs = metaData.getColumns(this.getCatalog(), this.getSchema(), tableName, columnName);
            boolean exists = rs.next();
            rs = JDBCTools.close(rs);
            bl = exists;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return bl;
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws SQLException {
        if (columnName == null) {
            throw new NullArgumentException("The parameter 'columnName' must not be null!");
        }
        if (tableName == null) {
            throw new NullArgumentException("The parameter 'tableName' must not be null!");
        }
        this.getDBAccessProvider().dropColumn(this, tableName, columnName);
    }

    @Override
    public String[] getColumnNames(String origTableName) throws SQLException {
        String[] stringArray;
        String tableName = origTableName;
        if (tableName == null) {
            throw new NullArgumentException("The parameter 'tableName' must not be null!");
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
            rs = metaData.getColumns(this.getCatalog(), this.getSchema(), tableName, null);
            ArrayList<String> columnNames = new ArrayList<String>();
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
            rs = JDBCTools.close(rs);
            stringArray = columnNames.toArray(new String[columnNames.size()]);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return stringArray;
    }

    @Override
    public int getColumnType(String origColumnName, String origTableName) throws SQLException {
        int n;
        String columnName = origColumnName;
        String tableName = origTableName;
        if (columnName == null) {
            throw new NullArgumentException("The parameter 'columnName' must not be null!");
        }
        if (tableName == null) {
            throw new NullArgumentException("The parameter 'tableName' must not be null!");
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
            columnName = MetaDataTools.adjustIdentifierCase(metaData, columnName);
            rs = metaData.getColumns(this.getCatalog(), this.getSchema(), tableName, columnName);
            rs.next();
            int type = rs.getInt("DATA_TYPE");
            rs = JDBCTools.close(rs);
            n = type;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return n;
    }

    public boolean isTableMissing(SQLException ex) {
        return this.dbAccessProvider.isTableMissing(ex);
    }

    public boolean isUniqueViolation(SQLException ex) {
        return this.dbAccessProvider.isUniqueViolation(ex);
    }

    public boolean isForeignKeyViolation(SQLException ex) {
        return this.dbAccessProvider.isForeignKeyViolation(ex);
    }

    @Override
    public void createSequence(String sequenceName, long start, long increment) throws SQLException {
        this.getDBAccessProvider().createSequence(this, sequenceName, start, increment);
    }

    @Override
    public void dropSequence(String sequenceName) throws SQLException {
        this.getDBAccessProvider().dropSequence(this, sequenceName);
    }

    @Override
    public boolean sequenceExists(String sequenceName) throws SQLException {
        return this.getDBAccessProvider().sequenceExists(this, sequenceName);
    }

    @Override
    public long nextID(String sequenceName) throws SQLException {
        return this.getDBAccessProvider().nextID(this, sequenceName);
    }

    @Override
    public int getSchemaVersion(String serviceName) throws SQLException {
        int version;
        if (this.tableExists("SchemaVersions")) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                String sql = "SELECT version FROM SchemaVersions WHERE serviceName = %s";
                sql = String.format(sql, this.formatValue(serviceName, 12));
                stmt = this.createStatement();
                rs = stmt.executeQuery(sql);
                version = !rs.next() ? -1 : rs.getInt("version");
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt, rs);
                throw throwable;
            }
            JDBCTools.closeQuietly(stmt, rs);
        } else {
            version = -1;
        }
        return version;
    }

    @Override
    public void setSchemaVersion(String serviceName, int version) throws SQLException {
        Statement stmt = null;
        try {
            try {
                block9: {
                    String sql;
                    stmt = this.createStatement();
                    if (!this.tableExists("SchemaVersions")) {
                        sql = "CREATE TABLE SchemaVersions (serviceName %s NOT NULL, version %s NOT NULL, PRIMARY KEY (serviceName))";
                        sql = String.format(sql, this.getCorrespondingDBType(12, 50), this.getCorrespondingDBType(4));
                        stmt.executeUpdate(sql);
                    }
                    sql = "UPDATE SchemaVersions SET version = %d WHERE serviceName = %s";
                    int rowCount = stmt.executeUpdate(sql = String.format(sql, version, this.formatValue(serviceName, 12)));
                    if (rowCount == 0) {
                        sql = "INSERT INTO SchemaVersions (serviceName, version) VALUES (%s, %d)";
                        sql = String.format(sql, this.formatValue(serviceName, 12), version);
                        try {
                            stmt.executeUpdate(sql);
                        }
                        catch (SQLException ex3) {
                            if (this.isUniqueViolation(ex3)) break block9;
                            throw ex3;
                        }
                    }
                }
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException sQLException) {
                JDBCTools.closeQuietly(stmt);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropSchemaVersion(String serviceName) throws SQLException {
        Statement stmt = null;
        try {
            String sql = "DELETE FROM SchemaVersions WHERE serviceName = %s";
            sql = String.format(sql, this.formatValue(serviceName, 12));
            stmt = this.createStatement();
            stmt.executeUpdate(sql);
            stmt = JDBCTools.close(stmt);
        }
        catch (SQLException ex) {
            if (this.isTableMissing(ex)) {
                JDBCTools.closeQuietly(stmt);
                return;
            }
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(stmt);
    }

    @Override
    public String createRecursionTable(String[] selectAttributes, String tableName, String startCondition, ParentToChildConnection[] parentToChildConnections, int maxDepth) throws SQLException {
        return this.getDBAccessProvider().createRecursionTable(this, selectAttributes, tableName, startCondition, parentToChildConnections, maxDepth);
    }

    @Override
    public void dropAllRecursionTables() throws SQLException {
        this.getDBAccessProvider().dropAllRecursionTables(this);
    }

    @Override
    public void dropRecursionTable(String tableName) throws SQLException {
        this.getDBAccessProvider().dropRecursionTable(this, tableName);
    }

    @Override
    public void close() throws SQLException {
        try {
            this.closePrivateStatement();
        }
        finally {
            this.getConnection().close();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getConnection().isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getConnection().nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.getConnection().prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.getConnection().prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.getConnection().prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getConnection().prepareStatement(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getConnection().rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getConnection().setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getConnection().setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getConnection().setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.getConnection().setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getConnection().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getConnection().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.getConnection().setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.getConnection().setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getConnection().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getConnection().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getConnection().createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getConnection().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getConnection().isWrapperFor(iface);
    }
}

