/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.DBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.DefaultExtendedConnection;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.objectpool.ObjectLifeCycle;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class ExtendedConnectionLifeCycle
implements ObjectLifeCycle<ExtendedConnection, SQLException> {
    private Logger logger = LoggerTools.getLogger(this);
    private String connectionUrl;
    private Properties props;
    private DBAccessProvider dbAccessProvider;
    private Integer defaultTransactionIsolation;
    private Boolean defaultReadOnly;
    private String defaultCatalog;

    public ExtendedConnectionLifeCycle(String connectionUrl, String username, String password, DBAccessProvider dbAccessProvider) {
        if (connectionUrl == null) {
            throw new IllegalArgumentException("The parameter 'connectionUrl' must not be null!");
        }
        if (username == null) {
            throw new IllegalArgumentException("The parameter 'username' must not be null!");
        }
        if (password == null) {
            throw new IllegalArgumentException("The parameter 'password' must not be null!");
        }
        if (dbAccessProvider == null) {
            throw new IllegalArgumentException("The parameter 'dbAccessProvider' must not be null!");
        }
        this.connectionUrl = connectionUrl;
        this.dbAccessProvider = dbAccessProvider;
        this.props = new Properties();
        this.props.setProperty("user", username);
        this.props.setProperty("password", password);
        dbAccessProvider.adaptProperties(this.props);
    }

    @Override
    public ExtendedConnection create() throws SQLException {
        String msg = "Opening SQL connection to %s.";
        this.logger.fine(String.format(msg, this.connectionUrl));
        Connection con = DriverManager.getConnection(this.connectionUrl, this.props);
        if (this.defaultTransactionIsolation == null) {
            this.defaultTransactionIsolation = con.getTransactionIsolation();
        }
        if (this.defaultReadOnly == null) {
            this.defaultReadOnly = con.isReadOnly();
        }
        if (this.defaultCatalog == null) {
            this.defaultCatalog = con.getCatalog();
        }
        return new DefaultExtendedConnection(con, this.dbAccessProvider);
    }

    @Override
    public void activate(ExtendedConnection connection) throws SQLException {
        if (connection.getTransactionIsolation() != this.defaultTransactionIsolation.intValue()) {
            connection.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (connection.isReadOnly() != this.defaultReadOnly.booleanValue()) {
            connection.setReadOnly(this.defaultReadOnly);
        }
        if (connection.getCatalog() != null && !connection.getCatalog().equals(this.defaultCatalog)) {
            connection.setCatalog(this.defaultCatalog);
        }
        connection.clearWarnings();
    }

    @Override
    public void passivate(ExtendedConnection connection) throws SQLException {
        if (!connection.getAutoCommit()) {
            connection.rollback();
            connection.setAutoCommit(true);
        }
    }

    @Override
    public void destroy(ExtendedConnection connection) throws SQLException {
        connection.close();
    }

    @Override
    public boolean isValid(ExtendedConnection connection) {
        ResultSet rs;
        block5: {
            rs = null;
            if (!connection.isClosed()) break block5;
            JDBCTools.closeQuietly(rs);
            return false;
        }
        try {
            try {
                rs = connection.getMetaData().getCatalogs();
                rs.next();
                rs.close();
            }
            catch (SQLException sQLException) {
                JDBCTools.closeQuietly(rs);
                return false;
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return true;
    }

    @Override
    public long getLastActiveTime(ExtendedConnection object) {
        return -1L;
    }
}

