/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.BasicJDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.ConnectionPoolListener;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.ExtendedConnectionLifeCycle;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.ExtendedConnectionWrapperLifeCycle;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.util.objectpool.generic.GenericObjectPool;
import de.aristaflow.adept2.util.objectpool.generic.PoolConfiguration;
import java.sql.SQLException;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="MaxConnections", isRequired=true)})
public class PoolingJDBCDataSource
extends BasicJDBCDataSource {
    protected int maxConnections;
    private GenericObjectPool<ExtendedConnection, SQLException> objectPool;

    public PoolingJDBCDataSource(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.maxConnections = configuration.getInt("MaxConnections");
    }

    @Override
    public ExtendedConnection getConnection() throws SQLException {
        return this.objectPool.checkOut();
    }

    @Override
    public void start() throws AbortServiceException {
        ExtendedConnectionLifeCycle objectLifeCycle = new ExtendedConnectionLifeCycle(this.connectionURL, this.userName, this.password, this.dbAccessProvider);
        ExtendedConnectionWrapperLifeCycle wrapperLifeCycle = new ExtendedConnectionWrapperLifeCycle();
        PoolConfiguration configuration = new PoolConfiguration();
        configuration.setMaxObjectCount(this.maxConnections);
        try {
            this.objectPool = new GenericObjectPool<ExtendedConnection, SQLException>(objectLifeCycle, wrapperLifeCycle, configuration);
            this.objectPool.setObjectPoolListener(new ConnectionPoolListener());
            super.start();
        }
        catch (RuntimeException re) {
            this.shutdown();
            throw re;
        }
        catch (AbortServiceException ase) {
            this.shutdown();
            throw ase;
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.objectPool != null) {
            this.objectPool.shutdown();
            while (!this.objectPool.isTerminated()) {
                try {
                    this.objectPool.awaitTermination();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        if (this.objectPool != null) {
            this.objectPool.forceShutdown(10000L);
            while (!this.objectPool.isTerminated()) {
                try {
                    this.objectPool.awaitTermination();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

