/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.defaultimplementation;

import de.aristaflow.adept2.base.dbaccess.defaultimplementation.ConnectionWrapper;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.ResultSetGuard;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

class StatementGuard
implements Statement {
    private final ConnectionWrapper<?> connectionWrapper;
    private final Statement protectedStatement;

    StatementGuard(ConnectionWrapper<?> connectionWrapper, Statement protectedStatement) {
        this.connectionWrapper = connectionWrapper;
        this.protectedStatement = protectedStatement;
        this.getConnectionWrapper().registerStatement(this);
    }

    ConnectionWrapper<?> getConnectionWrapper() {
        return this.connectionWrapper;
    }

    Statement getProtectedStatement() {
        return this.protectedStatement;
    }

    @Override
    public void close() throws SQLException {
        if (!this.getConnectionWrapper()._isValid()) {
            return;
        }
        this.getConnectionWrapper().deregisterStatement(this);
        this.getProtectedStatement().close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionWrapper();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return new ResultSetGuard(this, this.getProtectedStatement().executeQuery(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.getProtectedStatement().executeUpdate(sql);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getProtectedStatement().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.getProtectedStatement().setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getProtectedStatement().getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.getProtectedStatement().setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.getProtectedStatement().setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getProtectedStatement().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.getProtectedStatement().setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.getProtectedStatement().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getProtectedStatement().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getProtectedStatement().clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.getProtectedStatement().setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.getProtectedStatement().execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new ResultSetGuard(this, this.getProtectedStatement().getResultSet());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.getProtectedStatement().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getProtectedStatement().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.getProtectedStatement().setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getProtectedStatement().getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.getProtectedStatement().setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getProtectedStatement().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.getProtectedStatement().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.getProtectedStatement().getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.getProtectedStatement().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getProtectedStatement().clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.getProtectedStatement().executeBatch();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getProtectedStatement().getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new ResultSetGuard(this, this.getProtectedStatement().getGeneratedKeys());
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getProtectedStatement().executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.getProtectedStatement().executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.getProtectedStatement().executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getProtectedStatement().execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.getProtectedStatement().execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.getProtectedStatement().execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getProtectedStatement().getResultSetHoldability();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getProtectedStatement().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getProtectedStatement().isWrapperFor(iface);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getProtectedStatement().isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.getProtectedStatement().setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getProtectedStatement().isPoolable();
    }
}

