/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.model;

import java.util.Arrays;
import java.util.List;

public abstract class Constraint
implements Cloneable {
    private String name;
    private String table;
    private String[] columnNames;

    protected Constraint(String name, String tableName, String[] columnNames) {
        this.setName(name);
        this.setTable(tableName);
        this.setColumns(columnNames);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.trim().equals("")) {
            throw new IllegalArgumentException("constraint name must not be blank");
        }
        this.name = name;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String tableName) {
        if (tableName == null || tableName.trim().equals("")) {
            throw new IllegalArgumentException("table name must not be null or blank");
        }
        this.table = tableName;
    }

    public String[] getColumns() {
        String[] ret = null;
        if (this.columnNames != null) {
            ret = (String[])this.columnNames.clone();
        }
        return ret;
    }

    public void setColumns(String[] columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            throw new IllegalArgumentException("columns array must not be null or 0-sized");
        }
        this.columnNames = (String[])columnNames.clone();
    }

    public boolean matchesColumnSet(String[] columnNames) {
        if (columnNames.length != this.columnNames.length) {
            return false;
        }
        List<String> columnsList = Arrays.asList(this.columnNames);
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tempCol = stringArray[n2];
            if (!columnsList.contains(tempCol)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Constraint clone() {
        try {
            Constraint clone = (Constraint)super.clone();
            clone.columnNames = (String[])this.columnNames.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

