/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.model;

import de.aristaflow.adept2.base.dbaccess.model.Constraint;

public class ForeignKey
extends Constraint {
    private String pkTable;
    private String[] pkColumns;
    private short updateRule = (short)3;
    private short deleteRule = (short)3;

    public ForeignKey(String fkName, String fkTable, String[] fkColumns, String pkTableName, String[] pkColumnNames) {
        super(fkName, fkTable, fkColumns);
        this.setPkTable(pkTableName);
        this.setPkColumns(pkColumnNames);
    }

    public String getPkTable() {
        return this.pkTable;
    }

    public void setPkTable(String pkTableName) {
        if (pkTableName == null || pkTableName.trim().equals("")) {
            throw new IllegalArgumentException("pk table name must not be null or blank");
        }
        this.pkTable = pkTableName;
    }

    public String[] getPkColumns() {
        return (String[])this.pkColumns.clone();
    }

    public void setPkColumns(String[] pkColumnNames) {
        if (pkColumnNames == null || pkColumnNames.length == 0) {
            throw new IllegalArgumentException("pk columns array must not be null or 0-sized");
        }
        this.pkColumns = (String[])pkColumnNames.clone();
    }

    public short getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(short updateRule) {
        this.updateRule = updateRule;
    }

    public short getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(short deleteRule) {
        this.deleteRule = deleteRule;
    }

    @Override
    public ForeignKey clone() {
        ForeignKey clone = (ForeignKey)super.clone();
        clone.pkColumns = (String[])this.pkColumns.clone();
        return clone;
    }
}

