/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.model;

import de.aristaflow.adept2.base.dbaccess.model.Column;
import de.aristaflow.adept2.base.dbaccess.model.Constraint;
import de.aristaflow.adept2.base.dbaccess.model.ForeignKey;
import de.aristaflow.adept2.base.dbaccess.model.PrimaryKey;
import de.aristaflow.adept2.base.dbaccess.model.UniqueConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Table
implements Iterable<Column>,
Cloneable {
    private String name;
    private Map<String, Column> columns = new HashMap<String, Column>();
    private List<Column> columnsOrder = new ArrayList<Column>();
    private PrimaryKey primaryKey;
    private List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
    private List<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>();
    private boolean quoteIdentifiers = false;

    public Table(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("table name must not be null or blank");
        }
        this.name = name;
        if (this.getPrimaryKey() != null) {
            this.getPrimaryKey().setTable(name);
        }
        Constraint[] constraintArray = this.getForeignKeys();
        int n = constraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForeignKey fk = constraintArray[n2];
            fk.setTable(name);
            ++n2;
        }
        constraintArray = this.getUniqueConstraints();
        n = constraintArray.length;
        n2 = 0;
        while (n2 < n) {
            Constraint uc = constraintArray[n2];
            uc.setTable(name);
            ++n2;
        }
    }

    public Column addColumn(String name) {
        return this.addColumn(name, this.getColumnCount());
    }

    public Column addColumn(String name, int index) {
        if (this.columns.containsKey(name)) {
            throw new IllegalArgumentException("already exists");
        }
        TableColumn col = new TableColumn(name);
        this.columnsOrder.add(index, col);
        this.columns.put(name, col);
        return col;
    }

    public Column getColumn(String name) {
        return this.columns.get(name);
    }

    public Column getColumn(int index) {
        return this.columnsOrder.get(index);
    }

    public Column[] getColumns(String ... names) {
        Column[] columns;
        if (names.length == 0) {
            columns = this.columnsOrder.toArray(new Column[this.getColumnCount()]);
        } else {
            columns = new Column[names.length];
            int i = 0;
            while (i < names.length) {
                Column col = this.getColumn(names[i]);
                if (col == null) {
                    throw new IllegalArgumentException();
                }
                columns[i] = col;
                ++i;
            }
        }
        return columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void moveColumn(String name, int toIndex) {
        if (toIndex < 0 || toIndex > this.getColumnCount()) {
            throw new IndexOutOfBoundsException(String.format("index = %d, size = %d", toIndex, this.getColumnCount()));
        }
        Column col = this.getColumn(name);
        if (col == null) {
            throw new IllegalArgumentException("column doesn't exist: " + name);
        }
        this.columnsOrder.remove(col);
        this.columnsOrder.add(toIndex, col);
    }

    public Column removeColumn(int index) {
        Column col = this.columnsOrder.remove(index);
        this.columns.remove(col.getName());
        return col;
    }

    public void removeColumn(String name) {
        Column col = this.columns.remove(name);
        this.columnsOrder.remove(col);
    }

    public void renameColumn(String name, String newName) {
        if (name == null) {
            throw new IllegalArgumentException("'name' is null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("'newName' is null");
        }
        if (this.getColumn(newName) == null) {
            throw new IllegalArgumentException("column already exists: " + newName);
        }
        Column col = this.getColumn(name);
        if (col == null) {
            throw new IllegalArgumentException("column does not exist: " + name);
        }
        this.columns.remove(col.getName());
        col._setName(name);
        this.columns.put(col.getName(), col);
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public PrimaryKey setPrimaryKey(String name, String ... pkColumnNames) {
        PrimaryKey pk;
        if (name != null && name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        if (pkColumnNames == null || pkColumnNames.length == 0) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = pkColumnNames;
        int n = pkColumnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pkColumnName = stringArray[n2];
            Column pkColumn = this.columns.get(pkColumnName);
            if (pkColumn == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        this.primaryKey = pk = new PrimaryKey(name, this.getName(), pkColumnNames);
        return pk;
    }

    public void removePrimaryKey() {
        this.primaryKey = null;
    }

    public ForeignKey[] getForeignKeys() {
        return this.foreignKeys.toArray(new ForeignKey[this.foreignKeys.size()]);
    }

    public int getForeignKeyCount() {
        return this.foreignKeys.size();
    }

    public ForeignKey addForeignKey(String name, String[] fkColumnNames, String pkTableName, String[] pkColumnNames) {
        ForeignKey fk = new ForeignKey(name, this.getName(), fkColumnNames, pkTableName, pkColumnNames);
        String[] stringArray = fkColumnNames;
        int n = fkColumnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fkColumnName = stringArray[n2];
            Column fkColumn = this.getColumn(fkColumnName);
            if (fkColumn == null) {
                throw new IllegalArgumentException(String.format("'%s' is no column of this table", fkColumnName));
            }
            ++n2;
        }
        this.foreignKeys.add(fk);
        return fk;
    }

    public void removeForeignKey(ForeignKey fk) {
        this.foreignKeys.remove(fk);
    }

    public UniqueConstraint[] getUniqueConstraints() {
        return this.uniqueConstraints.toArray(new UniqueConstraint[this.uniqueConstraints.size()]);
    }

    public int getUniqueConstraintCount() {
        return this.uniqueConstraints.size();
    }

    public UniqueConstraint addUniqueConstraint(String name, String[] columnNames) {
        UniqueConstraint uc = new UniqueConstraint(name, this.getName(), columnNames);
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            Column column = this.getColumn(columnName);
            if (column == null) {
                throw new IllegalArgumentException(String.format("'%s' is no column of this table", columnName));
            }
            ++n2;
        }
        this.uniqueConstraints.add(uc);
        return uc;
    }

    public void removeUniqueConstraint(UniqueConstraint uc) {
        this.uniqueConstraints.remove(uc);
    }

    public boolean getQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public void setQuoteIdentifiers(boolean quiteIdentifiers) {
        this.quoteIdentifiers = quiteIdentifiers;
    }

    @Override
    public Iterator<Column> iterator() {
        return this.columnsOrder.iterator();
    }

    public Table clone() {
        try {
            Table clone = (Table)super.clone();
            clone.columnsOrder = new ArrayList<Column>();
            clone.columns = new HashMap<String, Column>();
            for (Column column : this.columnsOrder) {
                Column colClone = column.clone();
                clone.columnsOrder.add(colClone);
                clone.columns.put(colClone.getName(), colClone);
            }
            if (clone.primaryKey != null) {
                clone.primaryKey = this.primaryKey.clone();
            }
            clone.foreignKeys = new ArrayList<ForeignKey>();
            for (ForeignKey fk : this.foreignKeys) {
                clone.foreignKeys.add(fk.clone());
            }
            clone.uniqueConstraints = new ArrayList<UniqueConstraint>();
            for (UniqueConstraint uc : this.uniqueConstraints) {
                clone.uniqueConstraints.add(uc.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static class TableColumn
    extends Column {
        TableColumn(String name) {
            super(name);
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("use Table#renameColumn(..) instead");
        }
    }
}

