/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.providers;

import de.aristaflow.adept2.base.dbaccess.DefaultDBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;

public class DB2AccessProvider
extends DefaultDBAccessProvider {
    private static final String SEQUENCE_EXISTS = "SELECT SEQNAME FROM syscat.sequences WHERE SEQSCHEMA = %s AND SEQNAME = %s";
    private static final String NEXT_ID = "VALUES (NEXT VALUE FOR %s)";

    @Override
    public boolean isSupportedConnectionURL(String subProtocol, String subName) {
        return "db2".equalsIgnoreCase(subProtocol);
    }

    @Override
    public void adaptProperties(Properties props) {
        props.setProperty("deferPrepares", "false");
    }

    @Override
    public String getCurrentSchema(Connection con) throws SQLException {
        String string;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("VALUES (CURRENT SCHEMA)");
            rs.next();
            String schema = rs.getString(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            string = schema;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return string;
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        String ret;
        this.checkTypeSizeAndScale(jdbcTypeCode, size, scale);
        switch (jdbcTypeCode) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                ret = "SMALLINT";
                break;
            }
            case 4: {
                ret = "INTEGER";
                break;
            }
            case -5: {
                ret = "BIGINT";
                break;
            }
            case 7: {
                ret = "REAL";
                break;
            }
            case 8: {
                ret = "DOUBLE";
                break;
            }
            case 6: {
                ret = String.format("FLOAT(%d)", size);
                break;
            }
            case 2: 
            case 3: {
                ret = String.format("DECIMAL(%d,%d)", size, scale);
                break;
            }
            case 1: {
                if (size <= 254) {
                    ret = String.format("CHAR(%d)", size);
                    break;
                }
            }
            case 12: {
                if (size <= 32672) {
                    ret = String.format("VARCHAR(%d)", size);
                    break;
                }
            }
            case -1: {
                if (size <= 32700) {
                    ret = "LONG VARCHAR";
                    break;
                }
            }
            case 2005: {
                ret = "CLOB";
                break;
            }
            case -2: {
                if (size <= 254) {
                    ret = String.format("CHAR(%d) FOR BIT DATA", size);
                    break;
                }
            }
            case -3: {
                if (size <= 32672) {
                    ret = String.format("VARCHAR(%d) FOR BIT DATA", size);
                    break;
                }
            }
            case -4: {
                if (size <= 32700) {
                    ret = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
            }
            case 2004: {
                ret = "BLOB (1G)";
                break;
            }
            case 91: {
                ret = "DATE";
                break;
            }
            case 92: {
                ret = "TIME";
                break;
            }
            case 93: {
                ret = "TIMESTAMP";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public boolean isTableMissing(SQLException ex) {
        return "42704".equals(ex.getSQLState());
    }

    @Override
    public boolean isUniqueViolation(SQLException ex) {
        return "23505".equals(ex.getSQLState());
    }

    @Override
    public boolean isForeignKeyViolation(SQLException ex) {
        return "23503".equals(ex.getSQLState());
    }

    @Override
    public boolean sequenceExists(ExtendedConnection connection, String origSequenceName) throws SQLException {
        boolean bl;
        if (origSequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String sequenceName = MetaDataTools.adjustIdentifierCase(connection.getMetaData(), origSequenceName);
        sequenceName = connection.formatValue(sequenceName, 1);
        String query = SEQUENCE_EXISTS;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("values current schema");
            rs.next();
            String sequenceSchema = connection.formatValue(rs.getString(1), 1);
            rs = JDBCTools.close(rs);
            query = String.format(query, sequenceSchema, sequenceName);
            rs = stmt.executeQuery(query);
            boolean exists = rs.next();
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            bl = exists;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return bl;
    }

    @Override
    public long nextID(ExtendedConnection connection, String sequenceName) throws SQLException {
        long l;
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String query = String.format(NEXT_ID, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            long id = rs.getLong(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            l = id;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return l;
    }

    @Override
    public void dropColumn(ExtendedConnection con, String tableName, String columnName) throws SQLException {
        DB2AccessProvider.dropColumnWorkaround(con, tableName, columnName);
    }

    @Override
    public String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName, String startCondition, ParentToChildConnection[] parentToChildConnections, int maxDepth) throws SQLException {
        String recTableName = "RecTab" + new Random().nextInt(Integer.MAX_VALUE);
        StringBuilder createStatement = new StringBuilder(String.format("CREATE VIEW %1$s AS WITH RecRel(Depth, %2$s) AS (SELECT 1, %2$s FROM %3$s WHERE %4$s UNION ALL SELECT Parent.Depth + 1, %5$s FROM RecRel AS Parent, %3$s AS Child WHERE ", recTableName, this.concatSelectAttributes(null, selectAttributes), tableName, startCondition, this.concatSelectAttributes("Child", selectAttributes)));
        ParentToChildConnection[] parentToChildConnectionArray = parentToChildConnections;
        int n = parentToChildConnections.length;
        int n2 = 0;
        while (n2 < n) {
            ParentToChildConnection pcConnection = parentToChildConnectionArray[n2];
            createStatement.append(String.format("Parent.%1$s %2$s Child.%3$s AND ", pcConnection.getParentAttribute(), pcConnection.getOperator(), pcConnection.getChildAttribute()));
            ++n2;
        }
        createStatement.append(String.format("Parent.Depth < %1$s) SELECT * FROM RecRel", maxDepth));
        String message = String.format("createRecursionTable Query: \nCREATE - Statement: '%1$s'", createStatement.toString());
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
        this.recursionTables.add(recTableName);
        return recTableName;
    }

    @Override
    public void dropAllRecursionTables(ExtendedConnection connection) throws SQLException {
        ListIterator recursionTableNames = this.recursionTables.listIterator();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            while (recursionTableNames.hasNext()) {
                String currentName = (String)recursionTableNames.next();
                stmt.executeUpdate(String.format("DROP VIEW %1$s", currentName));
                recursionTableNames.remove();
            }
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropRecursionTable(ExtendedConnection connection, String tableName) throws SQLException {
        if (this.recursionTables.contains(tableName)) {
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(String.format("DROP VIEW %1$s", tableName));
                stmt = JDBCTools.close(stmt);
            }
            finally {
                JDBCTools.closeQuietly(stmt);
            }
            this.recursionTables.remove(tableName);
        }
    }
}

