/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.providers;

import de.aristaflow.adept2.base.dbaccess.DefaultDBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;

public class DerbyAccessProvider
extends DefaultDBAccessProvider {
    private static final String SEQUENCE_TABLE_PREFIX = "seq_";
    private static final String LOCK_TABLE = "LOCK TABLE %s IN EXCLUSIVE MODE";
    private static final String CREATE_SEQUENCE_1 = "CREATE TABLE %s (id BIGINT NOT NULL, inc BIGINT NOT NULL)";
    private static final String CREATE_SEQUENCE_2 = "INSERT INTO %s VALUES(%d, %d)";
    private static final String DROP_SEQUENCE = "DROP TABLE %s";
    private static final String NEXT_ID_1 = "UPDATE %s SET id = id + inc";
    private static final String NEXT_ID_2 = "SELECT id FROM %s";

    @Override
    public boolean isSupportedConnectionURL(String subProtocol, String subName) {
        return "derby".equalsIgnoreCase(subProtocol);
    }

    @Override
    public String getCurrentSchema(Connection con) throws SQLException {
        String string;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("VALUES (CURRENT SCHEMA)");
            rs.next();
            String schema = rs.getString(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            string = schema;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return string;
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        String ret;
        this.checkTypeSizeAndScale(jdbcTypeCode, size, scale);
        boolean sizeSet = size > -1;
        switch (jdbcTypeCode) {
            case 16: {
                ret = "SMALLINT";
                break;
            }
            case -7: {
                ret = "SMALLINT";
                break;
            }
            case -6: {
                ret = "SMALLINT";
                break;
            }
            case 5: {
                ret = "SMALLINT";
                break;
            }
            case 4: {
                ret = "INTEGER";
                break;
            }
            case -5: {
                ret = "BIGINT";
                break;
            }
            case 7: {
                ret = "REAL";
                break;
            }
            case 8: {
                ret = "DOUBLE";
                break;
            }
            case 6: {
                ret = String.format("FLOAT(%d)", size);
                break;
            }
            case 2: {
                ret = String.format("NUMERIC(%d,%d)", size, scale);
                break;
            }
            case 3: {
                ret = String.format("DECIMAL(%d,%d)", size, scale);
                break;
            }
            case 1: {
                ret = String.format("CHAR(%d)", size);
                break;
            }
            case 12: {
                if (size <= 32672) {
                    ret = String.format("VARCHAR(%d)", size);
                    break;
                }
            }
            case -1: {
                if (size <= 32700) {
                    ret = "LONG VARCHAR";
                    break;
                }
            }
            case 2005: {
                if (sizeSet) {
                    ret = String.format("CLOB(%d)", size);
                    break;
                }
                ret = "CLOB";
                break;
            }
            case -2: {
                if (size <= 254) {
                    ret = String.format("CHAR(%d) FOR BIT DATA", size);
                    break;
                }
            }
            case -3: {
                if (size <= 32672) {
                    ret = String.format("VARCHAR(%d) FOR BIT DATA", size);
                    break;
                }
            }
            case -4: {
                if (size <= 32700) {
                    ret = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
            }
            case 2004: {
                if (sizeSet) {
                    ret = String.format("BLOB(%d)", size);
                    break;
                }
                ret = "BLOB";
                break;
            }
            case 91: {
                ret = "DATE";
                break;
            }
            case 92: {
                ret = "TIME";
                break;
            }
            case 93: {
                ret = "TIMESTAMP";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public boolean isTableMissing(SQLException ex) {
        return "42Y07".equals(ex.getSQLState()) || "42X05".equals(ex.getSQLState());
    }

    @Override
    public boolean isUniqueViolation(SQLException ex) {
        return "23505".equals(ex.getSQLState());
    }

    @Override
    public boolean isForeignKeyViolation(SQLException ex) {
        return "23503".equals(ex.getSQLState());
    }

    private String getTableNameForSequence(ExtendedConnection connection, String sequenceName) {
        return SEQUENCE_TABLE_PREFIX + sequenceName;
    }

    @Override
    public void createSequence(ExtendedConnection con, String sequenceName, long start, long increment) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(con, sequenceName);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            String query = String.format(CREATE_SEQUENCE_1, tableName);
            stmt.executeUpdate(query);
            query = String.format(LOCK_TABLE, tableName);
            stmt.executeUpdate(query);
            query = String.format(CREATE_SEQUENCE_2, tableName, start, increment);
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropSequence(ExtendedConnection connection, String sequenceName) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        String query = String.format(DROP_SEQUENCE, tableName);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public long nextID(ExtendedConnection origConnection, String sequenceName) throws SQLException {
        long l;
        ExtendedConnection connection = origConnection;
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Boolean previousAutoCommit = JDBCTools.turnOffAutoCommit(connection);
            stmt = connection.createStatement();
            String query = String.format(LOCK_TABLE, tableName);
            stmt.executeUpdate(query);
            query = String.format(NEXT_ID_2, tableName);
            rs = stmt.executeQuery(query);
            rs.next();
            long id = rs.getLong(1);
            rs = JDBCTools.close(rs);
            query = String.format(NEXT_ID_1, tableName);
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
            connection = JDBCTools.restoreAutoCommit(connection, previousAutoCommit);
            l = id;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            JDBCTools.rollbackQuietly(connection);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        JDBCTools.rollbackQuietly(connection);
        return l;
    }

    @Override
    public boolean sequenceExists(ExtendedConnection connection, String sequenceName) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        return connection.tableExists(tableName);
    }

    @Override
    public String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName, String startCondition, ParentToChildConnection[] parentToChildConnections, int maxDepth) throws SQLException {
        String recTableName = this.createRecursionTable(connection, selectAttributes, tableName);
        this.initaliseRecursion(connection, recTableName, selectAttributes, tableName, startCondition);
        int i = 2;
        while (i <= maxDepth) {
            this.proceedRecursion(connection, recTableName, i, selectAttributes, tableName, parentToChildConnections);
            ++i;
        }
        return recTableName;
    }

    protected String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName) throws SQLException {
        String recTableName = "RecTab" + new Random().nextInt(Integer.MAX_VALUE);
        StringBuilder createStatement = new StringBuilder(String.format("CREATE TABLE %1$s (Depth INTEGER", recTableName));
        String[] stringArray = selectAttributes;
        int n = selectAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String selectAttribute = stringArray[n2];
            createStatement.append(String.format(", %1$s %2$s", selectAttribute, this.getColumnTypeString(connection, tableName, selectAttribute)));
            ++n2;
        }
        createStatement.append(")");
        String message = String.format("createRecursionTable Query: \nCREATE - Statement: '%1$s'", createStatement.toString());
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
        this.recursionTables.add(recTableName);
        return recTableName;
    }

    protected void initaliseRecursion(ExtendedConnection connection, String recTableName, String[] selectAttributes, String tableName, String startCondition) throws SQLException {
        String insertStatement = String.format("INSERT INTO %1$s SELECT 1, %2$s FROM %3$s WHERE %4$s", recTableName, this.concatSelectAttributes(null, selectAttributes), tableName, startCondition);
        String message = String.format("createRecursionTable Query: \nInitialising Recursion: '%1$s'", insertStatement);
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(insertStatement);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void proceedRecursion(ExtendedConnection connection, String recTableName, int currentDepth, String[] selectAttributes, String tableName, ParentToChildConnection[] parentToChildConnections) throws SQLException {
        StringBuilder insertStatement = new StringBuilder(String.format("INSERT INTO %1$s SELECT %2$s, %3$s FROM %1$s AS Parent JOIN %4$s AS Child ON ", recTableName, currentDepth, this.concatSelectAttributes("Child", selectAttributes), tableName));
        int j = 0;
        while (j < parentToChildConnections.length) {
            ParentToChildConnection conn = parentToChildConnections[j];
            insertStatement.append(String.format("Parent.%1$s %2$s Child.%3$s ", conn.getParentAttribute(), conn.getOperator(), conn.getChildAttribute()));
            if (j != parentToChildConnections.length - 1) {
                insertStatement.append("AND ");
            }
            ++j;
        }
        insertStatement.append(String.format("WHERE Parent.Depth = %1$s", currentDepth - 1));
        String message = String.format("build_rec Query: \nProceeding Recursion: '%1$s", insertStatement.toString());
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(insertStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropRecursionTable(ExtendedConnection connection, String tableName) throws SQLException {
        if (this.recursionTables.contains(tableName)) {
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(String.format("DROP TABLE %1$s", tableName));
                stmt = JDBCTools.close(stmt);
            }
            finally {
                JDBCTools.closeQuietly(stmt);
            }
            this.recursionTables.remove(tableName);
            this.logger.finer(String.format("Removed '%1$s' from recursionTables.", tableName));
        }
    }

    protected String getColumnTypeString(ExtendedConnection con, String tableName, String columnName) throws SQLException {
        String ret = null;
        DatabaseMetaData metaData = con.getMetaData();
        tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
        columnName = MetaDataTools.adjustIdentifierCase(metaData, columnName);
        ResultSet rs = metaData.getColumns(con.getCatalog(), con.getSchema(), tableName, columnName);
        this.logger.fine(String.format("Queried columname '%1$s.%2$s'.", tableName, columnName));
        while (rs.next()) {
            int jdbcType = rs.getInt("DATA_TYPE");
            int size = rs.getInt("COLUMN_SIZE");
            if (rs.wasNull()) {
                size = -1;
            }
            int scale = rs.getInt("DECIMAL_DIGITS");
            if (rs.wasNull()) {
                scale = -1;
            }
            try {
                ret = this.getCorrespondingDBType(jdbcType, size, scale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    ret = this.getCorrespondingDBType(jdbcType, size, -1);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    ret = this.getCorrespondingDBType(jdbcType, -1, -1);
                }
            }
        }
        return ret;
    }
}

