/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.providers;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.defaultimplementation.PoolingJDBCDataSource;
import de.aristaflow.adept2.base.service.Registry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;
import org.apache.derby.drda.NetworkServerControl;

@ConfigurationDescription(properties={@Property(name="DerbyHost", defaultValue="0.0.0.0", description="The local network interface on which the Derbyserver should be accessible."), @Property(name="DerbyPort", type=Property.Type.INT, defaultValue="1527")})
public class DerbyEmbeddedNetworkServerDataSource
extends PoolingJDBCDataSource {
    private NetworkServerControl networkServerControl;
    private String host;
    private int port;
    private boolean startedServer;

    public DerbyEmbeddedNetworkServerDataSource(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.host = configuration.getString("DerbyHost");
        this.port = configuration.getInt("DerbyPort");
    }

    @Override
    public ExtendedConnection getConnection() throws SQLException {
        try {
            return super.getConnection();
        }
        catch (SQLException ex) {
            try {
                this.checkAndStartNetworkServer();
                this.waitUntilStarted(10000L);
                return super.getConnection();
            }
            catch (Exception exception) {
                throw ex;
            }
        }
    }

    @Override
    public void start() throws AbortServiceException {
        try {
            this.networkServerControl = new NetworkServerControl(InetAddress.getByName(this.host), this.port);
            this.checkAndStartNetworkServer();
        }
        catch (Exception ex) {
            throw new ConfigurationException("Could not start the network servercontrol for the Derby server!", ex);
        }
        super.start();
    }

    @Override
    public void shutdown() {
        block9: {
            super.shutdown();
            try {
                this.networkServerControl.shutdown();
                if (!this.startedServer) break block9;
                Connection con = null;
                try {
                    try {
                        con = DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException sQLException) {
                        if (con != null) {
                            con.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception ex) {
                String msg = "Couldn't shutdown the Derby server properly! (see exception)";
                this.logger.log(Level.WARNING, msg, ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkAndStartNetworkServer() throws Exception {
        block7: {
            block10: {
                block8: {
                    block9: {
                        try {
                            this.networkServerControl.ping();
                            break block7;
                        }
                        catch (Exception v0) {
                            if (!this.host.equals("0.0.0.0")) break block8;
                            localAddresses = null;
                            try {
                                localAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                            }
                            catch (UnknownHostException v1) {}
                            if (localAddresses == null) break block9;
                            addressList = new StringBuilder(localAddresses[0].getHostAddress());
                            i = 1;
                            ** while (i < localAddresses.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (i == localAddresses.length - 1) {
                                addressList.append(" and ");
                            } else {
                                addressList.append(", ");
                            }
                            addressList.append(localAddresses[i].getHostAddress());
                            ++i;
                            continue;
                        }
lbl25:
                        // 1 sources

                        msg = "Starting Derby server on all local network interfaces on port %s: %s.";
                        System.out.println(String.format(msg, new Object[]{this.port, addressList.toString()}));
                        break block10;
                    }
                    msg = "Starting Derby server on all local network interfaces on port %s.";
                    System.out.println(String.format(msg, new Object[]{this.port}));
                    break block10;
                }
                System.out.println(String.format("Starting Derby server on %s:%s...", new Object[]{this.host, this.port}));
            }
            this.networkServerControl.start(null);
            this.startedServer = true;
        }
    }

    private void waitUntilStarted(long timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                while (true) {
                    this.networkServerControl.ping();
                }
            }
            catch (Exception ex) {
                if (System.currentTimeMillis() - startTime > timeout) {
                    throw ex;
                }
                Thread.sleep(250L);
            }
        }
    }
}

