/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.providers;

import de.aristaflow.adept2.base.dbaccess.DefaultDBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;

public class OracleAccessProvider
extends DefaultDBAccessProvider {
    private static final String CREATE_SEQUENCE = "CREATE SEQUENCE %s MINVALUE -99999999999999999999999999 START WITH %d INCREMENT BY %d";
    private static final String DROP_SEQUENCE = "DROP SEQUENCE %s";
    private static final String SEQUENCE_EXISTS = "SELECT SEQUENCE_NAME FROM all_sequences WHERE SEQUENCE_NAME = %s";
    private static final String NEXT_ID = "SELECT %s.nextval from dual";

    @Override
    public boolean isSupportedConnectionURL(String subProtocol, String subName) {
        return "oracle".equalsIgnoreCase(subProtocol);
    }

    @Override
    public void adaptProperties(Properties props) {
        props.setProperty("oracle.jdbc.J2EE13Compliant", "true");
    }

    @Override
    public String getCurrentSchema(Connection con) throws SQLException {
        return con.getMetaData().getUserName();
    }

    @Override
    public String getEXCEPTKeyword() {
        return "MINUS";
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        String ret;
        this.checkTypeSizeAndScale(jdbcTypeCode, size, scale);
        boolean sizeSet = size > -1;
        switch (jdbcTypeCode) {
            case 16: {
                ret = "NUMBER(1)";
                break;
            }
            case -7: {
                ret = "NUMBER(1)";
                break;
            }
            case -6: {
                ret = "NUMBER(3)";
                break;
            }
            case 5: {
                ret = "NUMBER(5)";
                break;
            }
            case 4: {
                ret = "NUMBER(10)";
                break;
            }
            case -5: {
                ret = "NUMBER(20)";
                break;
            }
            case 7: {
                ret = "REAL";
                break;
            }
            case 8: {
                ret = "DOUBLE PRECISION";
                break;
            }
            case 6: {
                ret = "FLOAT";
                break;
            }
            case 2: 
            case 3: {
                ret = String.format("NUMBER(%d,%d)", size, scale);
                break;
            }
            case 1: {
                if (size <= 2000) {
                    ret = String.format("CHAR(%d)", size);
                    break;
                }
            }
            case 12: {
                if (size <= 4000) {
                    ret = String.format("VARCHAR2(%d)", size);
                    break;
                }
            }
            case -1: 
            case 2005: {
                ret = "NCLOB";
                break;
            }
            case -3: 
            case -2: {
                if (size <= 2000) {
                    ret = String.format("RAW(%d)", size);
                    break;
                }
            }
            case -4: 
            case 2004: {
                ret = "BLOB";
                break;
            }
            case 91: {
                ret = "DATE";
                break;
            }
            case 92: {
                if (!sizeSet) {
                    ret = "TIMESTAMP";
                    break;
                }
                ret = String.format("TIMESTAMP(%d)", size);
                break;
            }
            case 93: {
                if (!sizeSet) {
                    ret = "TIMESTAMP";
                    break;
                }
                ret = String.format("TIMESTAMP(%d)", Math.max(size, 9));
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public boolean isTableMissing(SQLException ex) {
        return "42000".equals(ex.getSQLState()) && ex.getErrorCode() == 942;
    }

    @Override
    public boolean isUniqueViolation(SQLException ex) {
        return "23000".equals(ex.getSQLState()) && ex.getErrorCode() == 1;
    }

    @Override
    public boolean isForeignKeyViolation(SQLException ex) {
        return "23000".equals(ex.getSQLState()) && ex.getErrorCode() == 2291;
    }

    @Override
    public void createSequence(ExtendedConnection connection, String sequenceName, long start, long increment) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String query = String.format(CREATE_SEQUENCE, sequenceName, start, increment);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropSequence(ExtendedConnection connection, String sequenceName) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String query = String.format(DROP_SEQUENCE, sequenceName);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public boolean sequenceExists(ExtendedConnection connection, String sequenceName) throws SQLException {
        boolean bl;
        ArgChecks.checkForNull(sequenceName, "sequenceName");
        sequenceName = MetaDataTools.adjustIdentifierCase(connection.getMetaData(), sequenceName);
        sequenceName = connection.formatValue(sequenceName, 1);
        String query = String.format(SEQUENCE_EXISTS, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            boolean exists = rs.next();
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            bl = exists;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return bl;
    }

    @Override
    public long nextID(ExtendedConnection connection, String sequenceName) throws SQLException {
        long l;
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String query = String.format(NEXT_ID, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            long id = rs.getLong(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            l = id;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return l;
    }

    @Override
    public String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName, String startCondition, ParentToChildConnection[] parentToChildConnections, int maxDepth) throws SQLException {
        String recTableName = "RecTab" + new Random().nextInt(Integer.MAX_VALUE);
        StringBuilder createStatement = new StringBuilder(String.format("CREATE TABLE %1$s AS SELECT Level AS Depth, %2$s FROM %3$s START WITH %4$s CONNECT BY PRIOR ", recTableName, this.concatSelectAttributes(null, selectAttributes), tableName, startCondition));
        ParentToChildConnection[] parentToChildConnectionArray = parentToChildConnections;
        int n = parentToChildConnections.length;
        int n2 = 0;
        while (n2 < n) {
            ParentToChildConnection pcConnection = parentToChildConnectionArray[n2];
            createStatement.append(String.format("%1$s %2$s %3$s AND ", pcConnection.getParentAttribute(), pcConnection.getOperator(), pcConnection.getChildAttribute()));
            ++n2;
        }
        createStatement.append(String.format("LEVEL <= %1$s", maxDepth));
        String message = String.format("createRecursionTable Query: \nCREATE - Statement: '%1$s'", createStatement.toString());
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
        this.recursionTables.add(recTableName);
        return recTableName;
    }

    @Override
    public void dropAllRecursionTables(ExtendedConnection connection) throws SQLException {
        ListIterator recursionTableNames = this.recursionTables.listIterator();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            while (recursionTableNames.hasNext()) {
                String currentName = (String)recursionTableNames.next();
                stmt.executeUpdate(String.format("DROP TABLE %1$s PURGE", currentName));
                recursionTableNames.remove();
            }
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropRecursionTable(ExtendedConnection connection, String tableName) throws SQLException {
        if (this.recursionTables.contains(tableName)) {
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(String.format("DROP TABLE %1$s PURGE", tableName));
                stmt = JDBCTools.close(stmt);
            }
            finally {
                JDBCTools.closeQuietly(stmt);
            }
            this.recursionTables.remove(tableName);
        }
    }
}

