/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.providers;

import de.aristaflow.adept2.base.dbaccess.DefaultDBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.MetaDataTools;
import de.aristaflow.adept2.base.dbaccess.ParentToChildConnection;
import de.aristaflow.adept2.util.ArgChecks;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;

public class PostgreSQLAccessProvider
extends DefaultDBAccessProvider {
    private static final String CREATE_SEQUENCE = "CREATE SEQUENCE %s START WITH %d INCREMENT BY %d";
    private static final String NEXT_ID = "SELECT nextval('%s')";
    private static final String SEQUENCE_EXISTS = "SELECT currval('%s');";

    @Override
    public boolean isSupportedConnectionURL(String subProtocol, String subName) {
        return "postgresql".equalsIgnoreCase(subProtocol);
    }

    @Override
    public String getCurrentSchema(Connection con) throws SQLException {
        String string;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT current_schema()");
            rs.next();
            String schema = rs.getString(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            string = schema;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return string;
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        this.checkTypeSizeAndScale(jdbcTypeCode, size, scale);
        switch (jdbcTypeCode) {
            case -7: 
            case -6: {
                return "SMALLINT";
            }
            case -1: 
            case 2005: {
                return "TEXT";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "BYTEA";
            }
        }
        return super.getCorrespondingDBType(jdbcTypeCode, size, scale);
    }

    @Override
    public String formatValue(Object value, int typeCode) {
        if (value == null) {
            return "null";
        }
        switch (typeCode) {
            case 16: {
                if (value instanceof Boolean) {
                    boolean b = (Boolean)value;
                    return b ? "true" : "false";
                }
                return value.toString();
            }
        }
        return super.formatValue(value, typeCode);
    }

    @Override
    public boolean isTableMissing(SQLException ex) {
        return "42P01".equals(ex.getSQLState());
    }

    @Override
    public boolean isUniqueViolation(SQLException ex) {
        return "23505".equals(ex.getSQLState());
    }

    @Override
    public boolean isForeignKeyViolation(SQLException ex) {
        return "23503".equals(ex.getSQLState());
    }

    @Override
    public void createSequence(ExtendedConnection connection, String sequenceName, long start, long increment) throws SQLException {
        ArgChecks.checkForNull(sequenceName, "sequenceName");
        String query = String.format(CREATE_SEQUENCE, sequenceName, start, increment);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public long nextID(ExtendedConnection connection, String sequenceName) throws SQLException {
        long l;
        ArgChecks.checkForNull(sequenceName, "sequenceName");
        String query = String.format(NEXT_ID, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            long id = rs.getLong(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            l = id;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return l;
    }

    @Override
    public boolean sequenceExists(ExtendedConnection connection, String sequenceName) throws SQLException {
        boolean bl;
        ArgChecks.checkForNull(sequenceName, "sequenceName");
        String query = String.format(SEQUENCE_EXISTS, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            boolean exists = rs.next();
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            bl = exists;
        }
        catch (SQLException ex) {
            block7: {
                block6: {
                    try {
                        if (!ex.getSQLState().equals("42P01")) break block6;
                    }
                    catch (Throwable throwable) {
                        JDBCTools.closeQuietly(stmt, rs);
                        throw throwable;
                    }
                    JDBCTools.closeQuietly(stmt, rs);
                    return false;
                }
                if (!ex.getSQLState().equals("55000")) break block7;
                JDBCTools.closeQuietly(stmt, rs);
                return true;
            }
            System.out.println(ex.getSQLState());
            throw ex;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return bl;
    }

    @Override
    public String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName, String startCondition, ParentToChildConnection[] parentToChildConnections, int maxDepth) throws SQLException {
        String recTableName = this.createRecursionTable(connection, selectAttributes, tableName);
        this.initaliseRecursion(connection, recTableName, selectAttributes, tableName, startCondition);
        int i = 2;
        while (i <= maxDepth) {
            this.proceedRecursion(connection, recTableName, i, selectAttributes, tableName, parentToChildConnections);
            ++i;
        }
        return recTableName;
    }

    protected String createRecursionTable(ExtendedConnection connection, String[] selectAttributes, String tableName) throws SQLException {
        String recTableName = "RecTab" + new Random().nextInt(Integer.MAX_VALUE);
        StringBuilder createStatement = new StringBuilder(String.format("CREATE TABLE %1$s (Depth INTEGER", recTableName));
        String[] stringArray = selectAttributes;
        int n = selectAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String selectAttribute = stringArray[n2];
            createStatement.append(String.format(", %1$s %2$s", selectAttribute, this.getColumnTypeString(connection, tableName, selectAttribute)));
            ++n2;
        }
        createStatement.append(")");
        String message = String.format("createRecursionTable Query: \nCREATE - Statement: '%1$s'", createStatement.toString());
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
        this.recursionTables.add(recTableName);
        return recTableName;
    }

    protected void initaliseRecursion(ExtendedConnection connection, String recTableName, String[] selectAttributes, String tableName, String startCondition) throws SQLException {
        String insertStatement = String.format("INSERT INTO %1$s SELECT 1, %2$s FROM %3$s WHERE %4$s", recTableName, this.concatSelectAttributes(null, selectAttributes), tableName, startCondition);
        String message = String.format("createRecursionTable Query: \nInitialising Recursion: '%1$s'", insertStatement);
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(insertStatement);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void proceedRecursion(ExtendedConnection connection, String recTableName, int currentDepth, String[] selectAttributes, String tableName, ParentToChildConnection[] parentToChildConnections) throws SQLException {
        StringBuilder insertStatement = new StringBuilder(String.format("INSERT INTO %1$s SELECT %2$s, %3$s FROM %1$s AS Parent JOIN %4$s AS Child ON ", recTableName, currentDepth, this.concatSelectAttributes("Child", selectAttributes), tableName));
        int j = 0;
        while (j < parentToChildConnections.length) {
            ParentToChildConnection conn = parentToChildConnections[j];
            insertStatement.append(String.format("Parent.%1$s %2$s Child.%3$s ", conn.getParentAttribute(), conn.getOperator(), conn.getChildAttribute()));
            if (j != parentToChildConnections.length - 1) {
                insertStatement.append("AND ");
            }
            ++j;
        }
        insertStatement.append(String.format("WHERE Parent.Depth = %1$s", currentDepth - 1));
        String message = String.format("build_rec Query: \nProceeding Recursion: '%1$s", insertStatement.toString());
        this.logger.fine(message);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(insertStatement.toString());
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropRecursionTable(ExtendedConnection connection, String tableName) throws SQLException {
        if (this.recursionTables.contains(tableName)) {
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(String.format("DROP TABLE %1$s", tableName));
                stmt = JDBCTools.close(stmt);
            }
            finally {
                JDBCTools.closeQuietly(stmt);
            }
            this.recursionTables.remove(tableName);
            this.logger.finer(String.format("Removed '%1$s' from recursionTables.", tableName));
        }
    }

    protected String getColumnTypeString(ExtendedConnection con, String tableName, String columnName) throws SQLException {
        String ret = null;
        DatabaseMetaData metaData = con.getMetaData();
        tableName = MetaDataTools.adjustIdentifierCase(metaData, tableName);
        columnName = MetaDataTools.adjustIdentifierCase(metaData, columnName);
        ResultSet rs = metaData.getColumns(con.getCatalog(), con.getSchema(), tableName, columnName);
        this.logger.fine(String.format("Queried columname '%1$s.%2$s'.", tableName, columnName));
        while (rs.next()) {
            int jdbcType = rs.getInt("DATA_TYPE");
            int size = rs.getInt("COLUMN_SIZE");
            if (rs.wasNull()) {
                size = -1;
            }
            int scale = rs.getInt("DECIMAL_DIGITS");
            if (rs.wasNull()) {
                scale = -1;
            }
            try {
                ret = this.getCorrespondingDBType(jdbcType, size, scale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    ret = this.getCorrespondingDBType(jdbcType, size, -1);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    ret = this.getCorrespondingDBType(jdbcType, -1, -1);
                }
            }
        }
        return ret;
    }
}

