/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.dbaccess.providers;

import de.aristaflow.adept2.base.dbaccess.DefaultDBAccessProvider;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLServerAccessProvider
extends DefaultDBAccessProvider {
    private static final String SEQUENCE_TABLE_PREFIX = "seq_";
    private static final String CREATE_SEQUENCE_1 = "CREATE TABLE %s (id BIGINT NOT NULL, inc BIGINT NOT NULL)";
    private static final String CREATE_SEQUENCE_2 = "INSERT INTO %s WITH (TABLOCK, HOLDLOCK) VALUES(%d, %d)";
    private static final String DROP_SEQUENCE = "DROP TABLE %s";
    private static final String NEXT_ID_1 = "UPDATE %s SET id = id + inc";
    private static final String NEXT_ID_2 = "SELECT id FROM %s WITH (TABLOCKX, HOLDLOCK)";

    @Override
    public boolean isSupportedConnectionURL(String subProtocol, String subName) {
        return "sqlserver".equalsIgnoreCase(subProtocol);
    }

    @Override
    public String getCurrentSchema(Connection con) throws SQLException {
        String string;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT SCHEMA_NAME()");
            rs.next();
            String schema = rs.getString(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            string = schema;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return string;
    }

    @Override
    public String getCorrespondingDBType(int jdbcTypeCode, int size, int scale) {
        String ret;
        this.checkTypeSizeAndScale(jdbcTypeCode, size, scale);
        switch (jdbcTypeCode) {
            case 16: {
                ret = "BIT";
                break;
            }
            case -7: {
                ret = "BIT";
                break;
            }
            case -6: {
                ret = "TINYINT";
                break;
            }
            case 5: {
                ret = "SMALLINT";
                break;
            }
            case 4: {
                ret = "INTEGER";
                break;
            }
            case -5: {
                ret = "BIGINT";
                break;
            }
            case 7: {
                ret = "REAL";
                break;
            }
            case 8: {
                ret = "DOUBLE PRECISION";
                break;
            }
            case 6: {
                ret = String.format("FLOAT(%d)", size);
                break;
            }
            case 3: {
                ret = String.format("DECIMAL(%d,%d)", size, scale);
                break;
            }
            case 2: {
                ret = String.format("NUMERIC(%d,%d)", size, scale);
                break;
            }
            case 1: {
                if (size <= 8000) {
                    ret = String.format("NCHAR(%d) COLLATE SQL_Latin1_General_Cp1_CS_AS", size);
                    break;
                }
            }
            case 12: {
                if (size <= 8000) {
                    ret = String.format("NVARCHAR(%d) COLLATE SQL_Latin1_General_Cp1_CS_AS", size);
                    break;
                }
            }
            case -1: 
            case 2005: {
                ret = "NVARCHAR(MAX) COLLATE SQL_Latin1_General_Cp1_CS_AS";
                break;
            }
            case -2: {
                if (size <= 8000) {
                    ret = String.format("BINARY(%d)", size);
                    break;
                }
            }
            case -3: {
                if (size <= 8000) {
                    ret = String.format("VARBINARY(%d)", size);
                    break;
                }
            }
            case -4: 
            case 2004: {
                ret = "VARBINARY(MAX)";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                ret = "DATETIME";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public boolean isTableMissing(SQLException ex) {
        return ex.getErrorCode() == 208;
    }

    @Override
    public boolean isUniqueViolation(SQLException ex) {
        return "23000".equals(ex.getSQLState()) && ex.getErrorCode() == 2627;
    }

    @Override
    public boolean isForeignKeyViolation(SQLException ex) {
        return "23000".equals(ex.getSQLState()) && ex.getErrorCode() == 547;
    }

    private String getTableNameForSequence(ExtendedConnection connection, String sequenceName) {
        return SEQUENCE_TABLE_PREFIX + sequenceName;
    }

    @Override
    public void createSequence(ExtendedConnection connection, String sequenceName, long start, long increment) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            String query = String.format(CREATE_SEQUENCE_1, tableName);
            stmt.executeUpdate(query);
            query = String.format(CREATE_SEQUENCE_2, tableName, start, increment);
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public void dropSequence(ExtendedConnection connection, String sequenceName) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        String query = String.format(DROP_SEQUENCE, tableName);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute(query);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    @Override
    public long nextID(ExtendedConnection origConnection, String sequenceName) throws SQLException {
        long l;
        ExtendedConnection connection = origConnection;
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Boolean previousAutoCommit = JDBCTools.turnOffAutoCommit(connection);
            stmt = connection.createStatement();
            String query = String.format(NEXT_ID_2, tableName);
            rs = stmt.executeQuery(query);
            rs.next();
            long id = rs.getLong(1);
            rs = JDBCTools.close(rs);
            query = String.format(NEXT_ID_1, tableName);
            stmt.executeUpdate(query);
            stmt = JDBCTools.close(stmt);
            connection = JDBCTools.restoreAutoCommit(connection, previousAutoCommit);
            l = id;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            JDBCTools.rollbackQuietly(connection);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        JDBCTools.rollbackQuietly(connection);
        return l;
    }

    @Override
    public boolean sequenceExists(ExtendedConnection connection, String sequenceName) throws SQLException {
        if (sequenceName == null) {
            throw new NullArgumentException("The parameter 'sequenceName' must not be null!");
        }
        String tableName = this.getTableNameForSequence(connection, sequenceName);
        return connection.tableExists(tableName);
    }
}

