/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.globalregistry.transientimplementation;

import de.aristaflow.adept2.base.globalregistry.abstractimplementation.AbstractGlobalRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.util.NullArgumentException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public class TransientGlobalRegistry
extends AbstractGlobalRegistry {
    protected final Map<String, Map<String, List<URI>>> services = new HashMap<String, Map<String, List<URI>>>();

    public TransientGlobalRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
    }

    @Override
    public void deRegisterService(String serviceType, String serviceName) {
        if (serviceType == null) {
            throw new NullArgumentException("The parameter serviceType must not be null.");
        }
        if (serviceName == null) {
            throw new NullArgumentException("The parameter serviceName must not be null.");
        }
        if (!this.services.containsKey(serviceType)) {
            throw new IllegalArgumentException("Unknown service type.");
        }
        Map<String, List<URI>> serviceInstances = this.services.get(serviceType);
        if (!serviceInstances.containsKey(serviceName)) {
            throw new IllegalArgumentException("Unknown service instance.");
        }
        serviceInstances.remove(serviceName);
    }

    @Override
    public Map<String, Map<String, List<URI>>> getAllServices() {
        return Collections.unmodifiableMap(this.services);
    }

    @Override
    public Map<String, List<URI>> getAllServices(String serviceType) {
        if (!this.services.containsKey(serviceType)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.services.get(serviceType));
    }

    @Override
    public List<URI> getService(String serviceType, String serviceName) throws ServiceNotKnownException {
        if (!this.services.containsKey(serviceType)) {
            throw new ServiceNotKnownException(serviceType, serviceName);
        }
        Map<String, List<URI>> serviceInstances = this.services.get(serviceType);
        if (!serviceInstances.containsKey(serviceName)) {
            throw new ServiceNotKnownException(serviceType, serviceName);
        }
        return serviceInstances.get(serviceName);
    }

    @Override
    public List<URI> getService(URI entityURI) throws ServiceNotKnownException {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void registerService(String serviceType, String serviceName, List<URI> serviceURI) {
        Map<Object, Object> serviceInstances;
        if (!this.services.containsKey(serviceType)) {
            serviceInstances = new HashMap();
            this.services.put(serviceType, serviceInstances);
        } else {
            serviceInstances = this.services.get(serviceType);
        }
        List oldURIs = (List)serviceInstances.get(serviceName);
        if (oldURIs != null && !oldURIs.equals(serviceURI)) {
            String msg = "Service '/%s/%s' already registered with URIs '%s'. You may not change the URIs this way.";
            msg = String.format(msg, serviceType, serviceName, oldURIs);
            throw new IllegalArgumentException(msg);
        }
        serviceInstances.put(serviceName, serviceURI);
    }
}

