/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.licensing.defaultimplementation;

import de.aristaflow.adept2.base.licensing.defaultimplementation.DefaultLicenceManager;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenceChecker
extends Thread {
    private static final String VM_ERROR_OUTPUT = "VirtualMachineError in LicenceChecker-Thread.";
    protected final Logger logger;
    protected final long period;
    protected long nextRun;
    protected final DefaultLicenceManager licenceMgr;

    protected LicenceChecker(DefaultLicenceManager licenceMgr, long previousCheck, long period) {
        super("LicenceChecker");
        ArgChecks.checkForNull(licenceMgr, "licenceMgr");
        this.logger = LoggerTools.getLogger(this);
        this.period = period;
        this.licenceMgr = licenceMgr;
        if (period <= 0L) {
            this.nextRun = previousCheck;
        } else {
            long now = System.currentTimeMillis();
            this.nextRun = previousCheck + period;
            if (this.nextRun < now) {
                this.nextRun = now + period - (now - this.nextRun) % period;
            }
        }
    }

    protected LicenceChecker(DefaultLicenceManager licenceMgr, long nextCheck) {
        this(licenceMgr, nextCheck, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    long sleepTime = this.nextRun - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    DefaultLicenceManager defaultLicenceManager = this.licenceMgr;
                    synchronized (defaultLicenceManager) {
                        this.licenceMgr.checkAndAdvance();
                        if (this.licenceMgr.endOfGracePeriod(true) || this.period <= 0L) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.nextRun += this.period;
                    long now = System.currentTimeMillis();
                    if (this.nextRun >= now) continue;
                    this.nextRun = now + this.period - (now - this.nextRun) % this.period;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException re) {
                    this.logger.log(Level.WARNING, "Caught runtime exception in the licence checker. Ignoring it.", re);
                }
                catch (VirtualMachineError vme) {
                    LoggerTools.logVirtualMachineErrorSafely(vme, VM_ERROR_OUTPUT);
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            this.logger.log(Level.SEVERE, "Someone tried to stop the licence checker! This is not allowed. Spawning a new one!");
            LicenceChecker replace = new LicenceChecker(this.licenceMgr, this.nextRun - this.period, this.period);
            replace.setName(this.getName());
            replace.setDaemon(this.isDaemon());
            this.licenceMgr.licenceChecker = replace;
            replace.start();
        }
    }
}

