/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.licensing.defaultimplementation;

import de.aristaflow.adept2.base.licensing.ActivationData;
import de.aristaflow.adept2.base.licensing.InvalidLicenceException;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.licensing.defaultimplementation.LicenceChecker;
import de.aristaflow.adept2.base.licensing.defaultimplementation.LicenceTools;
import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultLicenceInformation;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LicenceLoader {
    static LicenceInformation loadExternalLicence() throws InvalidLicenceException {
        LicenceInformation ret = null;
        InputStream is = LicenceChecker.class.getResourceAsStream("/AristaFlow.licence");
        if (is != null) {
            ret = LicenceLoader.verifyLicence(is);
        }
        return ret;
    }

    static ActivationData loadExternalActivation(LicenceInformation licence) throws InvalidLicenceException {
        ActivationData ret = null;
        InputStream is = LicenceChecker.class.getResourceAsStream("/AristaFlow.activation");
        if (is != null) {
            ret = LicenceLoader.verifyAndGetActivation(is, licence);
        }
        return ret;
    }

    static LicenceInformation verifyLicence(InputStream licence) throws InvalidLicenceException {
        Date timeLimitEnd;
        Date timeLimitStart;
        LicenceInformation.Activation activation;
        boolean valid;
        Key key;
        XMLSignature sig;
        Document doc;
        String stringDoc;
        if (licence == null) {
            throw new InvalidLicenceException("No AristaFlow licence has been found!");
        }
        Init.init();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(LicenceManager.class.getResource("licence.xsd"));
            stringDoc = XMLHelperTools.getXMLStringForInputStream(licence);
            doc = XMLHelperTools.getDocumentFromString(stringDoc, schema);
        }
        catch (SAXException saxe) {
            throw new InvalidLicenceException(saxe.getMessage(), 101);
        }
        catch (XMLFormatException xmlfe) {
            throw new InvalidLicenceException(xmlfe.getMessage(), 102);
        }
        catch (IOException ioe) {
            throw new InvalidLicenceException(ioe.getMessage(), 103);
        }
        Element sigElement = (Element)doc.getElementsByTagName("Signature").item(0);
        try {
            sig = new XMLSignature(sigElement, "");
        }
        catch (XMLSignatureException xmlse) {
            throw new InvalidLicenceException(xmlse.getMessage(), 201);
        }
        catch (XMLSecurityException xmlse) {
            throw new InvalidLicenceException(xmlse.getMessage(), 202);
        }
        byte[] byArray = new byte[551];
        byArray[0] = -84;
        byArray[1] = -19;
        byArray[3] = 5;
        byArray[4] = 115;
        byArray[5] = 114;
        byArray[7] = 20;
        byArray[8] = 106;
        byArray[9] = 97;
        byArray[10] = 118;
        byArray[11] = 97;
        byArray[12] = 46;
        byArray[13] = 115;
        byArray[14] = 101;
        byArray[15] = 99;
        byArray[16] = 117;
        byArray[17] = 114;
        byArray[18] = 105;
        byArray[19] = 116;
        byArray[20] = 121;
        byArray[21] = 46;
        byArray[22] = 75;
        byArray[23] = 101;
        byArray[24] = 121;
        byArray[25] = 82;
        byArray[26] = 101;
        byArray[27] = 112;
        byArray[28] = -67;
        byArray[29] = -7;
        byArray[30] = 79;
        byArray[31] = -77;
        byArray[32] = -120;
        byArray[33] = -102;
        byArray[34] = -91;
        byArray[35] = 67;
        byArray[36] = 2;
        byArray[38] = 4;
        byArray[39] = 76;
        byArray[41] = 9;
        byArray[42] = 97;
        byArray[43] = 108;
        byArray[44] = 103;
        byArray[45] = 111;
        byArray[46] = 114;
        byArray[47] = 105;
        byArray[48] = 116;
        byArray[49] = 104;
        byArray[50] = 109;
        byArray[51] = 116;
        byArray[53] = 18;
        byArray[54] = 76;
        byArray[55] = 106;
        byArray[56] = 97;
        byArray[57] = 118;
        byArray[58] = 97;
        byArray[59] = 47;
        byArray[60] = 108;
        byArray[61] = 97;
        byArray[62] = 110;
        byArray[63] = 103;
        byArray[64] = 47;
        byArray[65] = 83;
        byArray[66] = 116;
        byArray[67] = 114;
        byArray[68] = 105;
        byArray[69] = 110;
        byArray[70] = 103;
        byArray[71] = 59;
        byArray[72] = 91;
        byArray[74] = 7;
        byArray[75] = 101;
        byArray[76] = 110;
        byArray[77] = 99;
        byArray[78] = 111;
        byArray[79] = 100;
        byArray[80] = 101;
        byArray[81] = 100;
        byArray[82] = 116;
        byArray[84] = 2;
        byArray[85] = 91;
        byArray[86] = 66;
        byArray[87] = 76;
        byArray[89] = 6;
        byArray[90] = 102;
        byArray[91] = 111;
        byArray[92] = 114;
        byArray[93] = 109;
        byArray[94] = 97;
        byArray[95] = 116;
        byArray[96] = 113;
        byArray[98] = 126;
        byArray[100] = 1;
        byArray[101] = 76;
        byArray[103] = 4;
        byArray[104] = 116;
        byArray[105] = 121;
        byArray[106] = 112;
        byArray[107] = 101;
        byArray[108] = 116;
        byArray[110] = 27;
        byArray[111] = 76;
        byArray[112] = 106;
        byArray[113] = 97;
        byArray[114] = 118;
        byArray[115] = 97;
        byArray[116] = 47;
        byArray[117] = 115;
        byArray[118] = 101;
        byArray[119] = 99;
        byArray[120] = 117;
        byArray[121] = 114;
        byArray[122] = 105;
        byArray[123] = 116;
        byArray[124] = 121;
        byArray[125] = 47;
        byArray[126] = 75;
        byArray[127] = 101;
        byArray[128] = 121;
        byArray[129] = 82;
        byArray[130] = 101;
        byArray[131] = 112;
        byArray[132] = 36;
        byArray[133] = 84;
        byArray[134] = 121;
        byArray[135] = 112;
        byArray[136] = 101;
        byArray[137] = 59;
        byArray[138] = 120;
        byArray[139] = 112;
        byArray[140] = 116;
        byArray[142] = 3;
        byArray[143] = 82;
        byArray[144] = 83;
        byArray[145] = 65;
        byArray[146] = 117;
        byArray[147] = 114;
        byArray[149] = 2;
        byArray[150] = 91;
        byArray[151] = 66;
        byArray[152] = -84;
        byArray[153] = -13;
        byArray[154] = 23;
        byArray[155] = -8;
        byArray[156] = 6;
        byArray[157] = 8;
        byArray[158] = 84;
        byArray[159] = -32;
        byArray[160] = 2;
        byArray[163] = 120;
        byArray[164] = 112;
        byArray[167] = 1;
        byArray[168] = 38;
        byArray[169] = 48;
        byArray[170] = -126;
        byArray[171] = 1;
        byArray[172] = 34;
        byArray[173] = 48;
        byArray[174] = 13;
        byArray[175] = 6;
        byArray[176] = 9;
        byArray[177] = 42;
        byArray[178] = -122;
        byArray[179] = 72;
        byArray[180] = -122;
        byArray[181] = -9;
        byArray[182] = 13;
        byArray[183] = 1;
        byArray[184] = 1;
        byArray[185] = 1;
        byArray[186] = 5;
        byArray[188] = 3;
        byArray[189] = -126;
        byArray[190] = 1;
        byArray[191] = 15;
        byArray[193] = 48;
        byArray[194] = -126;
        byArray[195] = 1;
        byArray[196] = 10;
        byArray[197] = 2;
        byArray[198] = -126;
        byArray[199] = 1;
        byArray[200] = 1;
        byArray[202] = -80;
        byArray[203] = -109;
        byArray[204] = -44;
        byArray[205] = -83;
        byArray[206] = 59;
        byArray[207] = -72;
        byArray[208] = 22;
        byArray[209] = -58;
        byArray[210] = 94;
        byArray[211] = 83;
        byArray[212] = -73;
        byArray[213] = -88;
        byArray[214] = 69;
        byArray[215] = -33;
        byArray[216] = -127;
        byArray[217] = 33;
        byArray[218] = -2;
        byArray[219] = 67;
        byArray[220] = -118;
        byArray[221] = -97;
        byArray[222] = 57;
        byArray[223] = 81;
        byArray[224] = 101;
        byArray[225] = 72;
        byArray[226] = 31;
        byArray[227] = -106;
        byArray[228] = 84;
        byArray[229] = 13;
        byArray[230] = -44;
        byArray[231] = -1;
        byArray[232] = -100;
        byArray[233] = 121;
        byArray[234] = 75;
        byArray[235] = 112;
        byArray[236] = 7;
        byArray[237] = -7;
        byArray[238] = 39;
        byArray[239] = 43;
        byArray[240] = 37;
        byArray[241] = 31;
        byArray[242] = -83;
        byArray[243] = -73;
        byArray[244] = -59;
        byArray[245] = 69;
        byArray[246] = -107;
        byArray[247] = 105;
        byArray[248] = 95;
        byArray[249] = 112;
        byArray[250] = 25;
        byArray[251] = 61;
        byArray[252] = 56;
        byArray[253] = 31;
        byArray[254] = 82;
        byArray[255] = 31;
        byArray[256] = 30;
        byArray[257] = -121;
        byArray[258] = -43;
        byArray[259] = -117;
        byArray[260] = -82;
        byArray[261] = 18;
        byArray[262] = -35;
        byArray[263] = 55;
        byArray[264] = 124;
        byArray[265] = -73;
        byArray[266] = 80;
        byArray[267] = -15;
        byArray[268] = -120;
        byArray[269] = 48;
        byArray[270] = 119;
        byArray[271] = 9;
        byArray[272] = -110;
        byArray[273] = -95;
        byArray[274] = 4;
        byArray[275] = 96;
        byArray[276] = -26;
        byArray[277] = 65;
        byArray[278] = -26;
        byArray[279] = 78;
        byArray[280] = -32;
        byArray[281] = -74;
        byArray[282] = 59;
        byArray[283] = 68;
        byArray[284] = 69;
        byArray[285] = 59;
        byArray[286] = -31;
        byArray[287] = -82;
        byArray[288] = 48;
        byArray[289] = -32;
        byArray[290] = -30;
        byArray[291] = 37;
        byArray[292] = -55;
        byArray[293] = 107;
        byArray[294] = 74;
        byArray[295] = 6;
        byArray[296] = -47;
        byArray[297] = -42;
        byArray[298] = -125;
        byArray[299] = -85;
        byArray[300] = 89;
        byArray[301] = -73;
        byArray[302] = 119;
        byArray[303] = 34;
        byArray[304] = -41;
        byArray[305] = 51;
        byArray[306] = -75;
        byArray[307] = -57;
        byArray[308] = 19;
        byArray[309] = 28;
        byArray[310] = -100;
        byArray[311] = -71;
        byArray[312] = -128;
        byArray[313] = -28;
        byArray[314] = 68;
        byArray[315] = 104;
        byArray[316] = 81;
        byArray[317] = 64;
        byArray[318] = 18;
        byArray[319] = -99;
        byArray[320] = 122;
        byArray[321] = 127;
        byArray[322] = 70;
        byArray[323] = 127;
        byArray[324] = -8;
        byArray[325] = -53;
        byArray[326] = -19;
        byArray[327] = -35;
        byArray[328] = 125;
        byArray[329] = 75;
        byArray[330] = 14;
        byArray[331] = -102;
        byArray[332] = -64;
        byArray[333] = -54;
        byArray[334] = -21;
        byArray[335] = 5;
        byArray[336] = -99;
        byArray[337] = 56;
        byArray[338] = 113;
        byArray[339] = 123;
        byArray[340] = 11;
        byArray[341] = 122;
        byArray[342] = -80;
        byArray[343] = 117;
        byArray[344] = 116;
        byArray[345] = 18;
        byArray[346] = -96;
        byArray[347] = 29;
        byArray[348] = 77;
        byArray[349] = -50;
        byArray[350] = 104;
        byArray[351] = 79;
        byArray[352] = 19;
        byArray[353] = 61;
        byArray[354] = -21;
        byArray[355] = -50;
        byArray[356] = 7;
        byArray[357] = 60;
        byArray[358] = -75;
        byArray[359] = 46;
        byArray[360] = 98;
        byArray[361] = -34;
        byArray[362] = -103;
        byArray[363] = -93;
        byArray[364] = 95;
        byArray[365] = -39;
        byArray[366] = -106;
        byArray[367] = -66;
        byArray[368] = 112;
        byArray[369] = 116;
        byArray[370] = 25;
        byArray[371] = -45;
        byArray[372] = 44;
        byArray[373] = 101;
        byArray[374] = -59;
        byArray[375] = 89;
        byArray[376] = 57;
        byArray[377] = -26;
        byArray[378] = -93;
        byArray[379] = 76;
        byArray[380] = 32;
        byArray[381] = -78;
        byArray[382] = 58;
        byArray[383] = 85;
        byArray[384] = 53;
        byArray[385] = -23;
        byArray[386] = 114;
        byArray[387] = 23;
        byArray[388] = 76;
        byArray[389] = -118;
        byArray[390] = 15;
        byArray[391] = -77;
        byArray[392] = -128;
        byArray[393] = 99;
        byArray[394] = 119;
        byArray[395] = 48;
        byArray[396] = -73;
        byArray[397] = 73;
        byArray[398] = -43;
        byArray[399] = -70;
        byArray[400] = 19;
        byArray[401] = -113;
        byArray[402] = 95;
        byArray[403] = -18;
        byArray[404] = -101;
        byArray[405] = -45;
        byArray[406] = -18;
        byArray[407] = -106;
        byArray[408] = 104;
        byArray[409] = 83;
        byArray[410] = -60;
        byArray[411] = 95;
        byArray[412] = -108;
        byArray[413] = 16;
        byArray[414] = -110;
        byArray[415] = 86;
        byArray[416] = -99;
        byArray[417] = -114;
        byArray[418] = -56;
        byArray[419] = -115;
        byArray[420] = -55;
        byArray[421] = -54;
        byArray[422] = -127;
        byArray[423] = -30;
        byArray[424] = 39;
        byArray[425] = -93;
        byArray[426] = -121;
        byArray[427] = -118;
        byArray[428] = 14;
        byArray[429] = 39;
        byArray[430] = -113;
        byArray[431] = 49;
        byArray[432] = 87;
        byArray[433] = -68;
        byArray[434] = 38;
        byArray[435] = 6;
        byArray[436] = 2;
        byArray[437] = 25;
        byArray[438] = -59;
        byArray[439] = 58;
        byArray[440] = -126;
        byArray[441] = -51;
        byArray[442] = -95;
        byArray[443] = 68;
        byArray[444] = -54;
        byArray[445] = -81;
        byArray[446] = -84;
        byArray[447] = -120;
        byArray[448] = 23;
        byArray[449] = -110;
        byArray[450] = 11;
        byArray[451] = 51;
        byArray[452] = -64;
        byArray[453] = 9;
        byArray[454] = 58;
        byArray[455] = -91;
        byArray[456] = 82;
        byArray[457] = 121;
        byArray[458] = 2;
        byArray[459] = 3;
        byArray[460] = 1;
        byArray[462] = 1;
        byArray[463] = 116;
        byArray[465] = 5;
        byArray[466] = 88;
        byArray[467] = 46;
        byArray[468] = 53;
        byArray[469] = 48;
        byArray[470] = 57;
        byArray[471] = 126;
        byArray[472] = 114;
        byArray[474] = 25;
        byArray[475] = 106;
        byArray[476] = 97;
        byArray[477] = 118;
        byArray[478] = 97;
        byArray[479] = 46;
        byArray[480] = 115;
        byArray[481] = 101;
        byArray[482] = 99;
        byArray[483] = 117;
        byArray[484] = 114;
        byArray[485] = 105;
        byArray[486] = 116;
        byArray[487] = 121;
        byArray[488] = 46;
        byArray[489] = 75;
        byArray[490] = 101;
        byArray[491] = 121;
        byArray[492] = 82;
        byArray[493] = 101;
        byArray[494] = 112;
        byArray[495] = 36;
        byArray[496] = 84;
        byArray[497] = 121;
        byArray[498] = 112;
        byArray[499] = 101;
        byArray[508] = 18;
        byArray[511] = 120;
        byArray[512] = 114;
        byArray[514] = 14;
        byArray[515] = 106;
        byArray[516] = 97;
        byArray[517] = 118;
        byArray[518] = 97;
        byArray[519] = 46;
        byArray[520] = 108;
        byArray[521] = 97;
        byArray[522] = 110;
        byArray[523] = 103;
        byArray[524] = 46;
        byArray[525] = 69;
        byArray[526] = 110;
        byArray[527] = 117;
        byArray[528] = 109;
        byArray[537] = 18;
        byArray[540] = 120;
        byArray[541] = 112;
        byArray[542] = 116;
        byArray[544] = 6;
        byArray[545] = 80;
        byArray[546] = 85;
        byArray[547] = 66;
        byArray[548] = 76;
        byArray[549] = 73;
        byArray[550] = 67;
        byte[] bytes = byArray;
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            key = (Key)ois.readObject();
            ois.close();
        }
        catch (IOException ioe) {
            throw new InvalidLicenceException(ioe.getMessage(), 601);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InvalidLicenceException(cnfe.getMessage(), 602);
        }
        try {
            valid = sig.checkSignatureValue(key);
        }
        catch (XMLSignatureException xmlse) {
            throw new InvalidLicenceException(xmlse.getMessage(), 301);
        }
        if (!valid) {
            throw new InvalidLicenceException("The signature of the licence-XML isinvalid!", 400);
        }
        Element documentElement = doc.getDocumentElement();
        int licenceID = Integer.parseInt(documentElement.getAttribute("id"));
        String customerID = documentElement.getAttribute("customerID");
        String distributorID = documentElement.getAttribute("distributorID");
        String licenceType = documentElement.getAttribute("licenceType");
        String licensee = LicenceTools.getElementsTextContent(documentElement, "licensee");
        String[] mailAddresses = LicenceLoader.getMailAddresses(documentElement);
        String version = LicenceTools.getElementsTextContent(documentElement, "version");
        String act = LicenceTools.getElementsTextContent(documentElement, "activation");
        if ("not required".equals(act)) {
            activation = LicenceInformation.Activation.NOT_REQUIRED;
        } else if ("required".equals(act)) {
            activation = LicenceInformation.Activation.REQUIRED;
        } else {
            String msg = String.format("Activation type '%s' unknown.", act);
            throw new InvalidLicenceException(msg, 701);
        }
        Element limitationsElement = LicenceTools.getFirstElementWithTagname(documentElement, "limitations");
        String timeLimitStartString = LicenceTools.getElementsTextContent(limitationsElement, "from");
        String timeLimitEndString = LicenceTools.getElementsTextContent(limitationsElement, "to");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            timeLimitStart = timeLimitStartString == null ? null : sdf.parse(timeLimitStartString);
            timeLimitEnd = timeLimitEndString == null ? null : sdf.parse(timeLimitEndString);
        }
        catch (ParseException pe) {
            throw new InvalidLicenceException(pe.getMessage(), 505);
        }
        String transactionLimitString = LicenceTools.getElementsTextContent(limitationsElement, "transactions");
        int transactionLimit = transactionLimitString == null ? 0 : Integer.parseInt(transactionLimitString);
        String userLimitString = LicenceTools.getElementsTextContent(limitationsElement, "users");
        int usingUserLimit = userLimitString == null ? 0 : Integer.parseInt(userLimitString);
        userLimitString = LicenceTools.getElementsTextContent(limitationsElement, "usingUsers");
        usingUserLimit = userLimitString == null ? usingUserLimit : Integer.parseInt(userLimitString);
        Element typeLimitElement = LicenceTools.getFirstElementWithTagname(limitationsElement, "processTypes");
        int ipAddress = 0;
        byte ipMask = 0;
        String ipAddressString = LicenceTools.getElementsTextContent(limitationsElement, "ipAddress");
        if (ipAddressString != null) {
            Pattern p = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/?(\\d{1,2})?");
            Matcher m = p.matcher(ipAddressString);
            if (m.find()) {
                int i = 1;
                while (i <= 4) {
                    String bString = m.group(i);
                    int bInt = Integer.parseInt(bString);
                    ipAddress <<= 8;
                    ipAddress |= bInt;
                    ++i;
                }
                if (m.groupCount() == 5) {
                    String ipMaskString = m.group(5);
                    ipMask = Byte.parseByte(ipMaskString);
                }
            } else {
                throw new InvalidLicenceException(550);
            }
        }
        String[] typeLimit = typeLimitElement == null ? null : LicenceLoader.getTypeLimit(limitationsElement);
        Element featureElement = LicenceTools.getFirstElementWithTagname(documentElement, "features");
        boolean isWebClientEnabled = LicenceLoader.getElementsEnabledAttrib(featureElement, "webclient");
        boolean isEscalationEnabled = LicenceLoader.getElementsEnabledAttrib(featureElement, "escalation");
        Map<String, Boolean> products = LicenceLoader.getProducts(featureElement);
        boolean isProcessFlexibilityEnabled = LicenceLoader.getElementsEnabledAttrib(featureElement, "processFlexibility");
        String[] processFlexibilityTypes = LicenceLoader.getTypeLimit(LicenceTools.getFirstElementWithTagname(featureElement, "processFlexibility"));
        boolean isRuntimeFlexibilityEnabled = LicenceLoader.getElementsEnabledAttrib(featureElement, "runtimeFlexibility");
        String[] runtimeFlexibilityTypes = LicenceLoader.getTypeLimit(LicenceTools.getFirstElementWithTagname(featureElement, "runtimeFlexibility"));
        Map<String, String> additions = LicenceLoader.getAdditions(documentElement);
        String licenceDigest = LicenceTools.getElementsTextContent(documentElement, "DigestValue");
        String licenceSignature = LicenceTools.getElementsTextContent(documentElement, "SignatureValue");
        if (timeLimitStart != null && (timeLimitEnd == null || timeLimitStart.getTime() > timeLimitEnd.getTime()) || usingUserLimit < 0 || transactionLimit < 0) {
            throw new InvalidLicenceException(551);
        }
        return new DefaultLicenceInformation(licenceID, customerID, distributorID, licenceType, licensee, mailAddresses, version, activation, timeLimitStart, timeLimitEnd, transactionLimit, usingUserLimit, ipAddress, ipMask, typeLimit, isWebClientEnabled, isEscalationEnabled, products, isProcessFlexibilityEnabled, processFlexibilityTypes, isRuntimeFlexibilityEnabled, runtimeFlexibilityTypes, additions, licenceDigest, licenceSignature, stringDoc);
    }

    static ActivationData verifyAndGetActivation(InputStream activation, LicenceInformation licence) throws InvalidLicenceException {
        ArgChecks.checkForNull(activation, "activation");
        ArgChecks.checkForNull(licence, "licence");
        ActivationData ret = null;
        return ret;
    }

    static boolean verifyActivation(ActivationData activation, LicenceInformation licence) {
        ArgChecks.checkForNull(activation, "activation");
        ArgChecks.checkForNull(licence, "licence");
        return activation.getLicenceID() == licence.getLicenceID();
    }

    private static Map<String, Boolean> getProducts(Element root) {
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        Element products = LicenceTools.getFirstElementWithTagname(root, "products");
        Element product = XMLHelperTools.getElement(products.getFirstChild());
        do {
            res.put(product.getTextContent(), product.getAttribute("enabled").equalsIgnoreCase("yes"));
        } while ((product = XMLHelperTools.getElement(product.getNextSibling())) != null);
        return res;
    }

    private static String[] getMailAddresses(Element root) {
        Element addresses = LicenceTools.getFirstElementWithTagname(root, "mailAddresses");
        if (addresses == null) {
            return null;
        }
        LinkedList<String> res = new LinkedList<String>();
        Element address = XMLHelperTools.getElement(addresses.getFirstChild());
        do {
            res.add(address.getTextContent());
        } while ((address = XMLHelperTools.getElement(address.getNextSibling())) != null);
        return res.toArray(new String[res.size()]);
    }

    private static Map<String, String> getAdditions(Element root) {
        HashMap<String, String> res = new HashMap<String, String>();
        Element additions = LicenceTools.getFirstElementWithTagname(root, "additions");
        if (additions == null) {
            return new HashMap<String, String>();
        }
        Element addition = XMLHelperTools.getElement(additions.getFirstChild());
        do {
            res.put(addition.getAttribute("name"), addition.getTextContent());
        } while ((addition = XMLHelperTools.getElement(addition.getNextSibling())) != null);
        return res;
    }

    private static boolean getElementsEnabledAttrib(Element root, String tagName) {
        Element element = LicenceTools.getFirstElementWithTagname(root, tagName);
        String enabledString = element.getAttribute("enabled");
        return enabledString.equalsIgnoreCase("yes");
    }

    private static String[] getTypeLimit(Element root) {
        Element types = LicenceTools.getFirstElementWithTagname(root, "processTypes");
        if (types == null) {
            return null;
        }
        LinkedList<String> res = new LinkedList<String>();
        Element type = XMLHelperTools.getElement(types.getFirstChild());
        do {
            res.add(type.getTextContent());
        } while ((type = XMLHelperTools.getElement(type.getNextSibling())) != null);
        return res.toArray(new String[res.size()]);
    }
}

