/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.mail;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.mail.EmailAttachment;
import de.aristaflow.adept2.base.mail.EmailToolkit;
import de.aristaflow.adept2.base.mail.MailService;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.mail.EmailException;

@ConfigurationDescription(properties={@Property(name="From", type=Property.Type.STRING, description="The sender used for sending mails.", isRequired=true), @Property(name="Host", type=Property.Type.STRING, description="The host name of the SMTP server.", isRequired=true), @Property(name="Port", type=Property.Type.INT, description="The port for of the SMTP server.", isRequired=false, defaultValue="0"), @Property(name="UseTLS", type=Property.Type.BOOLEAN, description="Whether TLS should be used for the connection to the SMTP server.", isRequired=false, defaultValue="false"), @Property(name="UseSSL", type=Property.Type.BOOLEAN, description="Whether SSL should be used for the connection to the SMTP server.", isRequired=false, defaultValue="false"), @Property(name="Overtrustful", type=Property.Type.BOOLEAN, description="Whether every certificate will be trusted.", isRequired=false, defaultValue="false"), @Property(name="User", type=Property.Type.STRING, description="The user name for the SMTP server.", isRequired=false), @Property(name="Password", type=Property.Type.STRING, description="The password for the SMTP server.", isRequired=false)})
public class SimpleMailService
extends AbstractADEPT2Service
implements MailService {
    public static final String CFG_FROM = "From";
    public static final String CFG_HOSTNAME = "Host";
    public static final String CFG_SMTPPORT = "Port";
    public static final String CFG_USETLS = "UseTLS";
    public static final String CFG_USESSL = "UseSSL";
    public static final String CFG_OVERTRUSTFUL = "Overtrustful";
    public static final String CFG_USERNAME = "User";
    public static final String CFG_PASSWORD = "Password";
    private final String mailFrom;
    private final String mailHost;
    private final int smtpPort;
    private final String mailUsername;
    private final String mailPassword;
    private final boolean useTLS;
    private final boolean useSSL;
    private boolean overtrustful;

    public SimpleMailService(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.mailFrom = configuration.getString(CFG_FROM);
        this.mailHost = configuration.getString(CFG_HOSTNAME);
        this.smtpPort = configuration.getInt(CFG_SMTPPORT);
        this.useTLS = configuration.getBoolean(CFG_USETLS);
        this.useSSL = configuration.getBoolean(CFG_USESSL);
        this.overtrustful = configuration.getBoolean(CFG_OVERTRUSTFUL);
        this.mailUsername = configuration.getString(CFG_USERNAME);
        try {
            this.mailPassword = ConfigurationTools.parsePassword(configuration, CFG_PASSWORD);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("The password could not be parsed! Maybe it is not set.", e);
        }
    }

    @Override
    public void sendMail(String to, String subject, String body) throws EmailException {
        this.internalSendMail(this.mailFrom, new String[]{to}, null, null, subject, body, null);
    }

    @Override
    public void sendMail(String from, String to, String subject, String body) throws EmailException {
        this.internalSendMail(from, new String[]{to}, null, null, subject, body, null);
    }

    @Override
    public void sendMail(String from, String to, String subject, String body, List<EmailAttachment> attachments) throws EmailException {
        this.internalSendMail(from, new String[]{to}, null, null, subject, body, attachments);
    }

    @Override
    public void sendMail(String[] to, String[] cc, String[] bcc, String subject, String body, List<EmailAttachment> attachments) throws EmailException {
        this.internalSendMail(this.mailFrom, to, cc, bcc, subject, body, attachments);
    }

    @Override
    public void sendMail(String from, String[] to, String[] cc, String[] bcc, String subject, String body, List<EmailAttachment> attachments) throws EmailException {
        this.internalSendMail(from, to, cc, bcc, subject, body, attachments);
    }

    private void internalSendMail(String from, String[] to, String[] cc, String[] bcc, String subject, String body, List<EmailAttachment> attachments) throws EmailException {
        EmailToolkit.sendMail(from, to, cc, bcc, subject, body, attachments, this.mailHost, this.smtpPort, this.mailUsername, this.mailPassword, this.useTLS, this.useSSL, this.overtrustful);
    }
}

