/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.mailservice.simplemailservice;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.mail.EmailAttachment;
import de.aristaflow.adept2.base.mail.EmailToolkit;
import de.aristaflow.adept2.base.mail.SimpleMailService;
import de.aristaflow.adept2.base.mailservice.MailService;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.mail.SerialisableAttachment;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.types.Pair;
import de.aristaflow.adept2.util.types.SerialisablePair;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.mail.ByteArrayDataSource;

@ConfigurationDescription(properties={@Property(name="From", type=Property.Type.STRING, description="The sender used for sending mails.", isRequired=true), @Property(name="Host", type=Property.Type.STRING, description="The host name of the SMTP server.", isRequired=true), @Property(name="Port", type=Property.Type.INT, description="The port for of the SMTP server.", isRequired=false, defaultValue="0"), @Property(name="UseTLS", type=Property.Type.BOOLEAN, description="Whether TLS should be used for the connection to the SMTP server.", isRequired=false, defaultValue="false"), @Property(name="UseSSL", type=Property.Type.BOOLEAN, description="Whether SSL should be used for the connection to the SMTP server.", isRequired=false, defaultValue="false"), @Property(name="Overtrustful", type=Property.Type.BOOLEAN, description="Whether every certificate will be trusted.", isRequired=false, defaultValue="false"), @Property(name="User", type=Property.Type.STRING, description="The user name for the SMTP server.", isRequired=false), @Property(name="Password", type=Property.Type.STRING, description="The password for the SMTP server.", isRequired=false)})
public class BaseMailService
extends AbstractADEPT2Service
implements MailService {
    protected final de.aristaflow.adept2.base.mail.MailService sms;

    public BaseMailService(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.sms = new SimpleMailService(configuration, registry);
    }

    @Override
    public void init(URI[] serviceURIs) throws AbortServiceException {
        super.init(serviceURIs);
        this.sms.init(serviceURIs);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.sms.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.sms.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.sms.emergencyShutdown();
    }

    @Override
    public Map<String, Pair<Throwable, Boolean>> sendMail(SessionToken session, List<String> to, String subject, String body) {
        super.sessionActive(session);
        try {
            ArgChecks.checkForEmpty(to, "to");
            ArgChecks.checkForNull(subject, "subject");
            ArgChecks.checkForNull(body, "body");
            HashMap<String, Pair<Throwable, Boolean>> ret = new HashMap<String, Pair<Throwable, Boolean>>();
            for (String recipient : to) {
                try {
                    this.sms.sendMail(recipient, subject, body);
                }
                catch (Throwable t) {
                    SerialisablePair<Throwable, Boolean> prob = new SerialisablePair<Throwable, Boolean>(t, EmailToolkit.checkException(t));
                    ret.put(recipient, prob);
                }
            }
            HashMap<String, Pair<Throwable, Boolean>> hashMap = ret;
            return hashMap;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Map<String, Pair<Throwable, Boolean>> sendMail(SessionToken session, String from, List<String> to, String subject, String body) {
        super.sessionActive(session);
        try {
            ArgChecks.checkForEmpty(from, "from");
            ArgChecks.checkForEmpty(to, "to");
            ArgChecks.checkForNull(subject, "subject");
            ArgChecks.checkForNull(body, "body");
            HashMap<String, Pair<Throwable, Boolean>> ret = new HashMap<String, Pair<Throwable, Boolean>>();
            for (String recipient : to) {
                try {
                    this.sms.sendMail(from, recipient, subject, body);
                }
                catch (Throwable t) {
                    SerialisablePair<Throwable, Boolean> prob = new SerialisablePair<Throwable, Boolean>(t, EmailToolkit.checkException(t));
                    ret.put(recipient, prob);
                }
            }
            HashMap<String, Pair<Throwable, Boolean>> hashMap = ret;
            return hashMap;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Pair<Throwable, Boolean> sendMail(SessionToken session, List<String> to, List<String> cc, List<String> bcc, String subject, String body, Map<String, String> addAttributes) {
        super.sessionActive(session);
        try {
            ArgChecks.checkForEmpty(to, "to");
            ArgChecks.checkForNull(subject, "subject");
            ArgChecks.checkForNull(body, "body");
            SerialisablePair<Throwable, Boolean> ret = null;
            try {
                this.sms.sendMail(to.toArray(new String[to.size()]), cc.toArray(new String[cc.size()]), bcc.toArray(new String[bcc.size()]), subject, body, null);
            }
            catch (Throwable t) {
                ret = new SerialisablePair<Throwable, Boolean>(t, EmailToolkit.checkException(t));
            }
            SerialisablePair<Throwable, Boolean> serialisablePair = ret;
            return serialisablePair;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Map<String, Pair<Throwable, Boolean>> sendMail(SessionToken session, List<String> to, String subject, String body, Map<String, String> addAttributes) {
        return this.sendMail(session, to, subject, body);
    }

    @Override
    public Pair<Throwable, Boolean> sendMail(SessionToken session, String from, List<String> to, List<String> cc, List<String> bcc, String subject, String body) {
        return this.sendMail(session, from, to, cc, bcc, subject, body, null, null);
    }

    @Override
    public Pair<Throwable, Boolean> sendMail(SessionToken session, String from, List<String> to, List<String> cc, List<String> bcc, String subject, String body, List<SerialisableAttachment> attachments, Map<String, String> addAttributes) {
        super.sessionActive(session);
        try {
            ArgChecks.checkForEmpty(to, "to");
            ArgChecks.checkForNull(subject, "subject");
            ArgChecks.checkForNull(body, "body");
            SerialisablePair<Throwable, Boolean> ret = null;
            IOException ioet = null;
            List<EmailAttachment> emAttachs = null;
            try {
                emAttachs = this.convertAttachments(attachments);
            }
            catch (IOException ioe) {
                ioet = ioe;
            }
            try {
                if (ioet == null) {
                    this.sms.sendMail(from, to.toArray(new String[to.size()]), cc.toArray(new String[cc.size()]), bcc.toArray(new String[bcc.size()]), subject, body, emAttachs);
                } else {
                    ret = new SerialisablePair<IOException, Boolean>(ioet, EmailToolkit.checkException(ioet));
                }
            }
            catch (Throwable t) {
                ret = new SerialisablePair<Throwable, Boolean>(t, EmailToolkit.checkException(t));
            }
            SerialisablePair<Throwable, Boolean> serialisablePair = ret;
            return serialisablePair;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Map<String, Pair<Throwable, Boolean>> sendMail(SessionToken session, String from, List<String> to, String subject, String body, List<SerialisableAttachment> attachments, Map<String, String> addAttributes) {
        super.sessionActive(session);
        try {
            ArgChecks.checkForEmpty(from, "from");
            ArgChecks.checkForEmpty(to, "to");
            ArgChecks.checkForNull(subject, "subject");
            HashMap<String, Pair<Throwable, Boolean>> ret = new HashMap<String, Pair<Throwable, Boolean>>();
            IOException ioet = null;
            List<EmailAttachment> emAttachs = null;
            try {
                emAttachs = this.convertAttachments(attachments);
            }
            catch (IOException ioe) {
                ioet = ioe;
            }
            if (body == null || body.length() < 1) {
                body = "<No body>";
            }
            for (String recipient : to) {
                try {
                    if (ioet == null) {
                        if (emAttachs == null) {
                            this.sms.sendMail(from, recipient, subject, body);
                            continue;
                        }
                        this.sms.sendMail(from, recipient, subject, body, emAttachs);
                        continue;
                    }
                    SerialisablePair<IOException, Boolean> prob = new SerialisablePair<IOException, Boolean>(ioet, EmailToolkit.checkException(ioet));
                    ret.put(recipient, prob);
                }
                catch (Throwable t) {
                    SerialisablePair<Throwable, Boolean> prob = new SerialisablePair<Throwable, Boolean>(t, EmailToolkit.checkException(t));
                    ret.put(recipient, prob);
                }
            }
            HashMap<String, Pair<Throwable, Boolean>> hashMap = ret;
            return hashMap;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Map<String, Pair<Throwable, Boolean>> sendMail(SessionToken session, String from, List<String> to, String subject, String body, List<SerialisableAttachment> attachments) {
        return this.sendMail(session, from, to, subject, body, attachments, null);
    }

    protected List<EmailAttachment> convertAttachments(List<SerialisableAttachment> attachments) throws IOException {
        ArrayList<EmailAttachment> ret = null;
        if (attachments != null && attachments.size() > 0) {
            ret = new ArrayList<EmailAttachment>(attachments.size());
            for (SerialisableAttachment att : attachments) {
                EmailAttachment ea = new EmailAttachment(att.getName(), att.getDescription());
                ea.setData((DataSource)new ByteArrayDataSource(att.getContent(), att.getContentType()));
                ret.add(ea);
            }
        }
        return ret;
    }
}

