/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescriptionTools;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.configuration.IllegalConfigurationDescriptionException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractRegistry
extends AbstractADEPT2Service {
    protected final Configuration configuration;
    protected ConfigurationManager<?> configurationManager;
    protected Map<String, Class<?>> componentInterfaces;
    protected Map<String, InstanceInformation> declaredInstances;
    protected Map<ClassLoader, Map<String, Object>> singletonInstances;
    private Map<String, Lock> creationLock;
    private static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$base$registry$AbstractRegistry$InstantiationMode;

    protected AbstractRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.renewConfiguration(this.configuration);
    }

    @Override
    public void shutdown() {
        super.signalShutdown(false);
        super.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        super.signalShutdown(true);
        super.emergencyShutdown();
    }

    protected void renewConfiguration(Configuration configuration) throws ConfigurationException {
        this.componentInterfaces = new HashMap();
        this.declaredInstances = new HashMap<String, InstanceInformation>();
        this.singletonInstances = new HashMap<ClassLoader, Map<String, Object>>();
        this.creationLock = new HashMap<String, Lock>();
        this.creationLock = Collections.synchronizedMap(this.creationLock);
        this.configurationManager = ConfigurationManager.create(configuration);
        this.readComponentTypes(configuration);
        this.readAnonymousInstances(configuration);
        this.readNamedInstanceInformation(configuration);
    }

    private void readComponentTypes(Configuration configuration) throws ConfigurationException {
        HashSet<String> propertyNames = new HashSet<String>();
        Iterator i = configuration.getKeys("Components");
        while (i.hasNext()) {
            propertyNames.add((String)i.next());
        }
        for (String propertyName : propertyNames) {
            Class<?> componentClass;
            String componentName = propertyName.substring("Components".length() + 1);
            if (this.componentInterfaces.containsKey(componentName)) {
                String message = String.format("QA Notice: Component type '%1$s' registered twice.", componentName);
                this.logger.warning(message);
                continue;
            }
            String componentClassName = configuration.getString(propertyName);
            if (ConfigurationTools.stringValid(componentClassName)) {
                try {
                    componentClass = Class.forName(componentClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String message = String.format("(Super) class or interface '%1$s' of component '%2$s' not in classpath!", componentClassName, componentName);
                    this.logger.severe(message);
                    throw new ConfigurationException(message);
                }
            } else {
                String message = String.format("(Super) class or interface '%1$s' of component '%2$s' not set in configuration!", componentClassName, componentName);
                this.logger.severe(message);
                throw new ConfigurationException(message);
            }
            this.componentInterfaces.put(componentName, componentClass);
            this.logger.info(String.format("Added component '%1$s' with (super) class or interface '%2$s'.", componentName, componentClassName));
        }
    }

    private void readAnonymousInstances(Configuration configuration) throws ConfigurationException {
        for (String componentTypeName : this.componentInterfaces.keySet()) {
            String key = String.format("%s.%s", "Instances", componentTypeName);
            if (ConfigurationTools.propertyValuePresent(configuration, key)) continue;
            this.readMetaConfiguration(configuration, componentTypeName, componentTypeName);
        }
    }

    private void readNamedInstanceInformation(Configuration configuration) throws ConfigurationException {
        Set<String> componentTypeNames = this.componentInterfaces.keySet();
        HashSet<String> propertyNames = new HashSet<String>();
        Iterator i = configuration.getKeys("Instances");
        while (i.hasNext()) {
            propertyNames.add((String)i.next());
        }
        for (String propertyName : propertyNames) {
            String componentTypeName = propertyName.substring("Instances".length() + 1);
            if (!componentTypeNames.contains(componentTypeName)) {
                String message = String.format("QA Notice: Instances declared for '%1$s' but the type itself is not registered.", componentTypeName);
                this.logger.warning(message);
                continue;
            }
            List simpleNames = configuration.getList(propertyName);
            Class<?> componentType = this.componentInterfaces.get(componentTypeName);
            if (AbstractRegistry.class.isAssignableFrom(componentType)) {
                String message = String.format("QA Notice: There are instances declared for the registry type '%1$s'. Registries must not have instances and they have to be SINGLETON. The instance declaration is ignored.", componentTypeName);
                this.logger.warning(message);
                this.readMetaConfiguration(configuration, componentTypeName, componentTypeName);
                continue;
            }
            for (String simpleName : simpleNames) {
                this.readMetaConfiguration(configuration, componentTypeName, simpleName);
            }
        }
    }

    protected void readMetaConfiguration(Configuration registryConfiguration, String componentType, String simpleInstanceName) throws ConfigurationException {
        String instanceName = AbstractRegistry.getHierarchicalInstanceName(componentType, simpleInstanceName);
        InstantiationMode instantiationMode = this.getInstantiationMode(componentType, simpleInstanceName, registryConfiguration);
        String key = String.valueOf(simpleInstanceName) + "." + "Implementation";
        if (!ConfigurationTools.propertyValuePresent(this.configuration, key)) {
            String message = String.format("No implementation for instance '%1$s' configured!", simpleInstanceName);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        String implementingClassName = registryConfiguration.getString(key);
        this.checkImplementingClassConfiguration(instanceName, implementingClassName);
        InstanceInformation instanceInformation = new InstanceInformation(this.getComponentType(instanceName), instantiationMode, implementingClassName);
        this.declaredInstances.put(instanceName, instanceInformation);
        this.logger.fine(String.format("Instance '%1$s' declared with mode '%2$s'.", instanceName, instantiationMode.name()));
    }

    protected void checkSupertype(String instanceName, Class<?> superType, Class<?> subType) throws ConfigurationException {
        if (!superType.isAssignableFrom(subType)) {
            String message = String.format("The sub type ('%1$s') of instance '%3$s' does not have the required interface / does not extend the required class '%2$s'!", subType.getName(), superType.getSimpleName(), instanceName);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
    }

    protected void checkInstanceConfiguration(Configuration instanceConfiguration, String instanceName, Class<?> implementationClass) throws ConfigurationException {
        if (implementationClass != null) {
            ConfigurationDescriptionTools.validateConfigurationDescription(implementationClass);
            ConfigurationDescriptionTools.validateConfiguration(instanceConfiguration, implementationClass, instanceName);
        }
    }

    protected void checkImplementingClassConfiguration(String instanceName, String implementingClassName) throws ConfigurationException {
        String simpleInstanceName = AbstractRegistry.getSimpleInstanceName(instanceName);
        String componentType = this.getComponentType(instanceName);
        try {
            Class<?> cls = Class.forName(implementingClassName);
            this.checkSupertype(instanceName, this.getInterfaceForComponentType(componentType), cls);
            Configuration instanceConfiguration = this.configurationManager.getConfiguration(simpleInstanceName, componentType);
            this.checkInstanceConfiguration(instanceConfiguration, instanceName, cls);
        }
        catch (ClassNotFoundException cnfe) {
            String message = String.format("Could not find the specified implementation '%1$s' (for interface '%2$s') with the registry classloader.", implementingClassName, instanceName);
            this.logger.log(Level.INFO, message, cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = String.format("Could load all classes for the specified implementation '%1$s' (for interface '%2$s') with the registry classloader.", implementingClassName, instanceName);
            this.logger.log(Level.INFO, message, ncdfe);
        }
    }

    protected InstantiationMode getInstantiationMode(String componentType, String simpleInstanceName, Configuration registryConfiguration) {
        InstantiationMode ret = InstantiationMode.SINGLETON;
        try {
            String propertyValue = registryConfiguration.getString(String.valueOf(simpleInstanceName) + "." + "InstantiationMode");
            if (!ConfigurationTools.stringValid(propertyValue)) {
                propertyValue = registryConfiguration.getString(String.valueOf(componentType) + "." + "InstantiationMode");
            }
            if (propertyValue != null) {
                ret = InstantiationMode.valueOf(propertyValue.toUpperCase(Locale.ENGLISH));
            } else {
                String message = String.format("Instantiation mode of '%1$s' ('%2$s') not set, using SINGLETON mode instead.", simpleInstanceName, componentType);
                this.logger.info(message);
            }
        }
        catch (IllegalArgumentException iae) {
            String message = String.format("Instantiation mode of '%1$s' ('%2$s') set to an illegal value, using SINGLETON mode instead.", simpleInstanceName, componentType);
            this.logger.log(Level.INFO, message, iae);
        }
        return ret;
    }

    public static String getHierarchicalInstanceName(String componentType, String simpleName) {
        return String.format("/%s/%s", componentType, simpleName);
    }

    public static String getSimpleInstanceName(String instanceName) {
        String[] names = instanceName.split("/");
        if (names.length < 3) {
            String message = String.format("The string '%s' is not a valid hierarchical instance name, check your configuration.", instanceName);
            throw new IllegalArgumentException(message);
        }
        return names[2];
    }

    public static String getFormattedSignature(Class<?>[] parameterTypes) {
        StringBuilder constructorDescription = new StringBuilder("(");
        Class<?>[] classArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            constructorDescription.append(parameterType.getSimpleName());
            constructorDescription.append(",");
            ++n2;
        }
        constructorDescription.delete(constructorDescription.length() - 1, constructorDescription.length());
        constructorDescription.append(")");
        return constructorDescription.toString();
    }

    public String getComponentType(String instanceName) {
        String[] names = instanceName.split("/");
        if (names.length < 3) {
            String msg = String.format("The string '%s' is not a valid hierarchical instance name, check your configuration.", instanceName);
            throw new IllegalArgumentException(msg);
        }
        return instanceName.split("/")[1];
    }

    protected InstanceInformation getInstanceInformation(String instanceName) throws ConfigurationException {
        InstanceInformation instanceInformation = this.declaredInstances.get(instanceName);
        if (instanceInformation == null) {
            String message = String.format(String.format("Instance '%s' not declared properly. Check configuration file.", instanceName), new Object[0]);
            throw new ConfigurationException(message);
        }
        return instanceInformation;
    }

    protected <T> T getObjectForInstanceName(String instanceName, Class<T> componentType) throws ConfigurationException {
        return this.getObjectForInstanceName(instanceName, componentType, new Class[0], new Object[0]);
    }

    protected <T> T getObjectForInstanceName(String instanceName, Class<T> componentType, Class<?>[] additionalParameterTypes, Object[] additionalParameterValues) throws ConfigurationException {
        InstanceInformation instanceInformation = this.getInstanceInformation(instanceName);
        Configuration instanceConfiguration = this.configurationManager.getConfiguration(AbstractRegistry.getSimpleInstanceName(instanceName), instanceInformation.componentType);
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 1];
        parameterTypes[0] = Configuration.class;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 1, additionalParameterTypes.length);
        Object[] parameterValues = new Object[additionalParameterTypes.length + 1];
        parameterValues[0] = instanceConfiguration;
        System.arraycopy(additionalParameterValues, 0, parameterValues, 1, additionalParameterValues.length);
        return this.getArbitrarilyNamedObject(instanceName, componentType, this.getClass().getClassLoader(), parameterTypes, parameterValues, instanceInformation.instantiationMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected <T> T getArbitrarilyNamedObject(String instanceName, Class<T> componentType, ClassLoader classLoader, Class<?>[] parameterTypes, Object[] parameterValues, InstantiationMode instantiationMode) throws ConfigurationException {
        instanceInformation = this.getInstanceInformation(instanceName);
        singletonLock = null;
        registeredComponentType = this.componentInterfaces.get(instanceInformation.componentType);
        if (registeredComponentType == null) {
            message = String.format("Component type '%1$s' is not defined. Check configuration file.", new Object[]{instanceInformation.componentType});
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        this.checkSupertype(instanceName, componentType, registeredComponentType);
        switch (AbstractRegistry.$SWITCH_TABLE$de$aristaflow$adept2$base$registry$AbstractRegistry$InstantiationMode()[instantiationMode.ordinal()]) {
            case 3: {
                message = String.format("The instance '%1$s' has been requested but the instantiation mode is set to OFF!", new Object[]{instanceName});
                this.logger.severe(message);
                throw new ConfigurationException(message);
            }
            case 1: {
                var11_13 = this.creationLock;
                synchronized (var11_13) {
                    singletonLock = this.creationLock.get(instanceName);
                    if (singletonLock == null) {
                        singletonLock = new ReentrantLock();
                        this.creationLock.put(instanceName, singletonLock);
                    }
                }
                singletonLock.lock();
                singletonFound = true;
                try {
                    if (!this.singletonInstances.containsKey(classLoader) || !(loadedSingletons = this.singletonInstances.get(classLoader)).containsKey(instanceName)) ** GOTO lbl45
                    var13_16 = componentType.cast(loadedSingletons.get(instanceName));
                    if (!singletonFound) ** GOTO lbl43
                    this.creationLock.remove(instanceName);
                }
                catch (Throwable var12_18) {
                    if (singletonFound) {
                        this.creationLock.remove(instanceName);
                        singletonLock.unlock();
                        singletonLock = null;
                    }
                    throw var12_18;
                }
                singletonLock.unlock();
                singletonLock = null;
lbl43:
                // 2 sources

                return var13_16;
lbl45:
                // 2 sources

                singletonFound = false;
                if (!singletonFound) break;
                this.creationLock.remove(instanceName);
                singletonLock.unlock();
                singletonLock = null;
                break;
            }
        }
        try {
            try {
                implementationClass = classLoader.loadClass(instanceInformation.getImplementationClass());
            }
            catch (ClassNotFoundException cnfe) {
                msg = String.format("Could not find the specified implementation '%1$s' (for registered interface '%2$s').", new Object[]{instanceInformation.implementationClass, componentType.getSimpleName()});
                throw new ConfigurationException(msg, cnfe);
            }
            instance = this.createInstanceForInterface(implementationClass, componentType, parameterTypes, parameterValues);
            if (instantiationMode.equals((Object)InstantiationMode.SINGLETON)) {
                if (this.singletonInstances.containsKey(classLoader)) {
                    loadedSingletons = this.singletonInstances.get(classLoader);
                } else {
                    loadedSingletons = new HashMap<K, V>();
                    this.singletonInstances.put(classLoader, loadedSingletons);
                }
                loadedSingletons.put(instanceName, instance);
            }
        }
        finally {
            if (singletonLock != null) {
                this.creationLock.remove(instanceName);
                singletonLock.unlock();
            }
        }
        return (T)instance;
    }

    protected final <T> T createInstanceForInterface(Class<? extends T> implementationClass, Class<T> componentInterface, Class<?>[] parameterTypes, Object[] parameterValues) throws ConfigurationException {
        T instance;
        Constructor<Object> constructor;
        assert (parameterTypes.length == parameterValues.length);
        String messageTemplate = String.format(" while trying to get the required constructor '%1$s' for '%2$s'.", AbstractRegistry.getFormattedSignature(parameterTypes), implementationClass.getName());
        try {
            constructor = implementationClass.getConstructor(parameterTypes);
        }
        catch (SecurityException se) {
            this.logger.log(Level.SEVERE, "SecurityException" + messageTemplate, se);
            throw new ConfigurationException("SecurityException" + messageTemplate, se);
        }
        catch (NoSuchMethodException nsme) {
            this.logger.log(Level.FINE, "NoSuchMethodException" + messageTemplate + " Looking for an appropriate constructor.", nsme);
            constructor = this.getAppropriateConstructor(implementationClass, parameterTypes);
        }
        if (constructor != null) {
            try {
                instance = constructor.newInstance(parameterValues);
            }
            catch (IllegalAccessException iae) {
                String message = String.format("An IllegalAccessException occurred while trying to instantiate implementation '%1$s' for interface '%2$s'!\nThe constructor '%1$s%3$s' needs public access.", implementationClass.getName(), componentInterface.getSimpleName(), AbstractRegistry.getFormattedSignature(parameterTypes));
                this.logger.log(Level.SEVERE, message, iae);
                throw new ConfigurationException(message, iae);
            }
            catch (IllegalArgumentException iae) {
                String message = String.format("An IllegalArgumentException occurred while calling the constructor '%1$s%3$s' for interface '%2$s'!\nPlease refer to http://java.sun.com/j2se/1.5.0/docs/api/java/lang/reflect/Constructor.html#newInstance(java.lang.Object...) for further information.", implementationClass.getName(), componentInterface.getSimpleName(), AbstractRegistry.getFormattedSignature(parameterTypes));
                this.logger.log(Level.SEVERE, message, iae);
                throw new ConfigurationException(message, iae);
            }
            catch (InstantiationException ie) {
                String message = String.format("InstantiationException while trying to instantiate implementation '%1$s' for interface '%2$s'!\nConfigured interface or abstract class? Compile errors? No usable constructor?", implementationClass.getName(), componentInterface.getSimpleName());
                this.logger.log(Level.SEVERE, message, ie);
                throw new ConfigurationException(message, ie);
            }
            catch (InvocationTargetException ite) {
                Throwable wrappedException = ite.getCause();
                if (wrappedException instanceof ConfigurationException) {
                    throw (ConfigurationException)wrappedException;
                }
                if (wrappedException instanceof IllegalConfigurationDescriptionException) {
                    throw (IllegalConfigurationDescriptionException)wrappedException;
                }
                String message = String.format("An exception occurred while calling the constructor '%1$s%3$s' for interface '%2$s'.", implementationClass.getName(), componentInterface.getSimpleName(), AbstractRegistry.getFormattedSignature(parameterTypes));
                this.logger.log(Level.SEVERE, message, wrappedException);
                throw new ConfigurationException(message, wrappedException);
            }
        } else {
            String message = String.format("Public constructor '%1$s%2$s' not found.", implementationClass.getName(), AbstractRegistry.getFormattedSignature(parameterTypes));
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        return componentInterface.cast(instance);
    }

    public Class<?> getInterfaceForComponentType(String componentType) throws ConfigurationException {
        if (!this.componentInterfaces.containsKey(componentType)) {
            String message = String.format("Component type '%s' not declared! Check configuration!", componentType);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        return this.componentInterfaces.get(componentType);
    }

    protected Constructor<?> getAppropriateConstructor(Class<?> cls, Class<?>[] parameterTypes) {
        Constructor<?>[] constructor = cls.getConstructors();
        int[] distance = new int[constructor.length];
        int i = 0;
        while (i < constructor.length) {
            if (constructor[i].getParameterTypes().length == parameterTypes.length) {
                distance[i] = 0;
                int j = 0;
                while (j < parameterTypes.length) {
                    int currrentDistance = AbstractRegistry.distance(constructor[i].getParameterTypes()[j], parameterTypes[j]);
                    if (currrentDistance == Integer.MAX_VALUE) {
                        distance[i] = Integer.MAX_VALUE;
                        break;
                    }
                    int n = i;
                    distance[n] = distance[n] + currrentDistance;
                    ++j;
                }
            } else {
                distance[i] = Integer.MAX_VALUE;
            }
            ++i;
        }
        int smallest = Integer.MAX_VALUE;
        int index = -1;
        int twice = -1;
        int i2 = 0;
        while (i2 < constructor.length) {
            if (distance[i2] < smallest) {
                smallest = distance[i2];
                index = i2;
            } else if (distance[i2] == smallest) {
                twice = smallest;
            }
            ++i2;
        }
        if (twice == smallest && index > 0) {
            this.logger.warning(String.format("Found ambiguous constructors, that is two constructors having the same distance from the parameter types '%s'! Choosing arbitrarily the constructor '%s'.", Arrays.toString(parameterTypes), constructor[index]));
        }
        return index > -1 ? constructor[index] : null;
    }

    protected static int distance(Class<?> sup, Class<?> sub) {
        if (sub == null || sup == null || !sup.isAssignableFrom(sub)) {
            return Integer.MAX_VALUE;
        }
        if (sup.equals(sub)) {
            return 0;
        }
        if (sup.isInterface()) {
            Class<?>[] ifacesOnly = sub.getInterfaces();
            Class[] ifaces = new Class[ifacesOnly.length + 1];
            ifaces[0] = sub.getSuperclass();
            System.arraycopy(ifacesOnly, 0, ifaces, 1, ifacesOnly.length);
            int[] distance = new int[ifaces.length];
            int i = 0;
            while (i < ifaces.length) {
                int currDistance = AbstractRegistry.distance(sup, ifaces[i]);
                if (currDistance != Integer.MAX_VALUE && sub.isInterface()) {
                    currDistance += 2;
                }
                distance[i] = ++currDistance;
                ++i;
            }
            int smallest = Integer.MAX_VALUE;
            int i2 = 0;
            while (i2 < distance.length) {
                if (distance[i2] < smallest) {
                    smallest = distance[i2];
                }
                ++i2;
            }
            return smallest;
        }
        return AbstractRegistry.distance(sup, sub.getSuperclass()) + 2;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$base$registry$AbstractRegistry$InstantiationMode() {
        if ($SWITCH_TABLE$de$aristaflow$adept2$base$registry$AbstractRegistry$InstantiationMode != null) {
            return $SWITCH_TABLE$de$aristaflow$adept2$base$registry$AbstractRegistry$InstantiationMode;
        }
        int[] nArray = new int[InstantiationMode.values().length];
        try {
            nArray[InstantiationMode.MULTIPLE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InstantiationMode.OFF.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InstantiationMode.SINGLETON.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$aristaflow$adept2$base$registry$AbstractRegistry$InstantiationMode = nArray;
        return nArray;
    }

    public static class InstanceInformation {
        protected final String componentType;
        protected final InstantiationMode instantiationMode;
        protected final String implementationClass;

        protected InstanceInformation(String componentType, InstantiationMode instantiationMode, String implementationClass) {
            this.componentType = componentType;
            this.instantiationMode = instantiationMode;
            this.implementationClass = implementationClass;
        }

        public String getImplementationClass() {
            return this.implementationClass;
        }
    }

    public static enum InstantiationMode {
        SINGLETON,
        MULTIPLE,
        OFF;

    }
}

