/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescriptionTools;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.registry.ServiceRegistry;
import de.aristaflow.adept2.base.registry.StandAloneFileConfigurationManager;
import de.aristaflow.adept2.base.security.AFCallbackHandler;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultSessionFactory;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import org.apache.commons.configuration.Configuration;

public abstract class BootstrapRegistry
extends ServiceRegistry {
    protected static volatile ConfigurationManager<?> rootConfigurationManager = null;
    protected static volatile BootstrapRegistry bootstrapRegistry = null;
    protected SecurityManager securityManager = new LocalSecurityManager();
    protected final String instanceName;

    protected BootstrapRegistry(Configuration rootConfiguration, String instanceName) throws ConfigurationException {
        super(rootConfiguration, null);
        ConfigurationDescriptionTools.validateConfigurationDescription(this.getClass());
        ConfigurationDescriptionTools.validateConfiguration(rootConfiguration, this.getClass(), instanceName);
        this.instanceName = instanceName;
    }

    protected void bootstrap() throws AbortServiceException {
        URI localURI = this.createLocalServiceURI(BootstrapRegistry.getHierarchicalInstanceName(this.instanceName, this.instanceName));
        this.bootstrap(localURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bootstrap(URI registryURI) throws AbortServiceException {
        Class<BootstrapRegistry> clazz = BootstrapRegistry.class;
        synchronized (BootstrapRegistry.class) {
            if (bootstrapRegistry == null) {
                this.init(new URI[]{registryURI});
                bootstrapRegistry = this;
                this.start();
                this.signalStart();
            } else if (bootstrapRegistry != this) {
                String msg = "The system has already been bootstrapped. You may not bootstrap it again!";
                throw new AbortServiceException(msg);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isTerminated() {
        return !this.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void shutdown() {
        if (!this.isActive() && this.isShutdown()) return;
        Class<BootstrapRegistry> clazz = BootstrapRegistry.class;
        synchronized (BootstrapRegistry.class) {
            super.shutdown();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            bootstrapRegistry = null;
            return;
        }
    }

    protected static ConfigurationManager<?> getRootConfigurationManager() throws ConfigurationException {
        return BootstrapRegistry.getRootConfiguration("ADEPT2.properties");
    }

    protected static synchronized ConfigurationManager<?> getRootConfiguration(String rootConfigurationFile) throws ConfigurationException {
        if (rootConfigurationManager == null) {
            rootConfigurationManager = StandAloneFileConfigurationManager.initialiseConfigurationManager(rootConfigurationFile);
        }
        return rootConfigurationManager;
    }

    @Override
    protected SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    private static class LocalSecurityManager
    implements SecurityManager {
        private final RSAPublicKey publicKey;
        private final SignedSecurityToken systemSecurity;
        private static final byte[] MODULUS;
        private static final byte[] PUBLIC_EXPONENT;
        private static final byte[] PRIVATE_EXPONENT;

        static {
            byte[] byArray = new byte[257];
            byArray[1] = -73;
            byArray[2] = -42;
            byArray[3] = -120;
            byArray[4] = -6;
            byArray[5] = 28;
            byArray[6] = 99;
            byArray[7] = 88;
            byArray[8] = 77;
            byArray[9] = -89;
            byArray[10] = -30;
            byArray[11] = 21;
            byArray[12] = -63;
            byArray[13] = -71;
            byArray[14] = 10;
            byArray[15] = -116;
            byArray[16] = -74;
            byArray[17] = 4;
            byArray[18] = -111;
            byArray[19] = -112;
            byArray[20] = 113;
            byArray[21] = 103;
            byArray[22] = 116;
            byArray[23] = 77;
            byArray[24] = -118;
            byArray[25] = 29;
            byArray[26] = 124;
            byArray[27] = 52;
            byArray[28] = 103;
            byArray[29] = 93;
            byArray[30] = -18;
            byArray[31] = 98;
            byArray[32] = 46;
            byArray[33] = 25;
            byArray[34] = -87;
            byArray[35] = -122;
            byArray[36] = 87;
            byArray[37] = -43;
            byArray[38] = -68;
            byArray[39] = -108;
            byArray[40] = -34;
            byArray[41] = 77;
            byArray[42] = 54;
            byArray[43] = 99;
            byArray[44] = 52;
            byArray[45] = -108;
            byArray[46] = -49;
            byArray[47] = -68;
            byArray[48] = -101;
            byArray[49] = 56;
            byArray[50] = 4;
            byArray[51] = 80;
            byArray[52] = 79;
            byArray[53] = 41;
            byArray[54] = -112;
            byArray[55] = 79;
            byArray[56] = 91;
            byArray[57] = -119;
            byArray[58] = 95;
            byArray[59] = -32;
            byArray[60] = -90;
            byArray[61] = -109;
            byArray[62] = 84;
            byArray[63] = -96;
            byArray[64] = 44;
            byArray[65] = -4;
            byArray[66] = 72;
            byArray[67] = -40;
            byArray[68] = 118;
            byArray[69] = -73;
            byArray[70] = -32;
            byArray[71] = 75;
            byArray[72] = 82;
            byArray[73] = 54;
            byArray[74] = 102;
            byArray[75] = 39;
            byArray[76] = -36;
            byArray[77] = 53;
            byArray[78] = -63;
            byArray[79] = -60;
            byArray[80] = 111;
            byArray[81] = 80;
            byArray[82] = 93;
            byArray[83] = -17;
            byArray[84] = -126;
            byArray[85] = 77;
            byArray[86] = -116;
            byArray[87] = -47;
            byArray[88] = -49;
            byArray[89] = 21;
            byArray[90] = -96;
            byArray[91] = 71;
            byArray[92] = -27;
            byArray[93] = 115;
            byArray[94] = -65;
            byArray[95] = 50;
            byArray[96] = -20;
            byArray[97] = 12;
            byArray[98] = 4;
            byArray[99] = 121;
            byArray[100] = 79;
            byArray[101] = 3;
            byArray[102] = 99;
            byArray[103] = -116;
            byArray[104] = -83;
            byArray[105] = -68;
            byArray[106] = -90;
            byArray[107] = -19;
            byArray[108] = -5;
            byArray[109] = -54;
            byArray[110] = 4;
            byArray[111] = -79;
            byArray[112] = 23;
            byArray[113] = -109;
            byArray[114] = 7;
            byArray[115] = -77;
            byArray[116] = 63;
            byArray[117] = -9;
            byArray[118] = -119;
            byArray[119] = 29;
            byArray[120] = 79;
            byArray[121] = -92;
            byArray[122] = 119;
            byArray[123] = 93;
            byArray[124] = 71;
            byArray[125] = 14;
            byArray[126] = -64;
            byArray[127] = -70;
            byArray[128] = 103;
            byArray[129] = -108;
            byArray[130] = 116;
            byArray[131] = 76;
            byArray[132] = -68;
            byArray[133] = -93;
            byArray[134] = 117;
            byArray[135] = -80;
            byArray[136] = -127;
            byArray[137] = 23;
            byArray[138] = -105;
            byArray[139] = 47;
            byArray[140] = -116;
            byArray[141] = 106;
            byArray[142] = 95;
            byArray[143] = -84;
            byArray[144] = -11;
            byArray[145] = 84;
            byArray[146] = 94;
            byArray[147] = 55;
            byArray[148] = -125;
            byArray[149] = 77;
            byArray[150] = 80;
            byArray[151] = -41;
            byArray[152] = 96;
            byArray[153] = 61;
            byArray[154] = 34;
            byArray[155] = -93;
            byArray[156] = -68;
            byArray[157] = 23;
            byArray[158] = 43;
            byArray[159] = 123;
            byArray[160] = 71;
            byArray[161] = -80;
            byArray[162] = 93;
            byArray[163] = 43;
            byArray[164] = -21;
            byArray[165] = 108;
            byArray[166] = -48;
            byArray[167] = 125;
            byArray[168] = 12;
            byArray[169] = 89;
            byArray[170] = 63;
            byArray[171] = 32;
            byArray[172] = -94;
            byArray[173] = 7;
            byArray[174] = 67;
            byArray[175] = -28;
            byArray[176] = 47;
            byArray[177] = -109;
            byArray[178] = 27;
            byArray[179] = 76;
            byArray[180] = -84;
            byArray[181] = -45;
            byArray[182] = -97;
            byArray[183] = -79;
            byArray[184] = -48;
            byArray[185] = 89;
            byArray[186] = 44;
            byArray[187] = -101;
            byArray[188] = 108;
            byArray[189] = -45;
            byArray[190] = -115;
            byArray[191] = -25;
            byArray[192] = 86;
            byArray[193] = -128;
            byArray[194] = 50;
            byArray[195] = 35;
            byArray[196] = -1;
            byArray[197] = 75;
            byArray[198] = -71;
            byArray[199] = -11;
            byArray[200] = 126;
            byArray[201] = 57;
            byArray[202] = -82;
            byArray[203] = 38;
            byArray[204] = 72;
            byArray[205] = -121;
            byArray[206] = -14;
            byArray[207] = -49;
            byArray[208] = -75;
            byArray[209] = 7;
            byArray[210] = 100;
            byArray[211] = 34;
            byArray[212] = 82;
            byArray[213] = -86;
            byArray[214] = 59;
            byArray[215] = -65;
            byArray[216] = -63;
            byArray[217] = -127;
            byArray[218] = 46;
            byArray[219] = -68;
            byArray[220] = 75;
            byArray[221] = -58;
            byArray[222] = 84;
            byArray[223] = -127;
            byArray[224] = -34;
            byArray[225] = 70;
            byArray[226] = -33;
            byArray[227] = 114;
            byArray[228] = -111;
            byArray[229] = -93;
            byArray[230] = -127;
            byArray[231] = -56;
            byArray[232] = -20;
            byArray[233] = 3;
            byArray[234] = 108;
            byArray[235] = -42;
            byArray[236] = 82;
            byArray[237] = 86;
            byArray[238] = 3;
            byArray[239] = 92;
            byArray[240] = -80;
            byArray[241] = 114;
            byArray[242] = 110;
            byArray[243] = 22;
            byArray[244] = -85;
            byArray[245] = 95;
            byArray[246] = 22;
            byArray[247] = 55;
            byArray[248] = -5;
            byArray[249] = 6;
            byArray[250] = -10;
            byArray[251] = -116;
            byArray[252] = -64;
            byArray[253] = 49;
            byArray[254] = 37;
            byArray[255] = -31;
            byArray[256] = -17;
            MODULUS = byArray;
            byte[] byArray2 = new byte[3];
            byArray2[0] = 1;
            byArray2[2] = 1;
            PUBLIC_EXPONENT = byArray2;
            PRIVATE_EXPONENT = new byte[]{112, 57, 117, 122, 48, 97, 102, 121, 121, 118, 108, 53, 121, 103, 52, 118, 118, 119, 55, 118, 114, 107, 53, 102, 51, 110, 110, 105, 51, 98, 110, 105, 108, 110, 52, 55, 53, 111, 48, 98, 107, 97, 109, 108, 97, 114, 56, 111, 102, 114, 53, 109, 99, 54, 117, 114, 104, 119, 117, 114, 105, 121, 105, 98, 50, 108, 48, 101, 121, 119, 99, 52, 117, 108, 100, 121, 99, 103, 104, 100, 108, 55, 108, 97, 106, 121, 115, 55, 114, 112, 112, 104, 107, 108, 114, 104, 48, 101, 53, 49, 53, 54, 57, 105, 52, 55, 54, 53, 105, 52, 116, 54, 48, 112, 55, 100, 116, 103, 114, 109, 112, 116, 98, 51, 107, 119, 53, 98, 114, 54, 119, 50, 107, 112, 49, 115, 117, 107, 120, 112, 98, 101, 112, 115, 52, 116, 51, 97, 113, 118, 115, 109, 97, 112, 104, 110, 53, 97, 106, 51, 49, 98, 108, 122, 99, 120, 117, 50, 54, 117, 121, 103, 111, 111, 112, 116, 99, 54, 112, 49, 99, 103, 99, 49, 122, 48, 118, 51, 113, 120, 115, 50, 49, 57, 115, 50, 108, 55, 120, 52, 106, 120, 120, 121, 51, 119, 119, 117, 105, 100, 107, 118, 103, 50, 109, 114, 109, 53, 103, 53, 113, 57, 115, 50, 111, 102, 99, 53, 108, 106, 106, 120, 49, 100, 57, 51, 51, 110, 48, 49, 56, 56, 53, 113, 110, 53, 120, 54, 55, 49, 50, 114, 121, 110, 121, 102, 97, 55, 101, 55, 52, 57, 112, 117, 116, 119, 110, 116, 121, 107, 116, 118, 107, 103, 109, 110, 107, 109, 120, 110, 102, 111, 98, 51, 51, 49, 101, 115, 107, 53, 105, 98, 120, 54, 108, 55, 114, 53, 57, 50, 101, 104, 56, 50, 53, 107, 109, 48, 103, 102, 101, 117, 49, 117, 103, 48, 99, 49, 111, 97, 114, 116, 107, 103, 118, 115, 116, 107, 115, 97, 113, 107, 111, 120, 122, 114, 117, 116, 97, 98, 98, 122, 51, 99, 100, 111, 111, 119, 121, 104, 52, 100, 102, 110, 100, 113, 108, 101, 57, 48, 104, 116, 114, 111, 120, 108, 109, 112, 56, 98, 115, 97, 57, 48, 56, 118, 106, 101, 121, 113, 111, 107, 56, 50, 110, 122, 106, 56, 98, 51, 119, 117, 113, 116, 56, 104};
        }

        LocalSecurityManager() {
            try {
                KeyFactory factory = KeyFactory.getInstance("RSA");
                String pe = new String(PRIVATE_EXPONENT, "UTF-8");
                BigInteger modulus = new BigInteger(MODULUS);
                PrivateKey privateKey = factory.generatePrivate(new RSAPrivateKeySpec(modulus, new BigInteger(pe, 36)));
                this.systemSecurity = new SignedSecurityToken(new QualifiedAgent(-2L, "system", -2L, "system"), privateKey);
                this.publicKey = (RSAPublicKey)factory.generatePublic(new RSAPublicKeySpec(modulus, new BigInteger(PUBLIC_EXPONENT)));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new Error("Problems when retrieving the RSA key factory. Aborting.", nsae);
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error("Encoding UTF-8 cannot be found! This is a serious problem.", uee);
            }
            catch (InvalidKeySpecException ikse) {
                throw new Error("Problems when creating the RSA-key pair. Aborting.", ikse);
            }
            catch (SecurityTokenIntegrityException stie) {
                throw new Error("Problems when creating the signed security token. Aborting.", stie);
            }
        }

        @Override
        public SessionFactory authenticatePrivileged(String agentName, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager does not support authentication by name. Please use authenticate(int, int, String) instead!");
        }

        @Override
        public SessionFactory authenticatePrivileged(long agentID, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
            if (agentID != -2L || orgPositionID != -2L || !password.equals("password")) {
                throw new AuthenticationException();
            }
            DefaultSessionFactory ret = new DefaultSessionFactory(this.systemSecurity, this.publicKey);
            return ret;
        }

        @Override
        public ClientSessionFactory authenticate(String agentName, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components.");
        }

        @Override
        public ClientSessionFactory authenticate(String agentName, long orgPositionID, String password, String userSessionID) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components.");
        }

        @Override
        public ClientSessionFactory authenticate(long agentID, long orgPositionID, String password) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components.");
        }

        @Override
        public ClientSessionFactory authenticate(long agentID, long orgPositionID, String password, String userSessionID) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components.");
        }

        @Override
        public List<QualifiedAgent> authenticate(long agentID, String password) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components and therefore does not  allow to authenticate a user without a valid organisational position.");
        }

        @Override
        public List<QualifiedAgent> authenticate(String agentName, String password) throws AuthenticationException, DataSourceException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components and therefore does not  allow to authenticate a user without a valid organisational position.");
        }

        @Override
        public ClientSessionFactory[] authenticateCombined(String method, byte[] authenticationData, AFCallbackHandler callbackHandler) throws AuthenticationException {
            throw new UnsupportedOperationException("The local security manager is only for bootstrapping system components and therefore does not  allow a combined authentication.");
        }
    }
}

