/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.util.StackTraceTools;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class CSVFormatter
extends Formatter {
    static final String RECORD_SEPARATION_STRING = "\r\n";
    static final char FIELD_SEPARATION_CHAR = ';';
    static final String FIELD_SEPARATION_STRING = ";";
    static final char FIELD_ENCLOSING_CHAR = '\"';
    static final String FIELD_ENCLOSING_STRING = "\"";
    static final String FIELD_ENCLOSING_CHAR_ESCAPE = "\"\"";

    @Override
    public String format(LogRecord record) {
        Object[] params = record.getParameters();
        StringBuilder ret = new StringBuilder();
        ret.append(record.getLevel().toString());
        ret.append(';');
        ret.append(this.escape(record.getLoggerName()));
        ret.append(';');
        ret.append(record.getSourceClassName());
        ret.append(';');
        ret.append(record.getSourceMethodName());
        ret.append(';');
        ret.append(this.escape(record.getMessage()));
        ret.append(';');
        ret.append(record.getMillis());
        ret.append(';');
        ret.append(String.format("%1$tY-%1$tm-%1$tdT%1$tH:%1$tM:%1$tS.%1$tL", record.getMillis()));
        ret.append(';');
        if (params != null && params[0] instanceof Long) {
            ret.append(params[0].toString());
        }
        ret.append(';');
        ret.append(record.getSequenceNumber());
        ret.append(';');
        ret.append(record.getThreadID());
        ret.append(';');
        if (record.getThrown() != null) {
            ret.append(this.escape(StackTraceTools.stackTraceToString(record.getThrown())));
        }
        ret.append(';');
        SessionToken session = null;
        QualifiedAgent tlQA = null;
        QualifiedAgent qa = null;
        if (params != null && params[3] instanceof SessionToken) {
            session = (SessionToken)params[3];
        }
        if (params != null && params[4] instanceof QualifiedAgent) {
            tlQA = (QualifiedAgent)params[4];
        }
        if (params != null && params[5] instanceof QualifiedAgent) {
            qa = (QualifiedAgent)params[5];
        }
        if (params != null && params[1] instanceof String) {
            ret.append(params[1]);
        }
        ret.append(';');
        if (params != null && params[2] instanceof String) {
            ret.append(params[2]);
        }
        ret.append(';');
        if (session != null) {
            ret.append(session.getSessionID());
        }
        ret.append(';');
        if (tlQA != null) {
            ret.append(tlQA.getAgentID());
        }
        ret.append(';');
        if (tlQA != null) {
            ret.append(this.escape(tlQA.getAgentUserName()));
        }
        ret.append(';');
        if (tlQA != null) {
            ret.append(tlQA.getOrgPositionID());
        }
        ret.append(';');
        if (tlQA != null) {
            ret.append(this.escape(tlQA.getOrgPositionName()));
        }
        ret.append(';');
        if (session != null) {
            ret.append(session.getChildSessionID());
        }
        ret.append(';');
        if (session != null) {
            ret.append(session.getChildLevel());
        }
        ret.append(';');
        if (qa != null) {
            ret.append(qa.getAgentID());
        }
        ret.append(';');
        if (qa != null) {
            ret.append(this.escape(qa.getAgentUserName()));
        }
        ret.append(';');
        if (qa != null) {
            ret.append(qa.getOrgPositionID());
        }
        ret.append(';');
        if (qa != null) {
            ret.append(this.escape(qa.getOrgPositionName()));
        }
        ret.append(';');
        if (params != null && params[6] instanceof UUID) {
            ret.append(params[6].toString());
        }
        ret.append(';');
        if (params != null && params[7] instanceof UUID) {
            ret.append(params[7].toString());
        }
        ret.append(';');
        if (params != null && params[8] instanceof UUID) {
            ret.append(params[8].toString());
        }
        ret.append(';');
        if (params != null && params[9] instanceof UUID) {
            ret.append(params[9].toString());
        }
        ret.append(';');
        if (params != null && params[10] instanceof Integer) {
            ret.append(params[10]);
        }
        ret.append(';');
        if (params != null && params[11] instanceof Integer) {
            ret.append(params[11]);
        }
        ret.append(';');
        if (params != null && params[12] instanceof EBPType) {
            ret.append(params[12]);
        }
        ret.append(RECORD_SEPARATION_STRING);
        return ret.toString();
    }

    @Override
    public String getHead(Handler h) {
        StringBuilder ret = new StringBuilder();
        ret.append("LogRecord - Level");
        ret.append(';');
        ret.append("LR - LoggerName");
        ret.append(';');
        ret.append("LR - Class");
        ret.append(';');
        ret.append("LR - Method");
        ret.append(';');
        ret.append("LR - Message");
        ret.append(';');
        ret.append("LR - TimeInMillis");
        ret.append(';');
        ret.append("LR - Date");
        ret.append(';');
        ret.append("LR - TimeInNanos");
        ret.append(';');
        ret.append("LR - SequenceNumber");
        ret.append(';');
        ret.append("LR - ThreadID");
        ret.append(';');
        ret.append("LR - Thrown");
        ret.append(';');
        ret.append("Service - InstanceName");
        ret.append(';');
        ret.append("Arbitrary String");
        ret.append(';');
        ret.append("Top-level session token - ID");
        ret.append(';');
        ret.append("TLST - AgentID");
        ret.append(';');
        ret.append("TLST - AgentUserName");
        ret.append(';');
        ret.append("TLST - OrgPosID");
        ret.append(';');
        ret.append("TLST - OrgPosName");
        ret.append(';');
        ret.append("Session token - ID");
        ret.append(';');
        ret.append("ST - ChildLevel");
        ret.append(';');
        ret.append("ST - AgentID");
        ret.append(';');
        ret.append("ST - AgentUserName");
        ret.append(';');
        ret.append("ST - OrgPosID");
        ret.append(';');
        ret.append("ST - OrgPosName");
        ret.append(';');
        ret.append("Template");
        ret.append(';');
        ret.append("Base Template");
        ret.append(';');
        ret.append("Embedded Template");
        ret.append(';');
        ret.append("InstanceID");
        ret.append(';');
        ret.append("NodeID");
        ret.append(';');
        ret.append("NodeIteration");
        ret.append(';');
        ret.append("EBPType");
        ret.append(RECORD_SEPARATION_STRING);
        return ret.toString();
    }

    protected String escape(String string) {
        return this.escapeRequired(string) ? this.escapedString(string) : string;
    }

    protected boolean escapeRequired(String string) {
        return string.contains(FIELD_SEPARATION_STRING) || string.contains("\n") || string.contains(FIELD_ENCLOSING_STRING);
    }

    protected String escapedString(String string) {
        return String.format("%1$s%2$s%1$s", FIELD_ENCLOSING_STRING, string.replace(FIELD_ENCLOSING_STRING, FIELD_ENCLOSING_CHAR_ESCAPE));
    }
}

