/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.configuration.SystemPropertyConfigurationManager;
import de.aristaflow.adept2.base.registry.LoggerInitialisation;
import java.io.File;
import org.apache.commons.configuration.Configuration;

public class FileConfigurationManager
extends SystemPropertyConfigurationManager<Configuration> {
    protected FileConfigurationManager(Configuration rootConfiguration, String[] configDirectories) throws ConfigurationException {
        super(rootConfiguration, configDirectories);
    }

    private FileConfigurationManager(Configuration rootConfiguration) throws ConfigurationException {
        super(rootConfiguration);
        if (this.getBootConfigurationManager() != this) {
            String msg = "The boot configuration manager has already been set and must not be created a second time. Aborting creation of it.";
            throw new ConfigurationException(msg);
        }
        Configuration loggerConfiguration = rootConfiguration.subset("Logging");
        LoggerInitialisation.initialiseConsoleHandler(loggerConfiguration);
        LoggerInitialisation.initialiseFileLogging(loggerConfiguration, FileConfigurationManager.getLogDir(), FileConfigurationManager.getLogDirDefault());
        this.logger.info("\n---------------------------------------------------------------------\n-----------    Bootstrapping initialised successfully.    -----------\n---------------------------------------------------------------------");
    }

    public static ConfigurationManager<Configuration> initialiseConfigurationManager(Configuration rootConfiguration) throws ConfigurationException {
        LoggerInitialisation.initialiseDebugLogging(FileConfigurationManager.getDebugConfig());
        return new FileConfigurationManager(rootConfiguration);
    }

    @Override
    protected Configuration initFileBasedRootConfiguration(Configuration rootConfiguration) throws ConfigurationException {
        return rootConfiguration;
    }

    @Override
    public ConfigurationManager<? extends Configuration> createChild(Configuration configuration) throws ConfigurationException {
        String[] configDirectories = new String[this.configDirectories.size()];
        int i = 0;
        while (i < configDirectories.length) {
            configDirectories[i] = ((File)this.configDirectories.get(i)).getPath();
            ++i;
        }
        return new FileConfigurationManager(configuration, configDirectories);
    }
}

