/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.registry.PluginRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public abstract class InstanceToInstanceRegistry
extends PluginRegistry {
    protected final Map<String, Map<String, String>> usedInstances = new HashMap<String, Map<String, String>>();

    protected InstanceToInstanceRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
    }

    @Override
    protected void renewConfiguration(Configuration configuration) throws ConfigurationException {
        super.renewConfiguration(configuration);
        this.readUsedInstances(configuration);
    }

    private void readUsedInstances(Configuration configuration) throws ConfigurationException {
        for (String usingInstance : this.declaredInstances.keySet()) {
            Map<String, String> used = this.usedInstances.get(usingInstance);
            if (used != null) continue;
            used = new HashMap<String, String>();
            this.usedInstances.put(usingInstance, used);
            AbstractRegistry.InstanceInformation instanceInformation = this.getInstanceInformation(usingInstance);
            for (String usedComponentType : this.componentInterfaces.keySet()) {
                String usedInstance = this.getUsedInstance(usingInstance, instanceInformation.componentType, usedComponentType, configuration);
                if (!ConfigurationTools.stringValid(usedInstance)) continue;
                used.put(usedComponentType, usedInstance);
                this.logger.fine(String.format("Instance '%1$s' is using '%2$s'.", usingInstance, usedInstance));
            }
        }
    }

    private String getUsedInstance(String usingInstanceName, String usingComponentType, String usedComponentType, Configuration configuration) {
        String ret = configuration.getString(String.valueOf(InstanceToInstanceRegistry.getSimpleInstanceName(usingInstanceName)) + "." + usedComponentType);
        if (!ConfigurationTools.stringValid(ret)) {
            ret = configuration.getString(String.valueOf(usingComponentType) + "." + usedComponentType);
        }
        if (ret != null) {
            ret = InstanceToInstanceRegistry.getHierarchicalInstanceName(usedComponentType, ret);
        }
        return ret;
    }

    protected <T> T getUsedObjectForInstance(String usingInstance, String usedComponentType, Class<T> requestedType) throws ConfigurationException {
        String otherInstanceName = this.getUsedComponentInstanceNameForInstance(usingInstance, usedComponentType);
        return this.getObjectForInstanceName(otherInstanceName, requestedType, new Class[0], new Object[0]);
    }

    protected String getUsedComponentInstanceNameForInstance(String usingInstance, String usedComponentType) throws ConfigurationException {
        String ret;
        String message;
        Map<String, String> used = this.usedInstances.get(usingInstance);
        if (this.declaredInstances.get(usingInstance) == null) {
            message = String.format("QA Notice: Requesting component instance '%1$s' is not registered in the registry.", usingInstance);
            this.logger.fine(message);
        }
        if (used == null) {
            this.logger.info(String.format("No usage declared for instance '%1$s'. Using default instance of '%2$s'.", usingInstance, usedComponentType));
            ret = (String)this.defaultInstances.get(usedComponentType);
        } else {
            ret = used.get(usedComponentType);
            if (!ConfigurationTools.stringValid(ret)) {
                this.logger.info(String.format("No usage of a component of type '%1$s' declared for instance '%2$s'. Using default instance of '%1$s'.", usedComponentType, usingInstance));
                ret = (String)this.defaultInstances.get(usedComponentType);
            }
        }
        if (ret == null) {
            message = String.format("No default instance for type '%1$s' for usage by '%2$s' found. Either the configuration is invalid or the type is misspelled.", usedComponentType, usingInstance);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        return ret;
    }
}

